/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.deployment.spi;

import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.standalone.DeploymentAction;
import org.jboss.as.controller.client.helpers.standalone.DeploymentPlan;
import org.jboss.as.controller.client.helpers.standalone.InitialDeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentActionResult;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentManager;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentPlanResult;
import org.jboss.as.ee.deployment.spi.JBossTarget;
import org.jboss.as.ee.deployment.spi.TargetModuleIDImpl;
import org.jboss.as.ee.deployment.spi.URIParser;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;

final class DeploymentManagerTarget
extends JBossTarget {
    static final Logger log = Logger.getLogger(DeploymentManagerTarget.class);
    static final String DESCRIPTION = "ServerDeploymentManager target";
    private final Map<TargetModuleID, String> runtimeNames = new HashMap<TargetModuleID, String>();
    private final ModelControllerClient modelControllerClient;
    private final ServerDeploymentManager deploymentManager;
    private final URI deployURI;

    public DeploymentManagerTarget(URI deployURI) {
        log.debug((Object)("new DeploymentManagerTarget: " + deployURI));
        try {
            URIParser parser = new URIParser(deployURI);
            String serverHost = parser.getParameter("serverHost");
            String serverPort = parser.getParameter("serverPort");
            String host = serverHost != null ? serverHost : "127.0.0.1";
            Integer port = serverPort != null ? Integer.parseInt(serverPort) : 9999;
            this.modelControllerClient = ModelControllerClient.Factory.create((String)host, (int)port);
            this.deploymentManager = ServerDeploymentManager.Factory.create((ModelControllerClient)this.modelControllerClient);
            this.deployURI = deployURI;
        }
        catch (UnknownHostException ex) {
            throw new IllegalArgumentException("Cannot connect to management target: " + deployURI, ex);
        }
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return this.deployURI.toString();
    }

    @Override
    public void deploy(TargetModuleID targetModuleID) throws Exception {
        log.infof("Begin deploy: %s", (Object)targetModuleID);
        InitialDeploymentPlanBuilder builder = this.deploymentManager.newDeploymentPlan();
        builder = builder.add(targetModuleID.getModuleID(), new URL(targetModuleID.getModuleID())).andDeploy();
        DeploymentPlan plan = builder.build();
        DeploymentAction deployAction = builder.getLastAction();
        String runtimeName = this.executeDeploymentPlan(plan, deployAction);
        this.runtimeNames.put(targetModuleID, runtimeName);
        log.infof("End deploy: %s", (Object)targetModuleID);
    }

    @Override
    public void start(TargetModuleID targetModuleID) throws Exception {
    }

    @Override
    public void stop(TargetModuleID targetModuleID) throws Exception {
    }

    @Override
    public void undeploy(TargetModuleID targetModuleID) throws Exception {
        String runtimeName = this.runtimeNames.remove(targetModuleID);
        if (runtimeName != null) {
            InitialDeploymentPlanBuilder builder = this.deploymentManager.newDeploymentPlan();
            DeploymentPlan plan = builder.undeploy(runtimeName).remove(runtimeName).build();
            Future future = this.deploymentManager.execute(plan);
            future.get();
        }
    }

    @Override
    public TargetModuleID[] getAvailableModules(ModuleType filterType) throws TargetException {
        try {
            ArrayList<TargetModuleIDImpl> list = new ArrayList<TargetModuleIDImpl>();
            ModelNode operation = new ModelNode();
            operation.get("operation").set("read-children-names");
            operation.get("child-type").set("deployment");
            ModelNode result = this.modelControllerClient.execute(operation);
            if ("failed".equals(result.get("outcome").asString())) {
                throw new IllegalStateException("Management request failed: " + result);
            }
            List nodeList = result.get("result").asList();
            for (ModelNode node : nodeList) {
                String moduleID = node.asString();
                ModuleType moduleType = null;
                if (moduleID.endsWith(".ear")) {
                    moduleType = ModuleType.EAR;
                } else if (moduleID.endsWith(".war")) {
                    moduleType = ModuleType.WAR;
                } else if (moduleID.endsWith(".jar")) {
                    moduleType = ModuleType.EJB;
                }
                if (moduleType == null) {
                    log.warnf("Cannot determine module type of: %s", (Object)node);
                    continue;
                }
                if (filterType != null && !filterType.equals(moduleType)) continue;
                TargetModuleIDImpl targetModuleID = new TargetModuleIDImpl(this, moduleID, null, moduleType);
                targetModuleID.setRunning(true);
                list.add(targetModuleID);
            }
            TargetModuleID[] targetModuleIDs = new TargetModuleID[list.size()];
            list.toArray(targetModuleIDs);
            return targetModuleIDs;
        }
        catch (Exception e) {
            TargetException tex = new TargetException("Failed to get available modules");
            tex.initCause((Throwable)e);
            throw tex;
        }
    }

    private String executeDeploymentPlan(DeploymentPlan plan, DeploymentAction deployAction) throws Exception {
        Exception deploymentException;
        Future future = this.deploymentManager.execute(plan);
        ServerDeploymentPlanResult planResult = (ServerDeploymentPlanResult)future.get();
        ServerDeploymentActionResult actionResult = planResult.getDeploymentActionResult(deployAction.getId());
        if (actionResult != null && (deploymentException = (Exception)actionResult.getDeploymentException()) != null) {
            throw deploymentException;
        }
        return deployAction.getDeploymentUnitUniqueName();
    }
}

