/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.deployment.spi;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.jboss.as.ee.deployment.spi.DeploymentLogger;
import org.jboss.as.ee.deployment.spi.DeploymentMessages;
import org.jboss.as.ee.deployment.spi.JBossTarget;
import org.jboss.as.ee.deployment.spi.status.ProgressObjectImpl;

final class DeploymentWorker
extends Thread {
    private ProgressObjectImpl progress;

    DeploymentWorker(ProgressObject progress) {
        this.progress = (ProgressObjectImpl)progress;
    }

    @Override
    public void run() {
        DeploymentLogger.ROOT_LOGGER.tracef("Begin run", new Object[0]);
        CommandType cmdType = this.progress.getDeploymentStatus().getCommand();
        TargetModuleID[] modules = this.progress.getResultTargetModuleIDs();
        for (int i = 0; i < modules.length; ++i) {
            TargetModuleID moduleid = modules[i];
            JBossTarget target = (JBossTarget)moduleid.getTarget();
            try {
                this.progress.sendProgressEvent(StateType.RUNNING, DeploymentMessages.MESSAGES.operationStarted(cmdType), moduleid);
                if (cmdType == CommandType.DISTRIBUTE) {
                    target.deploy(moduleid);
                    this.deleteDeployment(moduleid);
                } else if (cmdType == CommandType.START) {
                    target.start(moduleid);
                } else if (cmdType == CommandType.STOP) {
                    target.stop(moduleid);
                } else if (cmdType == CommandType.UNDEPLOY) {
                    target.undeploy(moduleid);
                    this.deleteDeployment(moduleid);
                }
                this.progress.sendProgressEvent(StateType.COMPLETED, DeploymentMessages.MESSAGES.operationCompleted(cmdType), moduleid);
                continue;
            }
            catch (Exception e) {
                String message = DeploymentMessages.MESSAGES.operationFailedOnTarget(cmdType, target);
                this.progress.sendProgressEvent(StateType.FAILED, message, moduleid);
                DeploymentLogger.ROOT_LOGGER.errorf(e, message, new Object[0]);
            }
        }
        DeploymentLogger.ROOT_LOGGER.tracef("End run", new Object[0]);
    }

    private void deleteDeployment(TargetModuleID moduleid) throws MalformedURLException {
        File deployment = new File(new URL(moduleid.getModuleID()).getPath());
        if (deployment.exists()) {
            if (!deployment.delete()) {
                DeploymentLogger.ROOT_LOGGER.cannotDeleteDeploymentFile(deployment);
                deployment.deleteOnExit();
            }
        } else {
            DeploymentLogger.ROOT_LOGGER.deploymentDoesNotExist(deployment);
        }
    }
}

