/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.deployment.spi;

import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.standalone.DeploymentAction;
import org.jboss.as.controller.client.helpers.standalone.DeploymentPlan;
import org.jboss.as.controller.client.helpers.standalone.InitialDeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentActionResult;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentManager;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentPlanResult;
import org.jboss.as.ee.deployment.spi.DeploymentLogger;
import org.jboss.as.ee.deployment.spi.DeploymentMessages;
import org.jboss.as.ee.deployment.spi.JBossTarget;
import org.jboss.as.ee.deployment.spi.TargetModuleExt;
import org.jboss.as.ee.deployment.spi.TargetModuleIDImpl;
import org.jboss.dmr.ModelNode;

final class DeploymentManagerTarget
extends JBossTarget {
    static final String DESCRIPTION = "ServerDeploymentManager target";
    private final Map<TargetModuleID, Boolean> runtimeState = new HashMap<TargetModuleID, Boolean>();
    private final ModelControllerClient modelControllerClient;
    private final ServerDeploymentManager deploymentManager;
    private final URI deployURI;

    public DeploymentManagerTarget(URI deployURI, ModelControllerClient modelControllerClient) {
        DeploymentLogger.ROOT_LOGGER.debugf("new DeploymentManagerTarget: %s", deployURI);
        this.modelControllerClient = modelControllerClient;
        this.deploymentManager = ServerDeploymentManager.Factory.create((ModelControllerClient)modelControllerClient);
        this.deployURI = deployURI;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return this.deployURI.toString();
    }

    @Override
    public void deploy(TargetModuleID targetModuleID) throws Exception {
        DeploymentLogger.ROOT_LOGGER.beginDeploy(targetModuleID);
        InitialDeploymentPlanBuilder builder = this.deploymentManager.newDeploymentPlan();
        TargetModuleExt targetModule = (TargetModuleExt)targetModuleID;
        URL contentURL = targetModule.getContentFile().toURI().toURL();
        builder = builder.add(targetModule.getModuleID(), contentURL).andDeploy();
        DeploymentPlan plan = builder.build();
        DeploymentAction deployAction = builder.getLastAction();
        this.executeDeploymentPlan(plan, deployAction);
        DeploymentLogger.ROOT_LOGGER.endDeploy(targetModuleID);
    }

    @Override
    public void start(TargetModuleID targetModuleID) throws Exception {
        ((TargetModuleIDImpl)targetModuleID).setRunning(Boolean.TRUE);
        this.runtimeState.put(targetModuleID, Boolean.TRUE);
    }

    @Override
    public void stop(TargetModuleID targetModuleID) throws Exception {
        ((TargetModuleIDImpl)targetModuleID).setRunning(Boolean.FALSE);
        this.runtimeState.put(targetModuleID, Boolean.FALSE);
    }

    @Override
    public void undeploy(TargetModuleID targetModuleID) throws Exception {
        String deploymentName = targetModuleID.getModuleID();
        InitialDeploymentPlanBuilder builder = this.deploymentManager.newDeploymentPlan();
        DeploymentPlan plan = builder.undeploy(deploymentName).remove(deploymentName).build();
        Future future = this.deploymentManager.execute(plan);
        future.get();
    }

    @Override
    public TargetModuleID[] getAvailableModules(ModuleType filterType) throws TargetException {
        try {
            ArrayList<TargetModuleIDImpl> list = new ArrayList<TargetModuleIDImpl>();
            ModelNode operation = new ModelNode();
            operation.get("operation").set("read-children-names");
            operation.get("child-type").set("deployment");
            ModelNode result = this.modelControllerClient.execute(operation);
            if ("failed".equals(result.get("outcome").asString())) {
                throw new IllegalStateException(DeploymentMessages.MESSAGES.managementRequestFailed(result));
            }
            List nodeList = result.get("result").asList();
            for (ModelNode node : nodeList) {
                TargetModuleIDImpl targetModuleID;
                String moduleID = node.asString();
                ModuleType moduleType = null;
                if (moduleID.endsWith(".ear")) {
                    moduleType = ModuleType.EAR;
                } else if (moduleID.endsWith(".war")) {
                    moduleType = ModuleType.WAR;
                } else if (moduleID.endsWith(".rar")) {
                    moduleType = ModuleType.RAR;
                } else if (moduleID.endsWith(".jar")) {
                    moduleType = ModuleType.EJB;
                }
                if (moduleType == null) {
                    DeploymentLogger.ROOT_LOGGER.cannotDetermineModuleType(node);
                    continue;
                }
                if (filterType != null && !filterType.equals(moduleType)) continue;
                Boolean state = this.runtimeState.get(targetModuleID = new TargetModuleIDImpl(this, moduleID, null, moduleType, null));
                targetModuleID.setRunning(state != null ? state : Boolean.TRUE);
                list.add(targetModuleID);
            }
            TargetModuleID[] targetModuleIDs = new TargetModuleID[list.size()];
            list.toArray(targetModuleIDs);
            return targetModuleIDs;
        }
        catch (Exception e) {
            TargetException tex = new TargetException("Failed to get available modules");
            tex.initCause((Throwable)e);
            throw tex;
        }
    }

    private void executeDeploymentPlan(DeploymentPlan plan, DeploymentAction deployAction) throws Exception {
        Exception deploymentException;
        Future future = this.deploymentManager.execute(plan);
        ServerDeploymentPlanResult planResult = (ServerDeploymentPlanResult)future.get();
        ServerDeploymentActionResult actionResult = planResult.getDeploymentActionResult(deployAction.getId());
        if (actionResult != null && (deploymentException = (Exception)actionResult.getDeploymentException()) != null) {
            throw deploymentException;
        }
    }
}

