/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.beanvalidation;

import java.util.Collections;
import java.util.List;
import javax.validation.Configuration;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.TraversableResolver;
import javax.validation.Validation;
import javax.validation.ValidationProviderResolver;
import javax.validation.Validator;
import javax.validation.ValidatorContext;
import javax.validation.ValidatorFactory;
import javax.validation.spi.ValidationProvider;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;
import org.hibernate.validator.cfg.ConstraintMapping;
import org.jboss.as.ee.beanvalidation.SecurityActions;

public class LazyValidatorFactory
implements ValidatorFactory {
    private final Configuration<?> configuration;
    private final ClassLoader classLoader;
    private volatile ValidatorFactory delegate;

    public LazyValidatorFactory(ClassLoader classLoader) {
        this(null, classLoader);
    }

    public LazyValidatorFactory(Configuration<?> configuration, ClassLoader classLoader) {
        this.configuration = configuration;
        this.classLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValidatorFactory getDelegate() {
        ValidatorFactory result = this.delegate;
        if (result == null) {
            LazyValidatorFactory lazyValidatorFactory = this;
            synchronized (lazyValidatorFactory) {
                result = this.delegate;
                if (result == null) {
                    this.delegate = result = this.initFactory();
                }
            }
        }
        return result;
    }

    public Validator getValidator() {
        return this.getDelegate().getValidator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValidatorFactory initFactory() {
        ClassLoader oldTCCL = SecurityActions.getContextClassLoader();
        try {
            SecurityActions.setContextClassLoader(oldTCCL);
            if (this.configuration == null) {
                ValidatorFactory factory;
                ConstraintMapping mapping = new ConstraintMapping();
                HibernateValidatorConfiguration config = (HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).providerResolver((ValidationProviderResolver)new JbossProviderResolver()).configure();
                config.addMapping(mapping);
                ValidatorFactory validatorFactory = factory = config.buildValidatorFactory();
                return validatorFactory;
            }
            ValidatorFactory validatorFactory = this.configuration.buildValidatorFactory();
            return validatorFactory;
        }
        finally {
            SecurityActions.setContextClassLoader(oldTCCL);
        }
    }

    public ValidatorContext usingContext() {
        return this.getDelegate().usingContext();
    }

    public MessageInterpolator getMessageInterpolator() {
        return this.getDelegate().getMessageInterpolator();
    }

    public TraversableResolver getTraversableResolver() {
        return this.getDelegate().getTraversableResolver();
    }

    public ConstraintValidatorFactory getConstraintValidatorFactory() {
        return this.getDelegate().getConstraintValidatorFactory();
    }

    public <T> T unwrap(Class<T> clazz) {
        return (T)this.getDelegate().unwrap(clazz);
    }

    private static final class JbossProviderResolver
    implements ValidationProviderResolver {
        private JbossProviderResolver() {
        }

        public List<ValidationProvider<?>> getValidationProviders() {
            return Collections.singletonList(new HibernateValidator());
        }
    }
}

