/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.BindingConfiguration;
import org.jboss.as.ee.component.ClassDescriptionTraversal;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentNamingMode;
import org.jboss.as.ee.component.EEApplicationDescription;
import org.jboss.as.ee.component.EEModuleClassConfiguration;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.component.EEModuleConfiguration;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.component.InterceptorDescription;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BindingHandleService;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.logging.Logger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;

public class ModuleJndiBindingProcessor
implements DeploymentUnitProcessor {
    private static final Logger logger = Logger.getLogger(ModuleJndiBindingProcessor.class);

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEApplicationDescription applicationDescription = (EEApplicationDescription)deploymentUnit.getAttachment(Attachments.EE_APPLICATION_DESCRIPTION);
        EEModuleConfiguration moduleConfiguration = (EEModuleConfiguration)deploymentUnit.getAttachment(Attachments.EE_MODULE_CONFIGURATION);
        if (moduleConfiguration == null) {
            return;
        }
        Set dependencies = (Set)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.JNDI_DEPENDENCIES);
        HashMap<ServiceName, BindingConfiguration> deploymentDescriptorBindings = new HashMap<ServiceName, BindingConfiguration>();
        IntHolder moduleCount = new IntHolder();
        List<BindingConfiguration> bindingConfigurations = moduleConfiguration.getBindingConfigurations();
        ServiceName moduleOwnerName = deploymentUnit.getServiceName().append(new String[]{"module"}).append(new String[]{moduleConfiguration.getApplicationName()}).append(new String[]{moduleConfiguration.getModuleName()});
        for (BindingConfiguration binding : bindingConfigurations) {
            ServiceName serviceName = ContextNames.serviceNameOfEnvEntry((String)moduleConfiguration.getApplicationName(), (String)moduleConfiguration.getModuleName(), null, (boolean)false, (String)binding.getName());
            deploymentDescriptorBindings.put(serviceName, binding);
            this.addJndiBinding(moduleConfiguration, binding, phaseContext, serviceName, moduleOwnerName, moduleCount, dependencies);
        }
        for (ComponentConfiguration componentConfiguration : moduleConfiguration.getComponentConfigurations()) {
            for (BindingConfiguration binding : componentConfiguration.getComponentDescription().getBindingConfigurations()) {
                boolean compBinding;
                String bindingName = binding.getName();
                boolean bl = compBinding = bindingName.startsWith("java:comp") || !bindingName.startsWith("java:");
                if (componentConfiguration.getComponentDescription().getNamingMode() == ComponentNamingMode.CREATE && compBinding) continue;
                ServiceName serviceName = ContextNames.serviceNameOfEnvEntry((String)moduleConfiguration.getApplicationName(), (String)moduleConfiguration.getModuleName(), null, (boolean)false, (String)binding.getName());
                deploymentDescriptorBindings.put(serviceName, binding);
                this.addJndiBinding(moduleConfiguration, binding, phaseContext, serviceName, moduleOwnerName, moduleCount, dependencies);
            }
        }
        HashSet<String> handledClasses = new HashSet<String>();
        for (ComponentConfiguration componentConfiguration : moduleConfiguration.getComponentConfigurations()) {
            HashSet<EEModuleClassConfiguration> classConfigurations = new HashSet<EEModuleClassConfiguration>();
            classConfigurations.add(componentConfiguration.getModuleClassConfiguration());
            for (InterceptorDescription interceptor : componentConfiguration.getComponentDescription().getAllInterceptors()) {
                EEModuleClassConfiguration interceptorClass = applicationDescription.getClassConfiguration(interceptor.getInterceptorClassName());
                if (interceptorClass == null) continue;
                classConfigurations.add(interceptorClass);
            }
            this.processClassConfigurations(phaseContext, applicationDescription, moduleConfiguration, deploymentDescriptorBindings, handledClasses, componentConfiguration.getComponentDescription().getNamingMode(), classConfigurations, componentConfiguration.getComponentName(), moduleOwnerName, moduleCount, dependencies);
        }
    }

    private void processClassConfigurations(final DeploymentPhaseContext phaseContext, EEApplicationDescription applicationDescription, final EEModuleConfiguration moduleConfiguration, final Map<ServiceName, BindingConfiguration> deploymentDescriptorBindings, final Set<String> handledClasses, final ComponentNamingMode namingMode, Set<EEModuleClassConfiguration> classConfigurations, final String componentName, final ServiceName ownerName, final IntHolder handleCount, final Set<ServiceName> dependencies) throws DeploymentUnitProcessingException {
        for (EEModuleClassConfiguration classConfiguration : classConfigurations) {
            new ClassDescriptionTraversal(classConfiguration, applicationDescription){

                @Override
                protected void handle(EEModuleClassConfiguration configuration, EEModuleClassDescription classDescription) throws DeploymentUnitProcessingException {
                    if (classDescription.isInvalid()) {
                        throw new DeploymentUnitProcessingException("Component class " + classDescription.getClassName() + " for component " + componentName + " has errors: \n " + classDescription.getInvalidMessage());
                    }
                    if (handledClasses.contains(classDescription.getClassName())) {
                        return;
                    }
                    handledClasses.add(classDescription.getClassName());
                    HashSet<BindingConfiguration> classLevelBindings = new HashSet<BindingConfiguration>(configuration.getBindingConfigurations());
                    for (BindingConfiguration binding : classLevelBindings) {
                        boolean compBinding;
                        String bindingName = binding.getName();
                        boolean bl = compBinding = bindingName.startsWith("java:comp") || !bindingName.startsWith("java:");
                        if (namingMode == ComponentNamingMode.CREATE && compBinding) continue;
                        ServiceName serviceName = ContextNames.serviceNameOfEnvEntry((String)moduleConfiguration.getApplicationName(), (String)moduleConfiguration.getModuleName(), null, (boolean)false, (String)binding.getName());
                        logger.tracef("Binding %s using service %s", (Object)binding.getName(), (Object)serviceName);
                        if (deploymentDescriptorBindings.containsKey(serviceName)) continue;
                        ModuleJndiBindingProcessor.this.addJndiBinding(moduleConfiguration, binding, phaseContext, serviceName, ownerName, handleCount, dependencies);
                    }
                }
            }.run();
        }
    }

    protected void addJndiBinding(EEModuleConfiguration module, BindingConfiguration bindingConfiguration, DeploymentPhaseContext phaseContext, ServiceName serviceName, ServiceName ownerName, IntHolder handleCount, Set<ServiceName> dependencies) throws DeploymentUnitProcessingException {
        String bindingName = bindingConfiguration.getName().startsWith("java:") ? bindingConfiguration.getName() : "java:module/env/" + bindingConfiguration.getName();
        ServiceVerificationHandler serviceVerificationHandler = (ServiceVerificationHandler)phaseContext.getDeploymentUnit().getAttachment(org.jboss.as.server.deployment.Attachments.SERVICE_VERIFICATION_HANDLER);
        if (bindingName != null) {
            if (serviceName == null) {
                throw new IllegalArgumentException("Invalid context name '" + bindingName + "' for binding");
            }
        } else {
            throw new DeploymentUnitProcessingException("Binding name must not be null: " + bindingConfiguration);
        }
        BindingHandleService service = new BindingHandleService(bindingName, serviceName, (Object)bindingConfiguration.getSource(), serviceName.getParent(), serviceVerificationHandler);
        ServiceName handleServiceName = serviceName.append(ownerName).append(new String[]{String.valueOf(handleCount.value++)});
        dependencies.add(serviceName);
        ServiceBuilder sourceServiceBuilder = phaseContext.getServiceTarget().addService(handleServiceName, (Service)service);
        InjectionSource.ResolutionContext resolutionContext = new InjectionSource.ResolutionContext(true, module.getModuleName(), module.getModuleName(), module.getApplicationName());
        bindingConfiguration.getSource().getResourceValue(resolutionContext, sourceServiceBuilder, phaseContext, (Injector<ManagedReferenceFactory>)service.getManagedObjectInjector());
        sourceServiceBuilder.install();
    }

    public void undeploy(DeploymentUnit context) {
    }

    private static class IntHolder {
        private int value = 0;

        private IntHolder() {
        }
    }
}

