/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.client.helpers.domain.ServerStatus;
import org.jboss.as.domain.controller.DomainController;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.HostControllerImpl;
import org.jboss.as.host.controller.ManagedServer;
import org.jboss.as.host.controller.ManagedServerLifecycleCallback;
import org.jboss.as.host.controller.ModelCombiner;
import org.jboss.as.process.ProcessControllerClient;
import org.jboss.as.protocol.Connection;
import org.jboss.as.server.ServerState;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;

class ServerInventory
implements ManagedServerLifecycleCallback {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.host.controller");
    private final Map<String, ManagedServer> servers = new HashMap<String, ManagedServer>();
    private final HostControllerEnvironment environment;
    private final ProcessControllerClient processControllerClient;
    private final InetSocketAddress managementAddress;
    private HostControllerImpl hostController;

    ServerInventory(HostControllerEnvironment environment, InetSocketAddress managementAddress, ProcessControllerClient processControllerClient) {
        this.environment = environment;
        this.managementAddress = managementAddress;
        this.processControllerClient = processControllerClient;
    }

    void setHostController(HostControllerImpl hostController) {
        this.hostController = hostController;
    }

    ServerStatus determineServerStatus(String serverName) {
        ServerStatus status;
        String processName = ManagedServer.getServerProcessName(serverName);
        ManagedServer client = this.servers.get(processName);
        if (client == null) {
            status = ServerStatus.STOPPED;
        } else {
            switch (client.getState()) {
                case AVAILABLE: 
                case BOOTING: 
                case STARTING: {
                    status = ServerStatus.STARTING;
                    break;
                }
                case FAILED: 
                case MAX_FAILED: {
                    status = ServerStatus.FAILED;
                    break;
                }
                case STARTED: {
                    status = ServerStatus.STARTED;
                    break;
                }
                case STOPPING: {
                    status = ServerStatus.STOPPING;
                    break;
                }
                case STOPPED: {
                    status = ServerStatus.STOPPED;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected state " + client.getState());
                }
            }
        }
        return status;
    }

    ServerStatus startServer(String serverName, ModelNode hostModel, DomainController domainController) {
        String processName = ManagedServer.getServerProcessName(serverName);
        ManagedServer existing = this.servers.get(processName);
        if (existing != null) {
            log.warnf("existing server [%s] with state: " + existing.getState(), new Object[0]);
            return this.determineServerStatus(serverName);
        }
        log.info((Object)("starting server " + serverName));
        ManagedServer server = this.createManagedServer(serverName, hostModel, domainController);
        this.servers.put(processName, server);
        try {
            server.createServerProcess();
        }
        catch (IOException e) {
            log.error((Object)("Failed to create server process " + serverName), (Throwable)e);
        }
        try {
            server.startServerProcess();
        }
        catch (IOException e) {
            log.error((Object)("Failed to start server " + serverName), (Throwable)e);
        }
        return this.determineServerStatus(serverName);
    }

    ServerStatus restartServer(String serverName, int gracefulTimeout, ModelNode hostModel, DomainController domainController) {
        this.stopServer(serverName, gracefulTimeout);
        return this.startServer(serverName, hostModel, domainController);
    }

    ServerStatus stopServer(String serverName, int gracefulTimeout) {
        log.info((Object)("stopping server " + serverName));
        String processName = ManagedServer.getServerProcessName(serverName);
        try {
            ManagedServer server = this.servers.get(processName);
            if (server != null) {
                if (gracefulTimeout > -1) {
                    log.warnf("Graceful shutdown of server %s was requested but is not presently supported. Falling back to rapid shutdown.", (Object)serverName);
                    server.stopServerProcess();
                    server.removeServerProcess();
                    this.servers.remove(processName);
                } else {
                    server.stopServerProcess();
                    server.removeServerProcess();
                    this.servers.remove(processName);
                    this.hostController.unregisterRunningServer(serverName);
                }
            }
        }
        catch (Exception e) {
            log.errorf((Throwable)e, "Failed to stop server %s", (Object)serverName);
        }
        return this.determineServerStatus(serverName);
    }

    @Override
    public void serverRegistered(String serverName, Connection connection) {
        try {
            ManagedServer server = this.servers.get(serverName);
            if (server == null) {
                log.errorf("No server called %s available", (Object)serverName);
                return;
            }
            server.setServerManagementConnection(connection);
            server.setState(ServerState.STARTED);
            this.hostController.registerRunningServer(server.getServerName(), server.getServerConnection());
        }
        catch (Exception e) {
            log.errorf((Throwable)e, "Could not start server %s", (Object)serverName);
        }
    }

    @Override
    public void serverDown(String serverName) {
        ManagedServer server = this.servers.get(serverName);
        if (server == null) {
            log.errorf("No server called %s exists", (Object)serverName);
            return;
        }
        if (this.environment.isRestart() && server.getState() == ServerState.BOOTING && this.environment.getHostControllerPort() == 0) {
            try {
                server.removeServerProcess();
                server.createServerProcess();
            }
            catch (IOException e) {
                log.errorf("Error removing and adding process %s", (Object)serverName);
                return;
            }
            try {
                server.startServerProcess();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        server.setState(ServerState.FAILED);
    }

    @Override
    public void serverStarted(String serverName) {
        ManagedServer server = this.servers.get(serverName);
        if (server == null) {
            log.errorf("No server called %s exists for start", (Object)serverName);
            return;
        }
        this.checkState(server, ServerState.STARTING);
        server.setState(ServerState.STARTED);
    }

    @Override
    public void serverStartFailed(String serverName) {
        ManagedServer server = this.servers.get(serverName);
        if (server == null) {
            log.errorf("No server called %s exists", (Object)serverName);
            return;
        }
        this.checkState(server, ServerState.STARTING);
        server.setState(ServerState.FAILED);
    }

    @Override
    public void serverStopped(String serverName) {
        ManagedServer server = this.servers.get(serverName);
        if (server == null) {
            log.errorf("No server called %s exists for stop", (Object)serverName);
            return;
        }
        this.checkState(server, ServerState.STOPPING);
        try {
            server.stopServerProcess();
        }
        catch (IOException e) {
            log.errorf((Throwable)e, "Could not stop server %s in PM", (Object)serverName);
        }
        try {
            server.removeServerProcess();
        }
        catch (IOException e) {
            log.errorf((Throwable)e, "Could not stop server %s", (Object)serverName);
        }
    }

    void reconnectedServer(String serverName, ServerState state) {
        ManagedServer server = this.servers.get(serverName);
        if (server == null) {
            log.errorf("No server found for reconnected server %s", (Object)serverName);
            return;
        }
        server.setState(state);
        if (state.isRestartOnReconnect()) {
            try {
                server.startServerProcess();
            }
            catch (IOException e) {
                log.errorf((Throwable)e, "Could not start reconnected server %s", (Object)server.getServerProcessName());
            }
        }
    }

    private void checkState(ManagedServer server, ServerState expected) {
        ServerState state = server.getState();
        if (state != expected) {
            log.warnf("Server %s is not in the expected %s state: %s", (Object)server.getServerProcessName(), (Object)expected, (Object)state);
        }
    }

    private ManagedServer createManagedServer(String serverName, ModelNode hostModel, DomainController domainController) {
        ModelCombiner combiner = new ModelCombiner(serverName, hostModel, domainController, this.environment);
        return new ManagedServer(serverName, this.processControllerClient, this.managementAddress, combiner);
    }
}

