/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.SocketFactory;
import org.jboss.as.controller.HashUtil;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.TransactionalModelController;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.remote.ModelControllerClientToModelControllerAdapter;
import org.jboss.as.controller.remote.TransactionalModelControllerOperationHandler;
import org.jboss.as.domain.controller.DomainControllerSlave;
import org.jboss.as.domain.controller.FileRepository;
import org.jboss.as.domain.controller.MasterDomainControllerClient;
import org.jboss.as.host.controller.mgmt.ManagementCommunicationService;
import org.jboss.as.protocol.Connection;
import org.jboss.as.protocol.MessageHandler;
import org.jboss.as.protocol.ProtocolClient;
import org.jboss.as.protocol.ProtocolUtils;
import org.jboss.as.protocol.SimpleByteDataInput;
import org.jboss.as.protocol.SimpleByteDataOutput;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.mgmt.ManagementHeaderMessageHandler;
import org.jboss.as.protocol.mgmt.ManagementOperationHandler;
import org.jboss.as.protocol.mgmt.ManagementRequest;
import org.jboss.as.protocol.mgmt.ManagementRequestConnectionStrategy;
import org.jboss.as.protocol.mgmt.ManagementResponse;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.threads.JBossThreadFactory;

public class RemoteDomainConnectionService
implements MasterDomainControllerClient,
Service<MasterDomainControllerClient>,
Connection.ClosedCallback {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.domain.controller");
    private static final int CONNECTION_TIMEOUT = 5000;
    private final InetAddress host;
    private final int port;
    private final String name;
    private final RemoteFileRepository remoteFileRepository;
    private volatile Connection connection;
    private volatile ModelController masterProxy;
    private volatile TransactionalModelControllerOperationHandler txOperationHandler;
    private final InjectedValue<ManagementCommunicationService> managementCommunicationService = new InjectedValue();
    private final AtomicBoolean shutdown = new AtomicBoolean();
    private volatile ReconnectInfo reconnectInfo;
    private final MessageHandler initialMessageHandler = new ManagementHeaderMessageHandler(){

        public void handle(Connection connection, InputStream dataStream) throws IOException {
            super.handle(connection, dataStream);
        }

        protected MessageHandler getHandlerForId(byte handlerId) {
            if (handlerId == 16) {
                return RemoteDomainConnectionService.this.txOperationHandler;
            }
            return null;
        }
    };

    public RemoteDomainConnectionService(String name, InetAddress host, int port, FileRepository localRepository) {
        this.name = name;
        this.host = host;
        this.port = port;
        this.remoteFileRepository = new RemoteFileRepository(localRepository);
    }

    public void register(String hostName, InetAddress ourAddress, int ourPort, DomainControllerSlave slave) {
        this.connect(hostName, ourAddress, ourPort, slave);
        this.reconnectInfo = new ReconnectInfo(hostName, ourAddress, ourPort, slave);
    }

    private synchronized void connect(String hostName, InetAddress ourAddress, int ourPort, DomainControllerSlave slave) {
        JBossThreadFactory threadFactory = new JBossThreadFactory(new ThreadGroup("RemoteDomainConnection-threads"), Boolean.FALSE, null, "%G - %t", null, null, AccessController.getContext());
        ProtocolClient.Configuration config = new ProtocolClient.Configuration();
        config.setMessageHandler(this.initialMessageHandler);
        config.setConnectTimeout(5000);
        config.setReadExecutor((Executor)Executors.newCachedThreadPool((ThreadFactory)threadFactory));
        config.setSocketFactory(SocketFactory.getDefault());
        config.setServerAddress(new InetSocketAddress(this.host, this.port));
        config.setThreadFactory((ThreadFactory)threadFactory);
        config.setClosedCallback((Connection.ClosedCallback)this);
        InetAddress callbackAddress = this.getCallbackAddress(ourAddress, this.host);
        ProtocolClient protocolClient = new ProtocolClient(config);
        try {
            this.connection = protocolClient.connect();
            if (this.reconnectInfo != null) {
                this.unregister();
            }
            this.masterProxy = new ModelControllerClientToModelControllerAdapter(this.connection);
            this.txOperationHandler = new SlaveDomainControllerOperationHandler(slave);
            ((ManagementCommunicationService)this.managementCommunicationService.getValue()).addHandler((ManagementOperationHandler)this.txOperationHandler);
        }
        catch (IOException e) {
            log.warnf("Could not connect to remote domain controller %s:%d", (Object)this.host.getHostAddress(), (Object)this.port);
            throw new IllegalStateException(e);
        }
        try {
            ModelNode node = (ModelNode)new RegisterModelControllerRequest(callbackAddress, ourPort).executeForResult((ManagementRequestConnectionStrategy)new ManagementRequestConnectionStrategy.ExistingConnectionStrategy(this.connection));
            if (this.reconnectInfo == null) {
                slave.setInitialDomainModel(node);
            }
        }
        catch (Exception e) {
            log.warnf("Error retrieving domain model from remote domain controller %s:%d: %s", (Object)this.host.getHostAddress(), (Object)this.port, (Object)e.getMessage());
            throw new IllegalStateException(e);
        }
    }

    private InetAddress getCallbackAddress(InetAddress ourAddress, InetAddress master) {
        InetAddress callbackAddress = ourAddress;
        if (ourAddress.isAnyLocalAddress()) {
            byte[] masterBytes = master.getAddress();
            callbackAddress = null;
            InetAddress first = null;
            InetAddress firstPublic = null;
            InetAddress mostBytes = null;
            int byteMatch = 8;
            try {
                Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
                while (e.hasMoreElements()) {
                    NetworkInterface intf = e.nextElement();
                    try {
                        if (!intf.isUp()) continue;
                        if (!master.isReachable(intf, 0, 5000)) {
                        }
                    }
                    catch (IOException e1) {}
                    continue;
                    Enumeration<InetAddress> ea = intf.getInetAddresses();
                    while (ea.hasMoreElements()) {
                        int i;
                        byte[] addrBytes;
                        InetAddress addr = ea.nextElement();
                        if (first == null) {
                            first = addr;
                        }
                        if (firstPublic == null && !addr.isLoopbackAddress()) {
                            firstPublic = addr;
                        }
                        if ((addrBytes = addr.getAddress()).length != masterBytes.length) continue;
                        for (i = 0; i < addrBytes.length && addrBytes[i] == masterBytes[i]; ++i) {
                        }
                        if (i <= byteMatch) continue;
                        byteMatch = i;
                        mostBytes = addr;
                    }
                }
            }
            catch (SocketException e) {
                // empty catch block
            }
            if (callbackAddress == null) {
                InetAddress inetAddress = mostBytes != null ? mostBytes : (callbackAddress = firstPublic != null ? firstPublic : first);
            }
            if (callbackAddress == null) {
                try {
                    callbackAddress = InetAddress.getLocalHost();
                }
                catch (UnknownHostException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return callbackAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unregister() {
        try {
            new UnregisterModelControllerRequest().executeForResult((ManagementRequestConnectionStrategy)new ManagementRequestConnectionStrategy.ExistingConnectionStrategy(this.connection));
        }
        catch (Exception e) {
            log.errorf((Throwable)e, "Error unregistering from master", new Object[0]);
        }
        finally {
            ((ManagementCommunicationService)this.managementCommunicationService.getValue()).removeHandler((ManagementOperationHandler)this.txOperationHandler);
        }
    }

    public synchronized FileRepository getRemoteFileRepository() {
        return this.remoteFileRepository;
    }

    public OperationResult execute(Operation operation, ResultHandler handler) {
        return this.masterProxy.execute(operation, handler);
    }

    public ModelNode execute(Operation operation) throws CancellationException {
        return this.masterProxy.execute(operation);
    }

    public synchronized void start(StartContext context) throws StartException {
    }

    public synchronized void stop(StopContext context) {
        this.shutdown.set(true);
        StreamUtils.safeClose((Closeable)this.connection);
    }

    public synchronized MasterDomainControllerClient getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public Injector<ManagementCommunicationService> getManagementCommunicationServiceInjector() {
        return this.managementCommunicationService;
    }

    public void connectionClosed() {
        if (!this.shutdown.get()) {
            final ReconnectInfo reconnectInfo = this.reconnectInfo;
            if (reconnectInfo == null) {
                log.error((Object)"Null reconnect info, cannot try to reconnect");
                return;
            }
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    while (!RemoteDomainConnectionService.this.shutdown.get()) {
                        log.debug((Object)"Attempting reconnection to master...");
                        try {
                            RemoteDomainConnectionService.this.connect(reconnectInfo.getHostName(), reconnectInfo.getOurAddress(), reconnectInfo.getOurPort(), reconnectInfo.getSlave());
                            log.info((Object)"Connected to master");
                            break;
                        }
                        catch (Exception e) {
                            try {
                                Thread.sleep(3000L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                }
            }).start();
        }
    }

    private static class ReconnectInfo {
        final String hostName;
        final InetAddress ourAddress;
        final int ourPort;
        final DomainControllerSlave slave;

        public ReconnectInfo(String hostName, InetAddress ourAddress, int ourPort, DomainControllerSlave slave) {
            this.hostName = hostName;
            this.ourAddress = ourAddress;
            this.ourPort = ourPort;
            this.slave = slave;
        }

        public String getHostName() {
            return this.hostName;
        }

        public InetAddress getOurAddress() {
            return this.ourAddress;
        }

        public int getOurPort() {
            return this.ourPort;
        }

        public DomainControllerSlave getSlave() {
            return this.slave;
        }
    }

    private class IsActiveOperation
    extends ManagementResponse {
        private IsActiveOperation() {
        }

        protected final byte getResponseCode() {
            return 88;
        }
    }

    private class SlaveDomainControllerOperationHandler
    extends TransactionalModelControllerOperationHandler {
        SlaveDomainControllerOperationHandler(DomainControllerSlave slave) {
            super((TransactionalModelController)slave, MessageHandler.NULL);
        }

        public ManagementResponse operationFor(byte commandByte) {
            if (commandByte == 87) {
                return new IsActiveOperation();
            }
            return super.operationFor(commandByte);
        }
    }

    private class RemoteFileRepository
    implements FileRepository {
        private final FileRepository localFileRepository;

        private RemoteFileRepository(FileRepository localFileRepository) {
            this.localFileRepository = localFileRepository;
        }

        public final File getFile(String relativePath) {
            return this.getFile(relativePath, (byte)38);
        }

        public final File getConfigurationFile(String relativePath) {
            return this.getFile(relativePath, (byte)39);
        }

        public final File[] getDeploymentFiles(byte[] deploymentHash) {
            String hex = deploymentHash == null ? "" : HashUtil.bytesToHexString((byte[])deploymentHash);
            return this.getFile(hex, (byte)40).listFiles();
        }

        public File getDeploymentRoot(byte[] deploymentHash) {
            String hex = deploymentHash == null ? "" : HashUtil.bytesToHexString((byte[])deploymentHash);
            return this.getFile(hex, (byte)40);
        }

        private File getFile(String relativePath, byte repoId) {
            try {
                return (File)new GetFileRequest(repoId, relativePath, this.localFileRepository).executeForResult((ManagementRequestConnectionStrategy)new ManagementRequestConnectionStrategy.ExistingConnectionStrategy(RemoteDomainConnectionService.this.connection));
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to get file from remote repository", e);
            }
        }
    }

    private class GetFileRequest
    extends RegistryRequest<File> {
        private final byte rootId;
        private final String filePath;
        private final FileRepository localFileRepository;

        private GetFileRequest(byte rootId, String filePath, FileRepository localFileRepository) {
            this.rootId = rootId;
            this.filePath = filePath;
            this.localFileRepository = localFileRepository;
        }

        public final byte getRequestCode() {
            return 85;
        }

        protected final byte getResponseCode() {
            return 86;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void sendRequest(int protocolVersion, OutputStream outputStream) throws IOException {
            super.sendRequest(protocolVersion, outputStream);
            log.debugf("Requesting files for path %s", (Object)this.filePath);
            SimpleByteDataOutput output = null;
            try {
                output = new SimpleByteDataOutput(outputStream);
                output.writeByte(36);
                output.writeByte((int)this.rootId);
                output.writeByte(37);
                output.writeUTF(this.filePath);
                output.close();
            }
            catch (Throwable throwable) {
                StreamUtils.safeClose(output);
                throw throwable;
            }
            StreamUtils.safeClose((Closeable)output);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final File receiveResponse(InputStream inputStream) throws IOException {
            File localPath;
            switch (this.rootId) {
                case 38: {
                    localPath = this.localFileRepository.getFile(this.filePath);
                    break;
                }
                case 39: {
                    localPath = this.localFileRepository.getConfigurationFile(this.filePath);
                    break;
                }
                case 40: {
                    byte[] hash = HashUtil.hexStringToByteArray((String)this.filePath);
                    localPath = this.localFileRepository.getDeploymentRoot(hash);
                    break;
                }
                default: {
                    localPath = null;
                }
            }
            SimpleByteDataInput input = null;
            try {
                input = new SimpleByteDataInput(inputStream);
                ProtocolUtils.expectHeader((DataInput)input, (int)41);
                int numFiles = input.readInt();
                log.debugf("Received %d files for %s", (Object)numFiles, (Object)localPath);
                switch (numFiles) {
                    case -1: {
                        break;
                    }
                    case 0: {
                        if (localPath.mkdirs()) break;
                        throw new IOException("Unable to create local directory: " + localPath);
                    }
                    default: {
                        for (int i = 0; i < numFiles; ++i) {
                            ProtocolUtils.expectHeader((DataInput)input, (int)48);
                            ProtocolUtils.expectHeader((DataInput)input, (int)37);
                            String path = input.readUTF();
                            ProtocolUtils.expectHeader((DataInput)input, (int)49);
                            long length = input.readLong();
                            log.debugf("Received file [%s] of length %d", (Object)path, (Object)length);
                            File file = new File(localPath, path);
                            if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                                throw new IOException("Unable to create local directory " + localPath.getParent());
                            }
                            long totalRead = 0L;
                            OutputStream fileOut = null;
                            try {
                                int read;
                                fileOut = new BufferedOutputStream(new FileOutputStream(file));
                                byte[] buffer = new byte[8192];
                                while (totalRead < length && (read = input.read(buffer, 0, Math.min((int)(length - totalRead), buffer.length))) != -1) {
                                    if (read <= 0) continue;
                                    fileOut.write(buffer, 0, read);
                                    totalRead += (long)read;
                                }
                            }
                            finally {
                                if (fileOut != null) {
                                    fileOut.close();
                                }
                            }
                            if (totalRead != length) {
                                throw new IOException("Did not read the entire file. Missing: " + (length - totalRead));
                            }
                            ProtocolUtils.expectHeader((DataInput)input, (int)50);
                        }
                    }
                }
                input.close();
            }
            catch (Throwable throwable) {
                StreamUtils.safeClose(input);
                throw throwable;
            }
            StreamUtils.safeClose((Closeable)input);
            return localPath;
        }
    }

    private class UnregisterModelControllerRequest
    extends RegistryRequest<Void> {
        private UnregisterModelControllerRequest() {
        }

        protected byte getRequestCode() {
            return 83;
        }

        protected byte getResponseCode() {
            return 84;
        }

        protected void sendRequest(int protocolVersion, OutputStream output) throws IOException {
            output.write(32);
            StreamUtils.writeUTFZBytes((OutputStream)output, (String)RemoteDomainConnectionService.this.name);
        }
    }

    private class RegisterModelControllerRequest
    extends RegistryRequest<ModelNode> {
        private final InetAddress localManagementAddress;
        private final int localManagementPort;

        RegisterModelControllerRequest(InetAddress localManagementAddress, int localManagementPort) {
            this.localManagementAddress = localManagementAddress;
            this.localManagementPort = localManagementPort;
        }

        protected byte getRequestCode() {
            return 81;
        }

        protected byte getResponseCode() {
            return 82;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void sendRequest(int protocolVersion, OutputStream outputStream) throws IOException {
            SimpleByteDataOutput output = null;
            try {
                output = new SimpleByteDataOutput(outputStream);
                output.write(32);
                output.writeUTF(RemoteDomainConnectionService.this.name);
                output.writeByte(33);
                byte[] address = this.localManagementAddress.getAddress();
                output.writeInt(address.length);
                output.write(address);
                output.writeByte(34);
                output.writeInt(this.localManagementPort);
                output.close();
            }
            catch (Throwable throwable) {
                StreamUtils.safeClose(output);
                throw throwable;
            }
            StreamUtils.safeClose((Closeable)output);
        }

        protected ModelNode receiveResponse(InputStream input) throws IOException {
            ProtocolUtils.expectHeader((InputStream)input, (int)35);
            ModelNode node = new ModelNode();
            node.readExternal(input);
            if (node.hasDefined("protocol-error")) {
                log.error((Object)node.get("protocol-error").asString());
                log.error((Object)"Exiting");
            }
            return node;
        }
    }

    private abstract class RegistryRequest<T>
    extends ManagementRequest<T> {
        private RegistryRequest() {
        }

        protected byte getHandlerId() {
            return 1;
        }
    }
}

