/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.security.Provider;
import java.security.Security;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.controller.HashUtil;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.remote.ExistingChannelModelControllerClient;
import org.jboss.as.controller.remote.TransactionalModelControllerOperationHandler;
import org.jboss.as.domain.controller.FileRepository;
import org.jboss.as.domain.controller.MasterDomainControllerClient;
import org.jboss.as.domain.management.CallbackHandlerFactory;
import org.jboss.as.domain.management.security.SecurityRealmService;
import org.jboss.as.protocol.ProtocolChannelClient;
import org.jboss.as.protocol.ProtocolChannelFactory;
import org.jboss.as.protocol.mgmt.FlushableDataOutput;
import org.jboss.as.protocol.mgmt.ManagementChannel;
import org.jboss.as.protocol.mgmt.ManagementChannelFactory;
import org.jboss.as.protocol.mgmt.ManagementClientChannelStrategy;
import org.jboss.as.protocol.mgmt.ManagementOperationHandler;
import org.jboss.as.protocol.mgmt.ManagementRequest;
import org.jboss.as.protocol.mgmt.ManagementResponseHandler;
import org.jboss.as.protocol.old.Connection;
import org.jboss.as.protocol.old.ProtocolUtils;
import org.jboss.as.remoting.RemotingServices;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.Endpoint;
import org.jboss.sasl.JBossSaslProvider;
import org.jboss.threads.AsyncFuture;
import org.jboss.threads.AsyncFutureTask;

public class RemoteDomainConnectionService
implements MasterDomainControllerClient,
Service<MasterDomainControllerClient>,
Connection.ClosedCallback {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.domain.controller");
    private final ModelController controller;
    private final InetAddress host;
    private final int port;
    private final String name;
    private final RemoteFileRepository remoteFileRepository;
    private final Provider saslProvider = new JBossSaslProvider();
    private volatile ProtocolChannelClient<ManagementChannel> channelClient;
    private volatile ModelControllerClient masterProxy;
    private volatile TransactionalModelControllerOperationHandler txOperationHandler;
    private final AtomicBoolean shutdown = new AtomicBoolean();
    private volatile ManagementChannel channel;
    private final ExecutorService executor = Executors.newCachedThreadPool();
    private final AtomicBoolean connected = new AtomicBoolean(false);
    private final FutureClient futureClient = new FutureClient();
    private final InjectedValue<Endpoint> endpointInjector = new InjectedValue();
    private final InjectedValue<CallbackHandlerFactory> callbackFactoryInjector = new InjectedValue();
    private RemoteFileRepositoryExecutor remoteFileRepositoryExecutor = new RemoteFileRepositoryExecutor(){

        @Override
        public File getFile(String relativePath, byte repoId, FileRepository localFileRepository) {
            try {
                return (File)new GetFileRequest(repoId, relativePath, localFileRepository).executeForResult(RemoteDomainConnectionService.this.executor, ManagementClientChannelStrategy.create((ManagementChannel)RemoteDomainConnectionService.this.channel));
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to get file from remote repository", e);
            }
        }
    };

    private RemoteDomainConnectionService(ModelController controller, String name, InetAddress host, int port, RemoteFileRepository remoteFileRepository) {
        this.controller = controller;
        this.name = name;
        this.host = host;
        this.port = port;
        this.remoteFileRepository = remoteFileRepository;
        remoteFileRepository.setRemoteFileRepositoryExecutor(this.remoteFileRepositoryExecutor);
    }

    public static Future<MasterDomainControllerClient> install(ServiceTarget serviceTarget, ModelController controller, String localHostName, String remoteDcHost, int remoteDcPort, String securityRealm, RemoteFileRepository remoteFileRepository) {
        RemoteDomainConnectionService service;
        try {
            service = new RemoteDomainConnectionService(controller, localHostName, InetAddress.getByName(remoteDcHost), remoteDcPort, remoteFileRepository);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        ServiceBuilder builder = serviceTarget.addService(MasterDomainControllerClient.SERVICE_NAME, (Service)service).addDependency(RemotingServices.ENDPOINT, Endpoint.class, service.endpointInjector).setInitialMode(ServiceController.Mode.ACTIVE);
        if (securityRealm != null) {
            ServiceName callbackHandlerService = SecurityRealmService.BASE_SERVICE_NAME.append(new String[]{securityRealm}).append(new String[]{"secret"});
            builder.addDependency(callbackHandlerService, CallbackHandlerFactory.class, service.callbackFactoryInjector);
        }
        builder.install();
        return service.futureClient;
    }

    public void register() {
        IllegalStateException ise = null;
        boolean connected = false;
        long timeout = System.currentTimeMillis() + 5000L;
        while (!connected && System.currentTimeMillis() < timeout) {
            try {
                this.connect();
                connected = true;
            }
            catch (IllegalStateException e) {
                ise = e;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException inter) {
                    Thread.currentThread().interrupt();
                    throw new IllegalStateException("Interrupted while trying to connect to master", inter);
                }
            }
        }
        if (!connected) {
            throw ise != null ? ise : new IllegalStateException("Could not connect to master within 5000 ms");
        }
        this.connected.set(true);
    }

    private synchronized void connect() {
        ProtocolChannelClient client;
        if (this.channelClient != null) {
            try {
                new UnregisterModelControllerRequest().executeForResult(this.executor, ManagementClientChannelStrategy.create((ManagementChannel)this.channel));
            }
            catch (Exception e) {
                // empty catch block
            }
            this.channelClient.close();
            this.channelClient = null;
        }
        Security.addProvider(this.saslProvider);
        this.txOperationHandler = new TransactionalModelControllerOperationHandler(this.executor, this.controller);
        ProtocolChannelClient.Configuration configuration = new ProtocolChannelClient.Configuration();
        configuration.setEndpointName("endpoint");
        configuration.setExecutor((Executor)RemotingServices.createExecutor());
        configuration.setUriScheme("remote");
        try {
            configuration.setUri(new URI("remote://" + this.host.getHostAddress() + ":" + this.port));
            configuration.setChannelFactory((ProtocolChannelFactory)new ManagementChannelFactory((ManagementOperationHandler)this.txOperationHandler));
            client = ProtocolChannelClient.create((ProtocolChannelClient.Configuration)configuration);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            ManagementChannel channel;
            CallbackHandler handler = null;
            CallbackHandlerFactory handlerFactory = (CallbackHandlerFactory)this.callbackFactoryInjector.getOptionalValue();
            if (handlerFactory != null) {
                handler = handlerFactory.getCallbackHandler(this.name);
            }
            client.connect(handler);
            this.channelClient = client;
            this.channel = channel = (ManagementChannel)client.openChannel("domain");
            channel.addCloseHandler((CloseHandler)new CloseHandler<Channel>(){

                public void handleClose(Channel closed, IOException exception) {
                    RemoteDomainConnectionService.this.connectionClosed();
                }
            });
            channel.startReceiving();
            this.masterProxy = new ExistingChannelModelControllerClient(channel);
        }
        catch (IOException e) {
            log.warnf("Could not connect to remote domain controller %s:%d", (Object)this.host.getHostAddress(), (Object)this.port);
            throw new IllegalStateException(e);
        }
        try {
            String error = (String)new RegisterModelControllerRequest().executeForResult(this.executor, ManagementClientChannelStrategy.create((ManagementChannel)this.channel));
            if (error != null) {
                throw new Exception(error);
            }
        }
        catch (Exception e) {
            log.warnf("Error retrieving domain model from remote domain controller %s:%d: %s", (Object)this.host.getHostAddress(), (Object)this.port, (Object)e.getMessage());
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unregister() {
        try {
            new UnregisterModelControllerRequest().executeForResult(this.executor, ManagementClientChannelStrategy.create((ManagementChannel)this.channel));
        }
        catch (Exception e) {
            log.debugf((Throwable)e, "Error unregistering from master", new Object[0]);
        }
        finally {
            this.channelClient.close();
        }
    }

    public synchronized FileRepository getRemoteFileRepository() {
        return this.remoteFileRepository;
    }

    public ModelNode execute(ModelNode operation) throws IOException {
        return this.execute(operation, OperationMessageHandler.logging);
    }

    public ModelNode execute(Operation operation) throws IOException {
        return this.masterProxy.execute(operation, OperationMessageHandler.logging);
    }

    public ModelNode execute(ModelNode operation, OperationMessageHandler messageHandler) throws IOException {
        return this.masterProxy.execute(operation, messageHandler);
    }

    public ModelNode execute(Operation operation, OperationMessageHandler messageHandler) throws IOException {
        return this.masterProxy.execute(operation, messageHandler);
    }

    public AsyncFuture<ModelNode> executeAsync(ModelNode operation, OperationMessageHandler messageHandler) {
        return this.masterProxy.executeAsync(operation, messageHandler);
    }

    public AsyncFuture<ModelNode> executeAsync(Operation operation, OperationMessageHandler messageHandler) {
        return this.masterProxy.executeAsync(operation, messageHandler);
    }

    public void close() throws IOException {
        throw new UnsupportedOperationException("Close should be managed by the service");
    }

    public synchronized void start(StartContext context) throws StartException {
        this.futureClient.setClient(this);
    }

    public synchronized void stop(StopContext context) {
        this.shutdown.set(true);
        if (this.channelClient != null) {
            this.unregister();
        }
    }

    public void connectionClosed() {
        if (!this.connected.get()) {
            log.error((Object)"Null reconnect info, cannot try to reconnect");
            return;
        }
        if (!this.shutdown.get()) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    while (!RemoteDomainConnectionService.this.shutdown.get()) {
                        log.debug((Object)"Attempting reconnection to master...");
                        try {
                            RemoteDomainConnectionService.this.connect();
                            log.info((Object)"Reconnected to master");
                            break;
                        }
                        catch (Exception e) {
                            try {
                                Thread.sleep(3000L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                }
            }).start();
        }
    }

    public synchronized MasterDomainControllerClient getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    private class FutureClient
    extends AsyncFutureTask<MasterDomainControllerClient> {
        protected FutureClient() {
            super(null);
        }

        private void setClient(MasterDomainControllerClient client) {
            super.setResult((Object)client);
        }
    }

    private static interface RemoteFileRepositoryExecutor {
        public File getFile(String var1, byte var2, FileRepository var3);
    }

    static class RemoteFileRepository
    implements FileRepository {
        private final FileRepository localFileRepository;
        private volatile RemoteFileRepositoryExecutor remoteFileRepositoryExecutor;

        RemoteFileRepository(FileRepository localFileRepository) {
            this.localFileRepository = localFileRepository;
        }

        public final File getFile(String relativePath) {
            return this.getFile(relativePath, (byte)38);
        }

        public final File getConfigurationFile(String relativePath) {
            return this.getFile(relativePath, (byte)39);
        }

        public final File[] getDeploymentFiles(byte[] deploymentHash) {
            String hex = deploymentHash == null ? "" : HashUtil.bytesToHexString((byte[])deploymentHash);
            return this.getFile(hex, (byte)40).listFiles();
        }

        public File getDeploymentRoot(byte[] deploymentHash) {
            String hex = deploymentHash == null ? "" : HashUtil.bytesToHexString((byte[])deploymentHash);
            return this.getFile(hex, (byte)40);
        }

        private File getFile(String relativePath, byte repoId) {
            return this.remoteFileRepositoryExecutor.getFile(relativePath, repoId, this.localFileRepository);
        }

        private void setRemoteFileRepositoryExecutor(RemoteFileRepositoryExecutor remoteFileRepositoryExecutor) {
            this.remoteFileRepositoryExecutor = remoteFileRepositoryExecutor;
        }
    }

    private class GetFileRequest
    extends RegistryRequest<File> {
        private final byte rootId;
        private final String filePath;
        private final FileRepository localFileRepository;

        private GetFileRequest(byte rootId, String filePath, FileRepository localFileRepository) {
            this.rootId = rootId;
            this.filePath = filePath;
            this.localFileRepository = localFileRepository;
        }

        public final byte getRequestCode() {
            return 85;
        }

        protected final void writeRequest(int protocolVersion, FlushableDataOutput output) throws IOException {
            super.writeRequest(protocolVersion, output);
            log.debugf("Requesting files for path %s", (Object)this.filePath);
            output.writeByte(36);
            output.writeByte((int)this.rootId);
            output.writeByte(37);
            output.writeUTF(this.filePath);
        }

        protected ManagementResponseHandler<File> getResponseHandler() {
            return new ManagementResponseHandler<File>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected final File readResponse(DataInput input) throws IOException {
                    File localPath;
                    switch (GetFileRequest.this.rootId) {
                        case 38: {
                            localPath = GetFileRequest.this.localFileRepository.getFile(GetFileRequest.this.filePath);
                            break;
                        }
                        case 39: {
                            localPath = GetFileRequest.this.localFileRepository.getConfigurationFile(GetFileRequest.this.filePath);
                            break;
                        }
                        case 40: {
                            byte[] hash = HashUtil.hexStringToByteArray((String)GetFileRequest.this.filePath);
                            localPath = GetFileRequest.this.localFileRepository.getDeploymentRoot(hash);
                            break;
                        }
                        default: {
                            localPath = null;
                        }
                    }
                    ProtocolUtils.expectHeader((DataInput)input, (int)41);
                    int numFiles = input.readInt();
                    log.debugf("Received %d files for %s", (Object)numFiles, (Object)localPath);
                    switch (numFiles) {
                        case -1: {
                            break;
                        }
                        case 0: {
                            if (localPath.mkdirs()) break;
                            throw new IOException("Unable to create local directory: " + localPath);
                        }
                        default: {
                            for (int i = 0; i < numFiles; ++i) {
                                long totalRead;
                                ProtocolUtils.expectHeader((DataInput)input, (int)48);
                                ProtocolUtils.expectHeader((DataInput)input, (int)37);
                                String path = input.readUTF();
                                ProtocolUtils.expectHeader((DataInput)input, (int)49);
                                long length = input.readLong();
                                log.debugf("Received file [%s] of length %d", (Object)path, (Object)length);
                                File file = new File(localPath, path);
                                if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                                    throw new IOException("Unable to create local directory " + localPath.getParent());
                                }
                                OutputStream fileOut = null;
                                try {
                                    int len;
                                    fileOut = new BufferedOutputStream(new FileOutputStream(file));
                                    byte[] buffer = new byte[8192];
                                    for (totalRead = 0L; totalRead < length; totalRead += (long)len) {
                                        len = Math.min((int)(length - totalRead), buffer.length);
                                        input.readFully(buffer, 0, len);
                                        fileOut.write(buffer, 0, len);
                                    }
                                }
                                finally {
                                    if (fileOut != null) {
                                        fileOut.close();
                                    }
                                }
                                if (totalRead != length) {
                                    throw new IOException("Did not read the entire file. Missing: " + (length - totalRead));
                                }
                                ProtocolUtils.expectHeader((DataInput)input, (int)50);
                            }
                        }
                    }
                    return localPath;
                }
            };
        }
    }

    private class UnregisterModelControllerRequest
    extends RegistryRequest<Void> {
        private UnregisterModelControllerRequest() {
        }

        protected byte getRequestCode() {
            return 83;
        }

        protected void writeRequest(int protocolVersion, FlushableDataOutput output) throws IOException {
            output.write(32);
            output.writeUTF(RemoteDomainConnectionService.this.name);
        }

        protected ManagementResponseHandler<Void> getResponseHandler() {
            return ManagementResponseHandler.EMPTY_RESPONSE;
        }
    }

    private class RegisterModelControllerRequest
    extends RegistryRequest<String> {
        RegisterModelControllerRequest() {
        }

        protected byte getRequestCode() {
            return 81;
        }

        protected void writeRequest(int protocolVersion, FlushableDataOutput output) throws IOException {
            output.write(32);
            output.writeUTF(RemoteDomainConnectionService.this.name);
        }

        protected ManagementResponseHandler<String> getResponseHandler() {
            return new ManagementResponseHandler<String>(){

                protected String readResponse(DataInput input) throws IOException {
                    byte status = input.readByte();
                    if (status == 33) {
                        return null;
                    }
                    return input.readUTF();
                }
            };
        }
    }

    private abstract class RegistryRequest<T>
    extends ManagementRequest<T> {
        private RegistryRequest() {
        }
    }
}

