/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import java.util.Locale;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.persistence.ExtensibleConfigurationPersister;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.DomainModelUtil;
import org.jboss.as.domain.controller.FileRepository;
import org.jboss.as.host.controller.HostControllerConfigurationPersister;
import org.jboss.as.host.controller.operations.LocalHostControllerInfoImpl;
import org.jboss.dmr.ModelNode;

public class RemoteDomainControllerAddHandler
implements OperationStepHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "write-remote-domain-controller";
    private final ParametersValidator parametersValidator = new ParametersValidator();
    private final ManagementResourceRegistration rootRegistration;
    private final HostControllerConfigurationPersister overallConfigPersister;
    private final FileRepository fileRepository;
    private final LocalHostControllerInfoImpl hostControllerInfo;

    public static RemoteDomainControllerAddHandler getInstance(ManagementResourceRegistration rootRegistration, LocalHostControllerInfoImpl hostControllerInfo, HostControllerConfigurationPersister overallConfigPersister, FileRepository fileRepository) {
        return new RemoteDomainControllerAddHandler(rootRegistration, hostControllerInfo, overallConfigPersister, fileRepository);
    }

    RemoteDomainControllerAddHandler(ManagementResourceRegistration rootRegistration, LocalHostControllerInfoImpl hostControllerInfo, HostControllerConfigurationPersister overallConfigPersister, FileRepository fileRepository) {
        this.rootRegistration = rootRegistration;
        this.overallConfigPersister = overallConfigPersister;
        this.fileRepository = fileRepository;
        this.hostControllerInfo = hostControllerInfo;
        this.parametersValidator.registerValidator("port", (ParameterValidator)new IntRangeValidator(1, 65535, false, true));
        this.parametersValidator.registerValidator("host", (ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, false, true));
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        Resource resource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
        ModelNode model = resource.getModel();
        this.parametersValidator.validate(operation);
        ModelNode dc = model.get("domain-controller");
        ModelNode port = operation.require("port");
        ModelNode host = operation.require("host");
        dc.get(new String[]{"remote", "port"}).set(port);
        dc.get(new String[]{"remote", "host"}).set(host);
        if (operation.has("security-realm")) {
            ModelNode securityRealm = operation.require("security-realm");
            dc.get(new String[]{"remote", "security-realm"}).set(securityRealm);
            this.hostControllerInfo.setRemoteDomainControllerSecurityRealm(securityRealm.resolve().asString());
        }
        if (dc.has("local")) {
            dc.remove("local");
        }
        this.hostControllerInfo.setMasterDomainController(false);
        this.hostControllerInfo.setRemoteDomainControllerHost(host.resolve().asString());
        this.hostControllerInfo.setRemoteDomainControllerPort(port.resolve().asInt());
        this.overallConfigPersister.initializeDomainConfigurationPersister(true);
        DomainModelUtil.initializeSlaveDomainRegistry((ManagementResourceRegistration)this.rootRegistration, (ExtensibleConfigurationPersister)this.overallConfigPersister.getDomainPersister(), (FileRepository)this.fileRepository);
        context.completeStep();
    }

    public ModelNode getModelDescription(Locale locale) {
        return new ModelNode();
    }
}

