/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.extension.ExtensionResource;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.DomainControllerLogger;
import org.jboss.as.domain.controller.LocalHostControllerInfo;
import org.jboss.as.domain.controller.ServerIdentity;
import org.jboss.as.domain.controller.operations.SecurityActions;
import org.jboss.as.domain.controller.operations.coordination.DomainServerUtils;
import org.jboss.as.host.controller.ignored.IgnoredDomainResourceRegistry;
import org.jboss.as.management.client.content.ManagedDMRContentTypeResource;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.repository.HostFileRepository;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;

public class ApplyRemoteMasterDomainModelHandler
implements OperationStepHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "apply-remote-domain-model";
    private final Set<String> appliedExensions = new HashSet<String>();
    private final HostFileRepository fileRepository;
    private final ContentRepository contentRepository;
    private final ExtensionRegistry extensionRegistry;
    private final IgnoredDomainResourceRegistry ignoredResourceRegistry;
    private final LocalHostControllerInfo localHostInfo;

    public ApplyRemoteMasterDomainModelHandler(ExtensionRegistry extensionRegistry, HostFileRepository fileRepository, ContentRepository contentRepository, LocalHostControllerInfo localHostInfo, IgnoredDomainResourceRegistry ignoredResourceRegistry) {
        this.extensionRegistry = extensionRegistry;
        this.fileRepository = fileRepository;
        this.contentRepository = contentRepository;
        this.localHostInfo = localHostInfo;
        this.ignoredResourceRegistry = ignoredResourceRegistry;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode domainModel = operation.get("domain-model");
        ModelNode startRoot = Resource.Tools.readModel((Resource)context.getRootResource());
        Set<String> ourServerGroups = this.getOurServerGroups(context);
        HashMap<String, HashSet<byte[]>> deploymentHashes = new HashMap<String, HashSet<byte[]>>();
        HashSet<String> relevantDeployments = new HashSet<String>();
        HashSet<byte[]> requiredContent = new HashSet<byte[]>();
        Resource rootResource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
        this.clearDomain(rootResource);
        for (ModelNode resourceDescription : domainModel.asList()) {
            String module;
            PathAddress resourceAddress = PathAddress.pathAddress((ModelNode)resourceDescription.require("domain-resource-address"));
            if (this.ignoredResourceRegistry.isResourceExcluded(resourceAddress)) continue;
            Resource resource = this.getResource(resourceAddress, rootResource, context);
            if (resourceAddress.size() == 1 && resourceAddress.getElement(0).getKey().equals("extension") && !this.appliedExensions.contains(module = resourceAddress.getElement(0).getValue())) {
                this.appliedExensions.add(module);
                this.initializeExtension(module);
            }
            resource.writeModel(resourceDescription.get("domain-resource-model"));
            if (resourceAddress.size() == 1) {
                ModelNode model;
                PathElement pe = resourceAddress.getElement(0);
                String peKey = pe.getKey();
                if (peKey.equals("deployment")) {
                    model = resource.getModel();
                    String id = resourceAddress.getElement(0).getValue();
                    if (!model.hasDefined("content")) continue;
                    for (ModelNode contentItem : model.get("content").asList()) {
                        if (!contentItem.hasDefined("hash")) continue;
                        HashSet<byte[]> hashes = (HashSet<byte[]>)deploymentHashes.get(id);
                        if (hashes == null) {
                            hashes = new HashSet<byte[]>();
                            deploymentHashes.put(id, hashes);
                        }
                        hashes.add(contentItem.get("hash").asBytes());
                    }
                    continue;
                }
                if (!peKey.equals("management-client-content") || !(model = resource.getModel()).hasDefined("hash")) continue;
                requiredContent.add(model.get("hash").asBytes());
                continue;
            }
            if (resourceAddress.size() != 2 || !resourceAddress.getElement(0).getKey().equals("server-group") || !ourServerGroups.contains(resourceAddress.getElement(0).getValue()) || !resourceAddress.getElement(1).getKey().equals("deployment")) continue;
            relevantDeployments.add(resourceAddress.getElement(1).getValue());
        }
        for (String id : relevantDeployments) {
            Set hashes = (Set)deploymentHashes.remove(id);
            if (hashes == null) continue;
            requiredContent.addAll(hashes);
        }
        for (byte[] hash : requiredContent) {
            this.fileRepository.getDeploymentFiles(hash);
        }
        if (!context.isBooting()) {
            ModelNode finishExtensions;
            Resource domainRootResource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
            ModelNode endRoot = Resource.Tools.readModel((Resource)domainRootResource);
            HashSet<ServerIdentity> affectedServers = new HashSet<ServerIdentity>();
            ModelNode hostModel = ((Property)endRoot.require("host").asPropertyList().iterator().next()).getValue();
            ModelNode existingHostModel = ((Property)startRoot.require("host").asPropertyList().iterator().next()).getValue();
            Map<String, ProxyController> serverProxies = DomainServerUtils.getServerProxies(this.localHostInfo.getLocalHostName(), domainRootResource, context.getResourceRegistration());
            ModelNode startExtensions = startRoot.get("extension");
            if (!startExtensions.equals(finishExtensions = endRoot.get("extension"))) {
                affectedServers.addAll(DomainServerUtils.getAllRunningServers(hostModel, this.localHostInfo.getLocalHostName(), serverProxies));
            }
            ModelNode startPaths = startRoot.get("path");
            ModelNode endPaths = endRoot.get("path");
            HashMap<String, ModelNode> existingPaths = new HashMap<String, ModelNode>();
            if (startPaths.isDefined()) {
                for (Property property : startPaths.asPropertyList()) {
                    existingPaths.put(property.getName(), property.getValue());
                }
            }
            if (endPaths.isDefined()) {
                for (Property property : endPaths.asPropertyList()) {
                    String pathName = property.getName();
                    if (existingPaths.containsKey(pathName)) {
                        if (!property.getValue().equals((ModelNode)existingPaths.get(pathName))) {
                            affectedServers.addAll(this.getServersAffectedByPath(pathName, hostModel, true));
                        }
                        existingPaths.remove(pathName);
                        continue;
                    }
                    affectedServers.addAll(this.getServersAffectedByPath(pathName, hostModel, true));
                }
            }
            for (Map.Entry entry : existingPaths.entrySet()) {
                affectedServers.addAll(this.getServersAffectedByPath((String)entry.getKey(), existingHostModel, true));
            }
            ModelNode startSysProps = startRoot.get("system-property");
            ModelNode modelNode = endRoot.get("system-property");
            HashMap<String, ModelNode> existingProps = new HashMap<String, ModelNode>();
            if (startSysProps.isDefined()) {
                for (Property property : startSysProps.asPropertyList()) {
                    existingProps.put(property.getName(), property.getValue());
                }
            }
            if (modelNode.isDefined()) {
                for (Property property : modelNode.asPropertyList()) {
                    if (existingProps.containsKey(property.getName())) {
                        if (!property.getValue().equals((ModelNode)existingProps.get(property.getName()))) {
                            affectedServers.addAll(this.getServerAffectedBySystemProperty(property.getName(), true, endRoot, null, hostModel));
                        }
                        existingProps.remove(property.getName());
                        continue;
                    }
                    affectedServers.addAll(this.getServerAffectedBySystemProperty(property.getName(), true, endRoot, null, hostModel));
                }
            }
            for (Map.Entry entry : existingProps.entrySet()) {
                affectedServers.addAll(this.getServerAffectedBySystemProperty((String)entry.getKey(), true, startRoot, null, existingHostModel));
            }
            ModelNode startProfiles = startRoot.get("profile");
            ModelNode modelNode2 = endRoot.get("profile");
            HashMap<String, ModelNode> existingProfiles = new HashMap<String, ModelNode>();
            if (startProfiles.isDefined()) {
                for (Property property : startProfiles.asPropertyList()) {
                    existingProfiles.put(property.getName(), property.getValue());
                }
            }
            if (modelNode2.isDefined()) {
                for (Property property : modelNode2.asPropertyList()) {
                    if (existingProfiles.containsKey(property.getName())) {
                        if (!property.getValue().equals((ModelNode)existingProfiles.get(property.getName()))) {
                            affectedServers.addAll(this.getServerAffectedByProfile(property.getName(), endRoot, hostModel, serverProxies));
                        }
                        existingProfiles.remove(property.getName());
                        continue;
                    }
                    affectedServers.addAll(this.getServerAffectedByProfile(property.getName(), endRoot, hostModel, serverProxies));
                }
            }
            for (Map.Entry entry : existingProfiles.entrySet()) {
                affectedServers.addAll(this.getServerAffectedByProfile((String)entry.getKey(), startRoot, existingHostModel, serverProxies));
            }
            ModelNode startInterfaces = startRoot.get("interface");
            ModelNode modelNode3 = endRoot.get("interface");
            HashMap<String, ModelNode> existingInterfaces = new HashMap<String, ModelNode>();
            if (startInterfaces.isDefined()) {
                for (Property property : startInterfaces.asPropertyList()) {
                    existingInterfaces.put(property.getName(), property.getValue());
                }
            }
            if (modelNode3.isDefined()) {
                for (Property property : modelNode3.asPropertyList()) {
                    if (existingInterfaces.containsKey(property.getName())) {
                        if (!property.getValue().equals((ModelNode)existingInterfaces.get(property.getName()))) {
                            affectedServers.addAll(this.getServersAffectedByInterface(property.getName(), hostModel, true));
                        }
                        existingInterfaces.remove(property.getName());
                        continue;
                    }
                    affectedServers.addAll(this.getServersAffectedByInterface(property.getName(), hostModel, true));
                }
            }
            for (Map.Entry entry : existingInterfaces.entrySet()) {
                affectedServers.addAll(this.getServersAffectedByInterface((String)entry.getKey(), existingHostModel, true));
            }
            ModelNode startBindingGroups = startRoot.get("socket-binding-group");
            ModelNode modelNode4 = endRoot.get("socket-binding-group");
            HashMap<String, ModelNode> existingBindingGroups = new HashMap<String, ModelNode>();
            if (startBindingGroups.isDefined()) {
                for (Property property : startBindingGroups.asPropertyList()) {
                    existingBindingGroups.put(property.getName(), property.getValue());
                }
            }
            if (modelNode4.isDefined()) {
                for (Property property : modelNode4.asPropertyList()) {
                    if (existingBindingGroups.containsKey(property.getName())) {
                        if (!property.getValue().equals((ModelNode)existingBindingGroups.get(property.getName()))) {
                            affectedServers.addAll(this.getServersAffectedBySocketBindingGroup(property.getName(), endRoot, hostModel, serverProxies));
                        }
                        existingBindingGroups.remove(property.getName());
                        continue;
                    }
                    affectedServers.addAll(this.getServersAffectedBySocketBindingGroup(property.getName(), endRoot, hostModel, serverProxies));
                }
            }
            for (Map.Entry entry : existingBindingGroups.entrySet()) {
                affectedServers.addAll(this.getServersAffectedBySocketBindingGroup((String)entry.getKey(), startRoot, existingHostModel, serverProxies));
            }
            ModelNode startServerGroups = startRoot.get("server-group");
            ModelNode modelNode5 = endRoot.get("server-group");
            HashMap<String, ModelNode> existingServerGroups = new HashMap<String, ModelNode>();
            if (startServerGroups.isDefined()) {
                for (Property property : startServerGroups.asPropertyList()) {
                    existingServerGroups.put(property.getName(), property.getValue());
                }
            }
            if (modelNode5.isDefined()) {
                for (Property property : modelNode5.asPropertyList()) {
                    if (existingServerGroups.containsKey(property.getName())) {
                        if (!property.getValue().equals((ModelNode)existingServerGroups.get(property.getName()))) {
                            affectedServers.addAll(DomainServerUtils.getServersForGroup(property.getName(), hostModel, this.localHostInfo.getLocalHostName(), serverProxies));
                        }
                        existingServerGroups.remove(property.getName());
                        continue;
                    }
                    affectedServers.addAll(DomainServerUtils.getServersForGroup(property.getName(), hostModel, this.localHostInfo.getLocalHostName(), serverProxies));
                }
            }
            for (Map.Entry entry : existingServerGroups.entrySet()) {
                affectedServers.addAll(DomainServerUtils.getServersForGroup((String)entry.getKey(), hostModel, this.localHostInfo.getLocalHostName(), serverProxies));
            }
            if (!affectedServers.isEmpty()) {
                DomainControllerLogger.ROOT_LOGGER.domainModelChangedOnReConnect(affectedServers);
                Set<ServerIdentity> runningServers = DomainServerUtils.getAllRunningServers(hostModel, this.localHostInfo.getLocalHostName(), serverProxies);
                for (ServerIdentity serverIdentity : affectedServers) {
                    if (!runningServers.contains(serverIdentity)) continue;
                    PathAddress serverAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"host", (String)serverIdentity.getHostName()), PathElement.pathElement((String)"server", (String)serverIdentity.getServerName())});
                    OperationStepHandler handler = context.getResourceRegistration().getOperationHandler(serverAddress, "server-set-restart-required");
                    ModelNode op = new ModelNode();
                    op.get("operation").set("server-set-restart-required");
                    op.get("address").set(serverAddress.toModelNode());
                    context.addStep(op, handler, OperationContext.Stage.IMMEDIATE);
                }
            }
        }
        context.completeStep();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeExtension(String module) {
        try {
            for (Extension extension : Module.loadServiceFromCallerModuleLoader((ModuleIdentifier)ModuleIdentifier.fromString((String)module), Extension.class)) {
                ClassLoader oldTccl = SecurityActions.setThreadContextClassLoader(extension.getClass());
                try {
                    extension.initializeParsers(this.extensionRegistry.getExtensionParsingContext(module, null));
                    extension.initialize(this.extensionRegistry.getExtensionContext(module));
                }
                finally {
                    SecurityActions.setThreadContextClassLoader(oldTccl);
                }
            }
        }
        catch (ModuleLoadException e) {
            throw new RuntimeException(e);
        }
    }

    private void clearDomain(Resource rootResource) {
        for (Resource.ResourceEntry entry : rootResource.getChildren("extension")) {
            rootResource.removeChild(entry.getPathElement());
        }
        for (Resource.ResourceEntry entry : rootResource.getChildren("path")) {
            rootResource.removeChild(entry.getPathElement());
        }
        for (Resource.ResourceEntry entry : rootResource.getChildren("system-property")) {
            rootResource.removeChild(entry.getPathElement());
        }
        for (Resource.ResourceEntry entry : rootResource.getChildren("profile")) {
            rootResource.removeChild(entry.getPathElement());
        }
        for (Resource.ResourceEntry entry : rootResource.getChildren("interface")) {
            rootResource.removeChild(entry.getPathElement());
        }
        for (Resource.ResourceEntry entry : rootResource.getChildren("socket-binding-group")) {
            rootResource.removeChild(entry.getPathElement());
        }
        for (Resource.ResourceEntry entry : rootResource.getChildren("deployment")) {
            rootResource.removeChild(entry.getPathElement());
        }
        for (Resource.ResourceEntry entry : rootResource.getChildren("server-group")) {
            rootResource.removeChild(entry.getPathElement());
        }
    }

    private Resource getResource(PathAddress resourceAddress, Resource rootResource, OperationContext context) {
        if (resourceAddress.size() == 0) {
            return rootResource;
        }
        Resource temp = rootResource;
        int idx = 0;
        for (PathElement element : resourceAddress) {
            if ((temp = temp.getChild(element)) == null) {
                if (idx == 0) {
                    String type = element.getKey();
                    if (type.equals("extension")) {
                        temp = new ExtensionResource(element.getValue(), this.extensionRegistry);
                        context.addResource(resourceAddress, temp);
                    } else if (type.equals("management-client-content") && element.getValue().equals("rollout-plans")) {
                        temp = new ManagedDMRContentTypeResource(element, "rollout-plan", null, this.contentRepository);
                        context.addResource(resourceAddress, temp);
                    }
                }
                if (temp != null) break;
                temp = context.createResource(resourceAddress);
                break;
            }
            ++idx;
        }
        return temp;
    }

    private Collection<ServerIdentity> getServersAffectedByPath(String pathName, ModelNode hostModel, boolean forDomain) {
        if (forDomain && hostModel.hasDefined("path") && hostModel.get("path").keys().contains(pathName)) {
            return Collections.emptySet();
        }
        if (hostModel.hasDefined("server-config")) {
            HashSet<ServerIdentity> servers = new HashSet<ServerIdentity>();
            for (Property prop : hostModel.get("server-config").asPropertyList()) {
                String serverName = prop.getName();
                ModelNode server = prop.getValue();
                String serverGroupName = server.require("group").asString();
                if (server.hasDefined("path") && server.get("path").keys().contains(pathName)) continue;
                ServerIdentity groupedServer = new ServerIdentity(this.localHostInfo.getLocalHostName(), serverGroupName, serverName);
                servers.add(groupedServer);
            }
            return servers;
        }
        return Collections.emptySet();
    }

    private Collection<ServerIdentity> getServerAffectedBySystemProperty(String propName, boolean isDomain, ModelNode domain, String affectedGroup, ModelNode host) {
        boolean overridden = false;
        Set<String> groups = null;
        if (isDomain) {
            if (this.hasSystemProperty(host, propName)) {
                overridden = true;
            } else if (affectedGroup != null) {
                groups = Collections.singleton(affectedGroup);
            } else if (domain.hasDefined("server-group")) {
                groups = new HashSet<String>();
                for (Property groupProp : domain.get("server-group").asPropertyList()) {
                    String groupName = groupProp.getName();
                    if (this.hasSystemProperty(groupProp.getValue(), propName)) continue;
                    groups.add(groupName);
                }
            }
        }
        HashSet<ServerIdentity> servers = null;
        if (!overridden && host.hasDefined("server-config")) {
            servers = new HashSet<ServerIdentity>();
            for (Property serverProp : host.get("server-config").asPropertyList()) {
                String serverName = serverProp.getName();
                ModelNode server = serverProp.getValue();
                if (this.hasSystemProperty(server, propName)) continue;
                String groupName = server.require("group").asString();
                if (groups != null && !groups.contains(groupName)) continue;
                servers.add(new ServerIdentity(this.localHostInfo.getLocalHostName(), groupName, serverName));
            }
        }
        if (servers != null) {
            return servers;
        }
        return Collections.emptySet();
    }

    private boolean hasSystemProperty(ModelNode resource, String propName) {
        return resource.hasDefined("system-property") && resource.get("system-property").hasDefined(propName);
    }

    private Collection<ServerIdentity> getServerAffectedByProfile(String profileName, ModelNode domain, ModelNode host, Map<String, ProxyController> serverProxies) {
        Set<String> relatedProfiles = DomainServerUtils.getRelatedElements("profile", profileName, domain);
        HashSet<ServerIdentity> allServers = new HashSet<ServerIdentity>();
        for (String profile : relatedProfiles) {
            allServers.addAll(DomainServerUtils.getServersForType("profile", profile, domain, host, this.localHostInfo.getLocalHostName(), serverProxies));
        }
        return allServers;
    }

    private Collection<ServerIdentity> getServersAffectedByInterface(String interfaceName, ModelNode hostModel, boolean forDomain) {
        if (forDomain && hostModel.hasDefined("interface") && hostModel.get("interface").keys().contains(interfaceName)) {
            return Collections.emptySet();
        }
        if (hostModel.hasDefined("server-config")) {
            HashSet<ServerIdentity> servers = new HashSet<ServerIdentity>();
            for (Property prop : hostModel.get("server-config").asPropertyList()) {
                String serverName = prop.getName();
                ModelNode server = prop.getValue();
                String serverGroupName = server.require("group").asString();
                if (server.hasDefined("interface") && server.get("interface").keys().contains(interfaceName)) continue;
                ServerIdentity groupedServer = new ServerIdentity(this.localHostInfo.getLocalHostName(), serverGroupName, serverName);
                servers.add(groupedServer);
            }
            return servers;
        }
        return Collections.emptySet();
    }

    private Collection<ServerIdentity> getServersAffectedBySocketBindingGroup(String bindingGroupName, ModelNode domain, ModelNode host, Map<String, ProxyController> serverProxies) {
        Set<String> relatedBindingGroups = DomainServerUtils.getRelatedElements("socket-binding-group", bindingGroupName, domain);
        HashSet<ServerIdentity> result = new HashSet<ServerIdentity>();
        for (String bindingGroup : relatedBindingGroups) {
            result.addAll(DomainServerUtils.getServersForType("socket-binding-group", bindingGroup, domain, host, this.localHostInfo.getLocalHostName(), serverProxies));
        }
        Iterator iter = result.iterator();
        while (iter.hasNext()) {
            ServerIdentity gs = (ServerIdentity)iter.next();
            ModelNode server = host.get(new String[]{"server-config", gs.getServerName()});
            if (!server.hasDefined("socket-binding-group") || bindingGroupName.equals(server.get("socket-binding-group").asString())) continue;
            iter.remove();
        }
        return result;
    }

    private Set<String> getOurServerGroups(OperationContext context) {
        HashSet<String> result = new HashSet<String>();
        Resource root = context.readResource(PathAddress.EMPTY_ADDRESS);
        Resource host = (Resource)root.getChildren("host").iterator().next();
        for (Resource.ResourceEntry server : host.getChildren("server-config")) {
            ModelNode model = server.getModel();
            result.add(model.get("group").asString());
        }
        return result;
    }

    public ModelNode getModelDescription(Locale locale) {
        return new ModelNode();
    }
}

