/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.operations.HttpManagementAddHandler;
import org.jboss.as.host.controller.operations.HttpManagementRemoveHandler;
import org.jboss.as.host.controller.operations.LocalHostControllerInfoImpl;
import org.jboss.dmr.ModelNode;

public class HttpManagementWriteAttributeHandler
extends AbstractWriteAttributeHandler<Void> {
    private final LocalHostControllerInfoImpl hostControllerInfo;
    private final HostControllerEnvironment environment;

    public HttpManagementWriteAttributeHandler(LocalHostControllerInfoImpl hostControllerInfo, HostControllerEnvironment environment) {
        this.hostControllerInfo = hostControllerInfo;
        this.environment = environment;
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
        ModelNode subModel = resource.getModel();
        ServiceVerificationHandler handler = new ServiceVerificationHandler();
        HttpManagementWriteAttributeHandler.updateHttpManagementService(context, subModel, this.hostControllerInfo, this.environment, handler);
        context.addStep((OperationStepHandler)handler, OperationContext.Stage.VERIFY);
        return false;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
        ModelNode subModel = resource.getModel().clone();
        subModel.get(attributeName).set(valueToRestore);
        HttpManagementWriteAttributeHandler.updateHttpManagementService(context, subModel, this.hostControllerInfo, this.environment, null);
    }

    static void updateHttpManagementService(OperationContext context, ModelNode subModel, LocalHostControllerInfoImpl hostControllerInfo, HostControllerEnvironment environment, ServiceVerificationHandler verificationHandler) throws OperationFailedException {
        HttpManagementRemoveHandler.removeHttpManagementService(context);
        HttpManagementAddHandler.populateHostControllerInfo(hostControllerInfo, context, subModel);
        HttpManagementAddHandler.installHttpManagementServices(context.getRunningMode(), context.getServiceTarget(), hostControllerInfo, environment, verificationHandler, false);
    }
}

