/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.remote.AbstractModelControllerOperationHandlerFactoryService;
import org.jboss.as.controller.remote.ModelControllerClientOperationHandlerFactoryService;
import org.jboss.as.domain.controller.LocalHostControllerInfo;
import org.jboss.as.domain.management.security.SecurityRealmService;
import org.jboss.as.host.controller.DomainModelControllerService;
import org.jboss.as.host.controller.jmx.RemotingConnectorService;
import org.jboss.as.host.controller.mgmt.ServerToHostOperationHandlerFactoryService;
import org.jboss.as.host.controller.operations.LocalHostControllerInfoImpl;
import org.jboss.as.host.controller.resources.NativeManagementResourceDefinition;
import org.jboss.as.remoting.EndpointService;
import org.jboss.as.remoting.management.ManagementChannelRegistryService;
import org.jboss.as.remoting.management.ManagementRemotingServices;
import org.jboss.as.server.services.net.NetworkInterfaceService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class NativeManagementAddHandler
extends AbstractAddStepHandler {
    public static final String OPERATION_NAME = "add";
    private final LocalHostControllerInfoImpl hostControllerInfo;

    public NativeManagementAddHandler(LocalHostControllerInfoImpl hostControllerInfo) {
        this.hostControllerInfo = hostControllerInfo;
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition attr : NativeManagementResourceDefinition.ATTRIBUTE_DEFINITIONS) {
            attr.validateAndSet(operation, model);
        }
    }

    protected boolean requiresRuntime(OperationContext context) {
        return true;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        NativeManagementAddHandler.populateHostControllerInfo(this.hostControllerInfo, context, model);
        ServiceTarget serviceTarget = context.getServiceTarget();
        ManagementChannelRegistryService.addService((ServiceTarget)serviceTarget, (ServiceName)ManagementRemotingServices.MANAGEMENT_ENDPOINT);
        ManagementRemotingServices.installRemotingEndpoint((ServiceTarget)serviceTarget, (ServiceName)ManagementRemotingServices.MANAGEMENT_ENDPOINT, (String)this.hostControllerInfo.getLocalHostName(), (EndpointService.EndpointType)EndpointService.EndpointType.MANAGEMENT, null, null);
        boolean onDemand = context.isBooting();
        NativeManagementAddHandler.installNativeManagementServices(serviceTarget, this.hostControllerInfo, verificationHandler, newControllers, onDemand);
    }

    static void populateHostControllerInfo(LocalHostControllerInfoImpl hostControllerInfo, OperationContext context, ModelNode model) throws OperationFailedException {
        hostControllerInfo.setNativeManagementInterface(NativeManagementResourceDefinition.INTERFACE.resolveModelAttribute(context, model).asString());
        ModelNode portNode = NativeManagementResourceDefinition.NATIVE_PORT.resolveModelAttribute(context, model);
        hostControllerInfo.setNativeManagementPort(portNode.isDefined() ? portNode.asInt() : -1);
        ModelNode realmNode = NativeManagementResourceDefinition.SECURITY_REALM.resolveModelAttribute(context, model);
        hostControllerInfo.setNativeManagementSecurityRealm(realmNode.isDefined() ? realmNode.asString() : null);
    }

    public static void installNativeManagementServices(ServiceTarget serviceTarget, LocalHostControllerInfo hostControllerInfo, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers, boolean onDemand) {
        ServiceName realmSvcName = null;
        String nativeSecurityRealm = hostControllerInfo.getNativeManagementSecurityRealm();
        if (nativeSecurityRealm != null) {
            realmSvcName = SecurityRealmService.BASE_SERVICE_NAME.append(new String[]{nativeSecurityRealm});
        }
        ServiceName nativeManagementInterfaceBinding = NetworkInterfaceService.JBOSS_NETWORK_INTERFACE.append(new String[]{hostControllerInfo.getNativeManagementInterface()});
        ManagementRemotingServices.installDomainConnectorServices((ServiceTarget)serviceTarget, (ServiceName)ManagementRemotingServices.MANAGEMENT_ENDPOINT, (ServiceName)nativeManagementInterfaceBinding, (int)hostControllerInfo.getNativeManagementPort(), (ServiceName)realmSvcName, (ServiceVerificationHandler)verificationHandler, newControllers);
        ManagementRemotingServices.installManagementChannelOpenListenerService((ServiceTarget)serviceTarget, (ServiceName)ManagementRemotingServices.MANAGEMENT_ENDPOINT, (String)"server", (ServiceName)ServerToHostOperationHandlerFactoryService.SERVICE_NAME, (ServiceVerificationHandler)verificationHandler, newControllers, (boolean)onDemand);
        ManagementRemotingServices.installManagementChannelServices((ServiceTarget)serviceTarget, (ServiceName)ManagementRemotingServices.MANAGEMENT_ENDPOINT, (AbstractModelControllerOperationHandlerFactoryService)new ModelControllerClientOperationHandlerFactoryService(), (ServiceName)DomainModelControllerService.SERVICE_NAME, (String)"management", (ServiceVerificationHandler)verificationHandler, newControllers);
        RemotingConnectorService.addService(serviceTarget, verificationHandler);
    }
}

