/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jaxr.extension;

import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.jaxr.JAXRConfiguration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class JAXRWriteAttributeHandler
extends AbstractWriteAttributeHandler<Void> {
    static AttributeDefinition CONNECTION_FACTORY_ATTRIBUTE = new JAXRAttributeDefinition("connection-factory");
    static AttributeDefinition PUBLISH_URL_ATTRIBUTE = new JAXRAttributeDefinition("publish-url");
    static AttributeDefinition QUERY_URL_ATTRIBUTE = new JAXRAttributeDefinition("query-url");
    private final JAXRConfiguration config;

    JAXRWriteAttributeHandler(JAXRConfiguration config) {
        this.config = config;
    }

    void registerAttributes(ManagementResourceRegistration registry) {
        registry.registerReadWriteAttribute(CONNECTION_FACTORY_ATTRIBUTE, null, (OperationStepHandler)this);
        registry.registerReadWriteAttribute(PUBLISH_URL_ATTRIBUTE, null, (OperationStepHandler)this);
        registry.registerReadWriteAttribute(QUERY_URL_ATTRIBUTE, null, (OperationStepHandler)this);
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> voidHandbackHolder) throws OperationFailedException {
        JAXRWriteAttributeHandler.applyUpdateToConfig(this.config, attributeName, resolvedValue);
        return false;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
        JAXRWriteAttributeHandler.applyUpdateToConfig(this.config, attributeName, valueToRestore);
    }

    public static void applyUpdateToConfig(JAXRConfiguration config, String attributeName, ModelNode attributeValue) {
        if (attributeValue.isDefined()) {
            config.applyUpdateToConfig(attributeName, attributeValue.asString());
        }
    }

    private static class JAXRAttributeDefinition
    extends SimpleAttributeDefinition {
        JAXRAttributeDefinition(String name) {
            super(name, ModelType.STRING, true, new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES});
        }
    }
}

