/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jaxr.service;

import org.apache.ws.scout.registry.ConnectionFactoryImpl;
import org.jboss.as.jaxr.JAXRConfiguration;
import org.jboss.as.naming.NamingStore;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.ValueManagedReferenceFactory;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.logging.Logger;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;

public final class JAXRConnectionFactoryService
extends AbstractService<Void> {
    static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"jaxr", "connectionfactory"});
    private final Logger log = Logger.getLogger((String)"org.jboss.as.jaxr");
    private final InjectedValue<NamingStore> injectedJavaContext = new InjectedValue();
    private final InjectedValue<JAXRConfiguration> injectedConfig = new InjectedValue();

    public static ServiceController<?> addService(ServiceTarget target, ServiceListener<Object> ... listeners) {
        JAXRConnectionFactoryService service = new JAXRConnectionFactoryService();
        ServiceBuilder builder = target.addService(SERVICE_NAME, (Service)service);
        builder.addDependency(ContextNames.JAVA_CONTEXT_SERVICE_NAME, NamingStore.class, service.injectedJavaContext);
        builder.addDependency(JAXRConfiguration.SERVICE_NAME, JAXRConfiguration.class, service.injectedConfig);
        builder.addListener(listeners);
        return builder.install();
    }

    private JAXRConnectionFactoryService() {
    }

    public void start(StartContext context) throws StartException {
        JAXRConfiguration config = (JAXRConfiguration)this.injectedConfig.getValue();
        if (config.getConnectionFactoryBinding() != null) {
            this.log.infof("Binding JAXR ConnectionFactory: %s", (Object)config.getConnectionFactoryBinding());
            try {
                String jndiName = config.getConnectionFactoryBinding();
                ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)jndiName);
                BinderService binderService = new BinderService(bindInfo.getBindName());
                ImmediateValue value = new ImmediateValue((Object)new ConnectionFactoryImpl());
                binderService.getManagedObjectInjector().inject((Object)new ValueManagedReferenceFactory((Value)value));
                binderService.getNamingStoreInjector().inject((Object)((ServiceBasedNamingStore)this.injectedJavaContext.getValue()));
                ServiceBuilder builder = context.getChildTarget().addService(bindInfo.getBinderServiceName(), (Service)binderService);
                builder.install();
            }
            catch (Exception ex) {
                this.log.errorf((Throwable)ex, "Cannot bind JAXR ConnectionFactory", new Object[0]);
            }
        }
    }

    public void stop(StopContext context) {
        JAXRConfiguration config = (JAXRConfiguration)this.injectedConfig.getValue();
        if (config.getConnectionFactoryBinding() != null) {
            this.log.debugf("Unbind JAXR ConnectionFactory", new Object[0]);
            try {
                String jndiName = config.getConnectionFactoryBinding();
                ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)jndiName);
                ServiceContainer serviceContainer = context.getController().getServiceContainer();
                ServiceController service = serviceContainer.getService(bindInfo.getBinderServiceName());
                if (service != null) {
                    service.setMode(ServiceController.Mode.REMOVE);
                }
            }
            catch (Exception ex) {
                this.log.errorf((Throwable)ex, "Cannot unbind JAXR ConnectionFactory", new Object[0]);
            }
        }
    }
}

