/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jaxr;

import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import org.jboss.msc.service.ServiceName;

public class JAXRConfiguration {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"jaxr", "configuration"});
    public static String[] OPTIONAL_ATTRIBUTES = new String[]{"jndi-name", "class"};
    private String connectionFactoryBinding;
    private String connectionFactoryImplementation;
    private Properties properties = new Properties();

    public JAXRConfiguration() {
        this.init();
    }

    public void init() {
        this.connectionFactoryBinding = null;
    }

    public static ResourceBundle getResourceBundle(Locale locale) {
        return ResourceBundle.getBundle("org.jboss.as.jaxr.LocalDescriptions", locale != null ? locale : Locale.getDefault());
    }

    public void applyUpdateToConfig(String attributeName, String attributeValue) {
        if (attributeValue != null) {
            if (attributeName.equals("jndi-name")) {
                this.setConnectionFactoryBinding(attributeValue);
            } else if (attributeName.equals("class")) {
                this.setConnectionFactoryImplementation(attributeValue);
            } else if (attributeValue != null) {
                this.properties.setProperty(attributeName, attributeValue);
            } else {
                this.properties.remove(attributeName);
            }
        }
    }

    public String getConnectionFactoryBinding() {
        return this.connectionFactoryBinding;
    }

    public void setConnectionFactoryBinding(String connectionFactoryBinding) {
        this.connectionFactoryBinding = connectionFactoryBinding;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setConnectionFactoryImplementation(String connectionFactoryImplementation) {
        this.connectionFactoryImplementation = connectionFactoryImplementation;
    }

    public String getConnectionFactoryImplementation() {
        return this.connectionFactoryImplementation;
    }
}

