/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.hibernate4.infinispan;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.EnumSet;
import java.util.Properties;
import org.hibernate.cache.CacheException;
import org.infinispan.AdvancedCache;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.as.clustering.infinispan.DefaultEmbeddedCacheManager;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerConfiguration;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerConfigurationService;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public class InfinispanRegionFactory
extends org.hibernate.cache.infinispan.InfinispanRegionFactory {
    private static final long serialVersionUID = 6526170943015350422L;
    public static final String CACHE_CONTAINER = "hibernate.cache.infinispan.container";
    public static final String DEFAULT_CACHE_CONTAINER = "hibernate";

    public InfinispanRegionFactory() {
    }

    public InfinispanRegionFactory(Properties props) {
        super(props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EmbeddedCacheManager createCacheManager(Properties properties) throws CacheException {
        String container = properties.getProperty(CACHE_CONTAINER, DEFAULT_CACHE_CONTAINER);
        ServiceName serviceName = EmbeddedCacheManagerConfigurationService.getServiceName((String)container);
        ServiceContainer registry = CurrentServiceContainer.getServiceContainer();
        ServiceController service = registry.getRequiredService(serviceName);
        NotifyingListener listener = new NotifyingListener();
        service.addListener(listener);
        NotifyingListener notifyingListener = listener;
        synchronized (notifyingListener) {
            service.setMode(ServiceController.Mode.PASSIVE);
            try {
                while (EnumSet.of(ServiceController.State.DOWN, ServiceController.State.STARTING).contains(service.getState())) {
                    ((Object)((Object)listener)).wait();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        service.removeListener(listener);
        if (service.getState() != ServiceController.State.UP) {
            throw new CacheException((Throwable)service.getStartException());
        }
        EmbeddedCacheManagerConfiguration config = (EmbeddedCacheManagerConfiguration)service.getValue();
        GlobalConfiguration global = new GlobalConfigurationBuilder().read(config.getGlobalConfiguration()).classLoader(((Object)((Object)this)).getClass().getClassLoader()).build();
        DefaultEmbeddedCacheManager manager = new DefaultEmbeddedCacheManager(global, config.getDefaultCache());
        manager.start();
        return manager;
    }

    protected AdvancedCache createCacheWrapper(AdvancedCache cache) {
        PrivilegedAction<ClassLoader> action = new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        };
        return cache.with(AccessController.doPrivileged(action));
    }

    static class NotifyingListener<T>
    extends AbstractServiceListener<T> {
        NotifyingListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void transition(ServiceController<? extends T> controller, ServiceController.Transition transition) {
            NotifyingListener notifyingListener = this;
            synchronized (notifyingListener) {
                ((Object)((Object)this)).notify();
            }
        }
    }
}

