/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.service;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContextType;
import org.jboss.as.jpa.container.ExtendedEntityManager;
import org.jboss.as.jpa.container.TransactionScopedEntityManager;
import org.jboss.as.jpa.service.PersistenceUnitService;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.ValueManagedReference;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;

public class PersistenceContextInjectorService
implements Service<ManagedReferenceFactory> {
    private final String name;
    private final String unitName;
    private final String scopedPuName;
    private final PersistenceContextType type;
    private final Map properties;
    private final ServiceName puServiceName;
    private final PersistenceContextJndiInjectable injectable;

    public PersistenceContextInjectorService(AnnotationInstance annotation, ServiceName puServiceName, DeploymentUnit deploymentUnit, String scopedPuName) {
        AnnotationInstance[] props;
        AnnotationValue value = annotation.value("name");
        this.name = value != null ? value.asString() : null;
        value = annotation.value("unitName");
        this.unitName = value != null ? value.asString() : null;
        this.scopedPuName = scopedPuName;
        value = annotation.value("type");
        String type = value != null ? value.asEnum() : null;
        this.type = value == null || PersistenceContextType.TRANSACTION.name().equals(value.asString()) ? PersistenceContextType.TRANSACTION : PersistenceContextType.EXTENDED;
        value = annotation.value("properties");
        AnnotationInstance[] annotationInstanceArray = props = value != null ? value.asNestedArray() : null;
        if (props != null) {
            this.properties = new HashMap();
            for (int source = 0; source < props.length; ++source) {
                this.properties.put(props[source].value("name"), props[source].value("value"));
            }
        } else {
            this.properties = null;
        }
        this.puServiceName = puServiceName;
        this.injectable = new PersistenceContextJndiInjectable(puServiceName, deploymentUnit, this.type, this.properties, this.scopedPuName);
    }

    public void start(StartContext context) throws StartException {
    }

    public void stop(StopContext context) {
    }

    public ManagedReferenceFactory getValue() throws IllegalStateException, IllegalArgumentException {
        return this.injectable;
    }

    private static final class PersistenceContextJndiInjectable
    implements ManagedReferenceFactory {
        private final ServiceName puServiceName;
        private final DeploymentUnit deploymentUnit;
        private final PersistenceContextType type;
        private final Map properties;
        private final String unitName;

        public PersistenceContextJndiInjectable(ServiceName puServiceName, DeploymentUnit deploymentUnit, PersistenceContextType type, Map properties, String unitName) {
            this.puServiceName = puServiceName;
            this.deploymentUnit = deploymentUnit;
            this.type = type;
            this.properties = properties;
            this.unitName = unitName;
        }

        public ManagedReference getReference() {
            PersistenceUnitService service = (PersistenceUnitService)this.deploymentUnit.getServiceRegistry().getRequiredService(this.puServiceName).getValue();
            EntityManagerFactory emf = service.getEntityManagerFactory();
            if (this.type.equals((Object)PersistenceContextType.TRANSACTION)) {
                return new ValueManagedReference((Value)new ImmediateValue((Object)new TransactionScopedEntityManager(this.unitName, this.properties, emf)));
            }
            return new ValueManagedReference((Value)new ImmediateValue((Object)new ExtendedEntityManager(null)));
        }
    }
}

