/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.container;

import java.io.Serializable;
import javax.persistence.EntityManager;
import org.jboss.as.jpa.container.AbstractEntityManager;
import org.jboss.as.jpa.transaction.TransactionUtil;

public class ExtendedEntityManager
extends AbstractEntityManager
implements Serializable {
    private static final long serialVersionUID = 432435L;
    private EntityManager underlyingEntityManager;
    private String puScopedName;

    public ExtendedEntityManager(String puScopedName, EntityManager underlyingEntityManager) {
        super(puScopedName, true);
        this.underlyingEntityManager = underlyingEntityManager;
        this.puScopedName = puScopedName;
    }

    @Override
    protected EntityManager getEntityManager() {
        return this.underlyingEntityManager;
    }

    @Override
    protected boolean isExtendedPersistenceContext() {
        return true;
    }

    @Override
    protected boolean isInTx() {
        return TransactionUtil.getInstance().isInTx();
    }

    @Override
    public void close() {
        throw new IllegalStateException("Container managed entity manager can only be closed by the container (will happen when @remove method is invoked on containing SFSB)");
    }

    public String toString() {
        return "ExtendedEntityManager [" + this.puScopedName + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtendedEntityManager that = (ExtendedEntityManager)o;
        if (!this.puScopedName.equals(that.puScopedName)) {
            return false;
        }
        return this.underlyingEntityManager.equals(that.underlyingEntityManager);
    }

    public int hashCode() {
        int result = this.underlyingEntityManager.hashCode();
        result = 31 * result + this.puScopedName.hashCode();
        return result;
    }
}

