/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.container;

import java.util.Map;
import javax.ejb.EJBException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.jboss.as.jpa.container.AbstractEntityManager;
import org.jboss.as.jpa.container.EntityManagerUtil;
import org.jboss.as.jpa.container.SFSBCallStack;
import org.jboss.as.jpa.transaction.TransactionUtil;

public class TransactionScopedEntityManager
extends AbstractEntityManager {
    private String puScopedName;
    private Map properties;
    private EntityManagerFactory emf;
    private boolean isInTx;

    public TransactionScopedEntityManager(String puScopedName, Map properties, EntityManagerFactory emf) {
        super(puScopedName, false);
        this.puScopedName = puScopedName;
        this.properties = properties;
        this.emf = emf;
    }

    @Override
    protected EntityManager getEntityManager() {
        EntityManager result = null;
        this.isInTx = TransactionUtil.getInstance().isInTx();
        if (this.isInTx && (result = SFSBCallStack.findPersistenceContext(this.puScopedName)) != null) {
            EntityManager existing = TransactionUtil.getInstance().getTransactionScopedEntityManager(this.puScopedName);
            if (existing != null && existing != result) {
                throw new EJBException("Found extended persistence context in SFSB invocation call stack but that cannot be used because the transaction already has a transactional context associated with it.  This can be avoided by changing application code, either eliminate the extended persistence context or the transactional context.  See JPA spec 2.0 section 7.6.3.1.  Scoped persistence unit name=" + this.puScopedName + ", persistence context already in transaction =" + existing + ", extended persistence context =" + result);
            }
            if (existing == null) {
                TransactionUtil.getInstance().registerExtendedWithTransaction(this.puScopedName, result);
            }
        } else {
            result = this.isInTx ? TransactionUtil.getInstance().getOrCreateTransactionScopedEntityManager(this.emf, this.puScopedName, this.properties) : EntityManagerUtil.createEntityManager(this.emf, this.properties);
        }
        return result;
    }

    @Override
    protected boolean isExtendedPersistenceContext() {
        return false;
    }

    @Override
    protected boolean isInTx() {
        return this.isInTx;
    }

    @Override
    public void close() {
        throw new IllegalStateException("Container managed entity manager can only be closed by the container (auto-cleared at tx/invocation end and closed when owning component is closed.)");
    }
}

