/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.processor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContextType;
import org.jboss.as.ee.component.AbstractComponentDescription;
import org.jboss.as.ee.component.AbstractDeploymentDescriptorBindingsProcessor;
import org.jboss.as.ee.component.BindingDescription;
import org.jboss.as.ee.component.BindingSourceDescription;
import org.jboss.as.ee.component.DeploymentDescriptorEnvironment;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.LazyBindingSourceDescription;
import org.jboss.as.ee.component.LookupBindingSourceDescription;
import org.jboss.as.jpa.container.PersistenceUnitSearch;
import org.jboss.as.jpa.service.PersistenceContextBindingSourceDescription;
import org.jboss.as.jpa.service.PersistenceUnitBindingSourceDescription;
import org.jboss.as.jpa.service.PersistenceUnitService;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.metadata.javaee.spec.PersistenceContextReferenceMetaData;
import org.jboss.metadata.javaee.spec.PersistenceContextReferencesMetaData;
import org.jboss.metadata.javaee.spec.PersistenceUnitReferenceMetaData;
import org.jboss.metadata.javaee.spec.PersistenceUnitReferencesMetaData;
import org.jboss.metadata.javaee.spec.PropertiesMetaData;
import org.jboss.metadata.javaee.spec.PropertyMetaData;
import org.jboss.metadata.javaee.support.ResourceInjectionMetaDataWithDescriptions;
import org.jboss.msc.service.ServiceName;

public class PersistenceRefProcessor
extends AbstractDeploymentDescriptorBindingsProcessor {
    protected List<BindingDescription> processDescriptorEntries(DeploymentUnit deploymentUnit, DeploymentDescriptorEnvironment environment, EEModuleDescription moduleDescription, AbstractComponentDescription componentDescription, ClassLoader classLoader, DeploymentReflectionIndex deploymentReflectionIndex) throws DeploymentUnitProcessingException {
        ArrayList<BindingDescription> bindings = new ArrayList<BindingDescription>();
        bindings.addAll(this.getPersistenceUnitRefs(deploymentUnit, environment, classLoader, deploymentReflectionIndex, moduleDescription, componentDescription));
        bindings.addAll(this.getPersistenceContextRefs(deploymentUnit, environment, classLoader, deploymentReflectionIndex, moduleDescription, componentDescription));
        return bindings;
    }

    private List<BindingDescription> getPersistenceUnitRefs(DeploymentUnit deploymentUnit, DeploymentDescriptorEnvironment environment, ClassLoader classLoader, DeploymentReflectionIndex deploymentReflectionIndex, EEModuleDescription moduleDescription, AbstractComponentDescription componentDescription) throws DeploymentUnitProcessingException {
        ArrayList<BindingDescription> bindingDescriptions = new ArrayList<BindingDescription>();
        if (environment.getEnvironment() == null) {
            return bindingDescriptions;
        }
        PersistenceUnitReferencesMetaData persistenceUnitRefs = environment.getEnvironment().getPersistenceUnitRefs();
        if (persistenceUnitRefs != null) {
            for (PersistenceUnitReferenceMetaData puRef : persistenceUnitRefs) {
                String name = puRef.getName();
                String persistenceUnitName = puRef.getPersistenceUnitName();
                String lookup = puRef.getLookupName();
                if (!this.isEmpty(lookup) && !this.isEmpty(persistenceUnitName)) {
                    throw new DeploymentUnitProcessingException("Cannot specify both <lookup-name> (" + lookup + ") and persistence-unit-name (" + persistenceUnitName + ") in <persistence-unit-ref/> for " + componentDescription);
                }
                if (!name.startsWith("java:")) {
                    name = environment.getDefaultContext() + name;
                }
                BindingDescription bindingDescription = new BindingDescription(name);
                bindingDescriptions.add(bindingDescription);
                this.processInjectionTargets(classLoader, deploymentReflectionIndex, (ResourceInjectionMetaDataWithDescriptions)puRef, bindingDescription, EntityManagerFactory.class);
                bindingDescription.setBindingType(EntityManagerFactory.class.getName());
                if (!this.isEmpty(lookup)) {
                    if (componentDescription != null) {
                        bindingDescription.setReferenceSourceDescription((BindingSourceDescription)new LookupBindingSourceDescription(lookup, componentDescription));
                        continue;
                    }
                    bindingDescription.setReferenceSourceDescription((BindingSourceDescription)new LookupBindingSourceDescription(lookup, moduleDescription));
                    continue;
                }
                if (!this.isEmpty(persistenceUnitName)) {
                    bindingDescription.setReferenceSourceDescription(this.getPersistenceUnitBindingSource(deploymentUnit, persistenceUnitName));
                    continue;
                }
                bindingDescription.setReferenceSourceDescription((BindingSourceDescription)new LazyBindingSourceDescription());
            }
        }
        return bindingDescriptions;
    }

    private List<BindingDescription> getPersistenceContextRefs(DeploymentUnit deploymentUnit, DeploymentDescriptorEnvironment environment, ClassLoader classLoader, DeploymentReflectionIndex deploymentReflectionIndex, EEModuleDescription moduleDescription, AbstractComponentDescription componentDescription) throws DeploymentUnitProcessingException {
        ArrayList<BindingDescription> bindingDescriptions = new ArrayList<BindingDescription>();
        if (environment.getEnvironment() == null) {
            return bindingDescriptions;
        }
        PersistenceContextReferencesMetaData persistenceUnitRefs = environment.getEnvironment().getPersistenceContextRefs();
        if (persistenceUnitRefs != null) {
            for (PersistenceContextReferenceMetaData puRef : persistenceUnitRefs) {
                String name = puRef.getName();
                String persistenceUnitName = puRef.getPersistenceUnitName();
                String lookup = puRef.getLookupName();
                if (!this.isEmpty(lookup) && !this.isEmpty(persistenceUnitName)) {
                    throw new DeploymentUnitProcessingException("Cannot specify both <lookup-name> (" + lookup + ") and persistence-unit-name (" + persistenceUnitName + ") in <persistence-context-ref/> for " + componentDescription);
                }
                if (!name.startsWith("java:")) {
                    name = environment.getDefaultContext() + name;
                }
                BindingDescription bindingDescription = new BindingDescription(name);
                bindingDescriptions.add(bindingDescription);
                this.processInjectionTargets(classLoader, deploymentReflectionIndex, (ResourceInjectionMetaDataWithDescriptions)puRef, bindingDescription, EntityManager.class);
                bindingDescription.setBindingType(EntityManager.class.getName());
                if (!this.isEmpty(lookup)) {
                    if (componentDescription != null) {
                        bindingDescription.setReferenceSourceDescription((BindingSourceDescription)new LookupBindingSourceDescription(lookup, componentDescription));
                        continue;
                    }
                    bindingDescription.setReferenceSourceDescription((BindingSourceDescription)new LookupBindingSourceDescription(lookup, moduleDescription));
                    continue;
                }
                if (!this.isEmpty(persistenceUnitName)) {
                    PropertiesMetaData properties = puRef.getProperties();
                    HashMap<String, String> map = new HashMap<String, String>();
                    if (properties != null) {
                        for (PropertyMetaData prop : properties) {
                            map.put(prop.getKey(), prop.getValue());
                        }
                    }
                    PersistenceContextType type = puRef.getPersistenceContextType() == null ? PersistenceContextType.TRANSACTION : puRef.getPersistenceContextType();
                    bindingDescription.setReferenceSourceDescription(this.getPersistenceContextBindingSource(deploymentUnit, persistenceUnitName, type, map));
                    continue;
                }
                bindingDescription.setReferenceSourceDescription((BindingSourceDescription)new LazyBindingSourceDescription());
            }
        }
        return bindingDescriptions;
    }

    private BindingSourceDescription getPersistenceUnitBindingSource(DeploymentUnit deploymentUnit, String unitName) throws DeploymentUnitProcessingException {
        String scopedPuName = this.getScopedPuName(deploymentUnit, unitName);
        ServiceName puServiceName = this.getPuServiceName(scopedPuName);
        return new PersistenceUnitBindingSourceDescription(puServiceName, deploymentUnit, scopedPuName, EntityManagerFactory.class.getName());
    }

    private BindingSourceDescription getPersistenceContextBindingSource(DeploymentUnit deploymentUnit, String unitName, PersistenceContextType type, Map properties) throws DeploymentUnitProcessingException {
        String scopedPuName = this.getScopedPuName(deploymentUnit, unitName);
        ServiceName puServiceName = this.getPuServiceName(scopedPuName);
        return new PersistenceContextBindingSourceDescription(type, properties, puServiceName, deploymentUnit, scopedPuName, EntityManager.class.getName());
    }

    private String getScopedPuName(DeploymentUnit deploymentUnit, String puName) throws DeploymentUnitProcessingException {
        String scopedPuName = PersistenceUnitSearch.resolvePersistenceUnitSupplier(deploymentUnit, puName);
        if (null == scopedPuName) {
            throw new DeploymentUnitProcessingException("Can't find a deployment unit named " + puName + " at " + deploymentUnit);
        }
        return scopedPuName;
    }

    private ServiceName getPuServiceName(String scopedPuName) throws DeploymentUnitProcessingException {
        return PersistenceUnitService.getPUServiceName(scopedPuName);
    }

    private boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }
}

