/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.injectors;

import javax.persistence.EntityManagerFactory;
import org.hibernate.SessionFactory;
import org.hibernate.ejb.EntityManagerFactoryImpl;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.jpa.service.PersistenceUnitService;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.ValueManagedReference;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;

public class PersistenceUnitInjectionSource
extends InjectionSource {
    private final PersistenceUnitJndiInjectable injectable;
    private final ServiceName puServiceName;

    public PersistenceUnitInjectionSource(ServiceName puServiceName, DeploymentUnit deploymentUnit, String scopedPUName, String injectionTypeName) {
        this.injectable = new PersistenceUnitJndiInjectable(puServiceName, deploymentUnit, scopedPUName, injectionTypeName);
        this.puServiceName = puServiceName;
    }

    public void getResourceValue(InjectionSource.ResolutionContext resolutionContext, ServiceBuilder<?> serviceBuilder, DeploymentPhaseContext phaseContext, Injector<ManagedReferenceFactory> injector) throws DeploymentUnitProcessingException {
        serviceBuilder.addDependencies(new ServiceName[]{this.puServiceName});
        injector.inject((Object)this.injectable);
    }

    public int hashCode() {
        return System.identityHashCode((Object)this);
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    private static final class PersistenceUnitJndiInjectable
    implements ManagedReferenceFactory {
        final ServiceName puServiceName;
        final DeploymentUnit deploymentUnit;
        final String injectionTypeName;
        private static final String ENTITY_MANAGER_FACTORY_CLASS = "javax.persistence.EntityManagerFactory";

        public PersistenceUnitJndiInjectable(ServiceName puServiceName, DeploymentUnit deploymentUnit, String scopedPUName, String injectionTypeName) {
            this.puServiceName = puServiceName;
            this.deploymentUnit = deploymentUnit;
            this.injectionTypeName = injectionTypeName;
        }

        public ManagedReference getReference() {
            PersistenceUnitService service = (PersistenceUnitService)this.deploymentUnit.getServiceRegistry().getRequiredService(this.puServiceName).getValue();
            EntityManagerFactory emf = service.getEntityManagerFactory();
            if (!ENTITY_MANAGER_FACTORY_CLASS.equals(this.injectionTypeName)) {
                try {
                    Class<?> extensionClass = this.getClass().getClassLoader().loadClass(this.injectionTypeName);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("couldn't load " + this.injectionTypeName + " from JPA modules classloader", e);
                }
                if (!(emf instanceof EntityManagerFactoryImpl)) {
                    throw new RuntimeException("Can only inject from a Hibernate EntityManagerFactoryImpl");
                }
                SessionFactory targetValueToInject = ((EntityManagerFactoryImpl)emf).getSessionFactory();
                return new ValueManagedReference((Value)new ImmediateValue((Object)targetValueToInject));
            }
            return new ValueManagedReference((Value)new ImmediateValue((Object)emf));
        }
    }
}

