/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.processor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.ValidationMode;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.validation.ValidatorFactory;
import org.jboss.as.connector.subsystems.datasources.AbstractDataSourceService;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.jpa.classloader.TempClassLoader;
import org.jboss.as.jpa.config.PersistenceUnitMetadata;
import org.jboss.as.jpa.config.PersistenceUnitMetadataHolder;
import org.jboss.as.jpa.persistenceprovider.PersistenceProviderAdapterRegistry;
import org.jboss.as.jpa.processor.JPADeploymentMarker;
import org.jboss.as.jpa.service.JPAService;
import org.jboss.as.jpa.service.PersistenceUnitService;
import org.jboss.as.jpa.spi.PersistenceProviderAdaptor;
import org.jboss.as.jpa.transaction.TransactionUtil;
import org.jboss.as.jpa.validator.SerializableValidatorFactory;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.txn.TransactionManagerService;
import org.jboss.as.txn.TransactionSynchronizationRegistryService;
import org.jboss.as.web.deployment.WarMetaData;
import org.jboss.logging.Logger;
import org.jboss.metadata.web.jboss.ValveMetaData;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.msc.inject.CastingInjector;
import org.jboss.msc.inject.InjectionException;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistryException;
import org.jboss.msc.service.ServiceTarget;

public class PersistenceUnitDeploymentProcessor
implements DeploymentUnitProcessor {
    private static final Logger log = Logger.getLogger((String)"org.jboss.jpa");

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        this.handleWarDeployment(phaseContext);
        this.handleEarDeployment(phaseContext);
        this.handleJarDeployment(phaseContext);
    }

    public void undeploy(DeploymentUnit context) {
    }

    private void handleJarDeployment(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        PersistenceUnitMetadataHolder holder;
        ResourceRoot deploymentRoot;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!PersistenceUnitDeploymentProcessor.isEarDeployment(deploymentUnit) && !PersistenceUnitDeploymentProcessor.isWarDeployment(deploymentUnit) && JPADeploymentMarker.isJPADeployment(deploymentUnit) && (deploymentRoot = (ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT)) != null && (holder = (PersistenceUnitMetadataHolder)deploymentRoot.getAttachment(PersistenceUnitMetadataHolder.PERSISTENCE_UNITS)) != null && holder.getPersistenceUnits().size() > 0) {
            ArrayList<PersistenceUnitMetadataHolder> puList = new ArrayList<PersistenceUnitMetadataHolder>(1);
            puList.add(holder);
            log.trace((Object)("install persistence unit definition for jar " + deploymentRoot.getRootName()));
            this.addPuService(phaseContext, deploymentRoot, puList);
        }
    }

    private void handleWarDeployment(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (PersistenceUnitDeploymentProcessor.isWarDeployment(deploymentUnit) && JPADeploymentMarker.isJPADeployment(deploymentUnit)) {
            PersistenceUnitMetadataHolder holder;
            ResourceRoot deploymentRoot = (ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
            ArrayList<PersistenceUnitMetadataHolder> puList = new ArrayList<PersistenceUnitMetadataHolder>(1);
            if (deploymentRoot != null && (holder = (PersistenceUnitMetadataHolder)deploymentRoot.getAttachment(PersistenceUnitMetadataHolder.PERSISTENCE_UNITS)) != null && holder.getPersistenceUnits().size() > 0) {
                puList.add(holder);
            }
            List resourceRoots = (List)deploymentUnit.getAttachment(Attachments.RESOURCE_ROOTS);
            assert (resourceRoots != null);
            for (ResourceRoot resourceRoot : resourceRoots) {
                if (!resourceRoot.getRoot().getLowerCaseName().endsWith(".jar") || (holder = (PersistenceUnitMetadataHolder)resourceRoot.getAttachment(PersistenceUnitMetadataHolder.PERSISTENCE_UNITS)) == null || holder.getPersistenceUnits().size() <= 0) continue;
                puList.add(holder);
            }
            WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
            if (warMetaData != null && warMetaData.getMergedJBossWebMetaData() != null) {
                ArrayList<ValveMetaData> valves = warMetaData.getMergedJBossWebMetaData().getValves();
                if (valves == null) {
                    valves = new ArrayList<ValveMetaData>();
                    warMetaData.getMergedJBossWebMetaData().setValves(valves);
                }
                ValveMetaData valve = new ValveMetaData();
                valve.setModule("org.jboss.as.jpa");
                valve.setValveClass("org.jboss.as.jpa.interceptor.WebNonTxEmCloserValve");
                valves.add(valve);
            }
            log.trace((Object)("install persistence unit definitions for war " + deploymentRoot.getRootName()));
            this.addPuService(phaseContext, deploymentRoot, puList);
        }
    }

    private void handleEarDeployment(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (PersistenceUnitDeploymentProcessor.isEarDeployment(deploymentUnit) && JPADeploymentMarker.isJPADeployment(deploymentUnit)) {
            PersistenceUnitMetadataHolder holder;
            ResourceRoot deploymentRoot = (ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
            ArrayList<PersistenceUnitMetadataHolder> puList = new ArrayList<PersistenceUnitMetadataHolder>(1);
            if (deploymentRoot != null && (holder = (PersistenceUnitMetadataHolder)deploymentRoot.getAttachment(PersistenceUnitMetadataHolder.PERSISTENCE_UNITS)) != null && holder.getPersistenceUnits().size() > 0) {
                puList.add(holder);
            }
            log.trace((Object)("install persistence unit definitions for ear " + deploymentRoot.getRootName()));
            this.addPuService(phaseContext, deploymentRoot, puList);
        }
    }

    private void addPuService(DeploymentPhaseContext phaseContext, ResourceRoot resourceRoot, ArrayList<PersistenceUnitMetadataHolder> puList) throws DeploymentUnitProcessingException {
        if (puList.size() > 0) {
            DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
            Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
            if (module == null) {
                throw new DeploymentUnitProcessingException("Failed to get module attachment for " + phaseContext.getDeploymentUnit());
            }
            ServiceTarget serviceTarget = phaseContext.getServiceTarget();
            ModuleClassLoader classLoader = module.getClassLoader();
            for (PersistenceUnitMetadataHolder holder : puList) {
                for (PersistenceUnitMetadata pu : holder.getPersistenceUnits()) {
                    pu.setClassLoader((ClassLoader)classLoader);
                    pu.setTempClassloader((ClassLoader)((Object)new TempClassLoader(classLoader)));
                    try {
                        Iterable<ServiceName> providerDependencies;
                        String defaultJtaDataSource;
                        PersistenceUnitService service = new PersistenceUnitService(pu, resourceRoot);
                        Injector<TransactionManager> transactionManagerInjector = new Injector<TransactionManager>(){

                            public void inject(TransactionManager value) throws InjectionException {
                                TransactionUtil.setTransactionManager(value);
                            }

                            public void uninject() {
                            }
                        };
                        Injector<TransactionSynchronizationRegistry> transactionRegistryInjector = new Injector<TransactionSynchronizationRegistry>(){

                            public void inject(TransactionSynchronizationRegistry value) throws InjectionException {
                                TransactionUtil.setTransactionSynchronizationRegistry(value);
                            }

                            public void uninject() {
                            }
                        };
                        HashMap<String, ValidatorFactory> properties = new HashMap<String, ValidatorFactory>();
                        if (!ValidationMode.NONE.equals((Object)pu.getValidationMode())) {
                            ValidatorFactory validatorFactory = SerializableValidatorFactory.getINSTANCE();
                            properties.put("javax.persistence.validation.factory", validatorFactory);
                        }
                        this.addProviderProperties(pu, properties);
                        ServiceName serviceName = PersistenceUnitService.getPUServiceName(pu);
                        deploymentUnit.addToAttachmentList(Attachments.WEB_DEPENDENCIES, (Object)serviceName);
                        ServiceBuilder builder = serviceTarget.addService(serviceName, (Service)service);
                        boolean useDefaultDataSource = true;
                        String jtaDataSource = this.adjustJndi(pu.getJtaDataSourceName());
                        String nonJtaDataSource = this.adjustJndi(pu.getNonJtaDataSourceName());
                        if (jtaDataSource != null) {
                            builder.addDependency(AbstractDataSourceService.SERVICE_NAME_BASE.append(new String[]{jtaDataSource}), (Injector)new CastingInjector(service.getJtaDataSourceInjector(), DataSource.class));
                            useDefaultDataSource = false;
                        }
                        if (nonJtaDataSource != null) {
                            builder.addDependency(AbstractDataSourceService.SERVICE_NAME_BASE.append(new String[]{nonJtaDataSource}), (Injector)new CastingInjector(service.getNonJtaDataSourceInjector(), DataSource.class));
                            useDefaultDataSource = false;
                        }
                        if (useDefaultDataSource && (defaultJtaDataSource = this.adjustJndi(JPAService.getDefaultDataSourceName())) != null && defaultJtaDataSource.length() > 0) {
                            builder.addDependency(AbstractDataSourceService.SERVICE_NAME_BASE.append(new String[]{defaultJtaDataSource}), (Injector)new CastingInjector(service.getJtaDataSourceInjector(), DataSource.class));
                            log.trace((Object)(serviceName + " is using the default data source '" + defaultJtaDataSource + "'"));
                        }
                        if ((providerDependencies = this.getProviderDependencies(pu)) != null) {
                            builder.addDependencies(providerDependencies);
                        }
                        builder.addDependency(TransactionManagerService.SERVICE_NAME, (Injector)new CastingInjector((Injector)transactionManagerInjector, TransactionManager.class)).addDependency(TransactionSynchronizationRegistryService.SERVICE_NAME, (Injector)new CastingInjector((Injector)transactionRegistryInjector, TransactionSynchronizationRegistry.class)).setInitialMode(ServiceController.Mode.ACTIVE).addInjection(service.getPropertiesInjector(), properties).install();
                        log.trace((Object)("added PersistenceUnitService for '" + serviceName + "'.  PU is ready for injector action. "));
                    }
                    catch (ServiceRegistryException e) {
                        throw new DeploymentUnitProcessingException("Failed to add persistence unit service for " + pu.getPersistenceUnitName(), (Throwable)e);
                    }
                }
            }
        }
    }

    private String adjustJndi(String dataSourceName) {
        if (dataSourceName != null && !dataSourceName.startsWith("java:")) {
            return "java:/" + dataSourceName;
        }
        return dataSourceName;
    }

    private void addProviderProperties(PersistenceUnitMetadata pu, Map properties) {
        PersistenceProviderAdaptor adaptor = PersistenceProviderAdapterRegistry.getPersistenceProviderAdaptor(pu.getPersistenceProviderClassName());
        adaptor.addProviderProperties(properties, pu);
    }

    private Iterable<ServiceName> getProviderDependencies(PersistenceUnitMetadata pu) {
        PersistenceProviderAdaptor adaptor = PersistenceProviderAdapterRegistry.getPersistenceProviderAdaptor(pu.getPersistenceProviderClassName());
        Iterable<ServiceName> providerDependencies = adaptor.getProviderDependencies(pu);
        return providerDependencies;
    }

    static boolean isEarDeployment(DeploymentUnit context) {
        return DeploymentTypeMarker.isType((DeploymentType)DeploymentType.EAR, (DeploymentUnit)context);
    }

    static boolean isWarDeployment(DeploymentUnit context) {
        return DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)context);
    }
}

