/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.subsystem;

import java.util.Locale;
import javax.persistence.spi.PersistenceProviderResolver;
import javax.persistence.spi.PersistenceProviderResolverHolder;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelAddOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.jpa.hibernate.HibernatePersistenceProviderAdaptor;
import org.jboss.as.jpa.persistenceprovider.PersistenceProviderAdapterRegistry;
import org.jboss.as.jpa.persistenceprovider.PersistenceProviderResolverImpl;
import org.jboss.as.jpa.processor.JPAAnnotationParseProcessor;
import org.jboss.as.jpa.processor.JPADependencyProcessor;
import org.jboss.as.jpa.processor.PersistenceRefProcessor;
import org.jboss.as.jpa.processor.PersistenceUnitDeploymentProcessor;
import org.jboss.as.jpa.processor.PersistenceUnitParseProcessor;
import org.jboss.as.jpa.service.JPAService;
import org.jboss.as.jpa.subsystem.JPADescriptions;
import org.jboss.as.server.BootOperationContext;
import org.jboss.as.server.BootOperationHandler;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceTarget;

class JPASubSystemAdd
implements ModelAddOperationHandler,
BootOperationHandler,
DescriptionProvider {
    static final String OPERATION_NAME = "add";
    static final JPASubSystemAdd INSTANCE = new JPASubSystemAdd();
    private ParametersValidator modelValidator = new ParametersValidator();
    private ParametersValidator runtimeValidator = new ParametersValidator();

    static ModelNode getAddOperation(ModelNode address, ModelNode currentModel) {
        ModelNode addOp = Util.getEmptyOperation((String)OPERATION_NAME, (ModelNode)address);
        addOp.get("default-datasource").set(currentModel.get("default-datasource"));
        return addOp;
    }

    private JPASubSystemAdd() {
        this.modelValidator.registerValidator("default-datasource", (ParameterValidator)new StringLengthValidator(0, Integer.MAX_VALUE, false, true));
        this.runtimeValidator.registerValidator("default-datasource", (ParameterValidator)new StringLengthValidator(0, Integer.MAX_VALUE, false, false));
    }

    public OperationResult execute(OperationContext context, ModelNode operation, final ResultHandler resultHandler) throws OperationFailedException {
        this.modelValidator.validate(operation);
        ModelNode defaultDSNode = operation.require("default-datasource");
        context.getSubModel().get("default-datasource").set(defaultDSNode);
        ModelNode compensatingOperation = Util.getResourceRemoveOperation((ModelNode)operation.require("address"));
        if (context instanceof BootOperationContext) {
            PersistenceProviderResolverHolder.setPersistenceProviderResolver((PersistenceProviderResolver)PersistenceProviderResolverImpl.getInstance());
            PersistenceProviderAdapterRegistry.putPersistenceProviderAdaptor("org.hibernate.ejb.HibernatePersistence", new HibernatePersistenceProviderAdaptor());
            BootOperationContext updateContext = (BootOperationContext)context;
            updateContext.addDeploymentProcessor(Phase.PARSE, 12032, (DeploymentUnitProcessor)new PersistenceUnitParseProcessor());
            updateContext.addDeploymentProcessor(Phase.PARSE, 12288, (DeploymentUnitProcessor)new JPAAnnotationParseProcessor());
            updateContext.addDeploymentProcessor(Phase.DEPENDENCIES, 4096, (DeploymentUnitProcessor)new JPADependencyProcessor());
            updateContext.addDeploymentProcessor(Phase.INSTALL, 4096, (DeploymentUnitProcessor)new PersistenceRefProcessor());
            updateContext.addDeploymentProcessor(Phase.INSTALL, 6736, (DeploymentUnitProcessor)new PersistenceUnitDeploymentProcessor());
        }
        if (context.getRuntimeContext() != null) {
            this.runtimeValidator.validate(operation.resolve());
            final String dataSourceName = defaultDSNode.resolve().asString();
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    ServiceTarget target = context.getServiceTarget();
                    JPAService.addService(target, dataSourceName);
                    resultHandler.handleResultComplete();
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
        return new BasicOperationResult(compensatingOperation);
    }

    public ModelNode getModelDescription(Locale locale) {
        return JPADescriptions.getSubsystemAdd(locale);
    }
}

