/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.subsystem;

import java.util.Locale;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelRemoveOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.jpa.service.JPAService;
import org.jboss.as.jpa.subsystem.JPADescriptions;
import org.jboss.as.jpa.subsystem.JPASubSystemAdd;
import org.jboss.as.server.BootOperationHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;

class JPASubSystemRemove
implements ModelRemoveOperationHandler,
BootOperationHandler,
DescriptionProvider {
    static final JPASubSystemRemove INSTANCE = new JPASubSystemRemove();
    static final String OPERATION_NAME = "remove";

    private JPASubSystemRemove() {
    }

    public OperationResult execute(OperationContext context, ModelNode operation, final ResultHandler resultHandler) throws OperationFailedException {
        ModelNode compensatingOperation = JPASubSystemAdd.getAddOperation(operation.require("address"), context.getSubModel());
        if (context.getRuntimeContext() != null) {
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    ServiceRegistry registry = context.getServiceRegistry();
                    ServiceController jpaService = registry.getService(JPAService.SERVICE_NAME);
                    if (jpaService != null) {
                        jpaService.setMode(ServiceController.Mode.REMOVE);
                    }
                    resultHandler.handleResultComplete();
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
        return new BasicOperationResult(compensatingOperation);
    }

    public ModelNode getModelDescription(Locale locale) {
        return JPADescriptions.getSubsystemRemove(locale);
    }
}

