/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.container;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import org.jboss.as.jpa.container.EntityManagerMetadata;
import org.jboss.as.jpa.container.SFSBXPCMap;
import org.jboss.as.jpa.spi.SFSBContextHandle;

public class SFSBCallStack {
    private static ThreadLocal<ArrayList<SFSBContextHandle>> SFSBInvocationStack = new ThreadLocal<ArrayList<SFSBContextHandle>>(){

        @Override
        protected ArrayList<SFSBContextHandle> initialValue() {
            return new ArrayList<SFSBContextHandle>();
        }
    };
    private static ThreadLocal<Map<String, EntityManager>> sfsbCreationMap = new ThreadLocal();
    private static ThreadLocal<Integer> sfsbCreationCallStackCount = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };

    public static void beginSfsbCreation() {
        int no = sfsbCreationCallStackCount.get();
        if (no == 0) {
            sfsbCreationMap.set(new HashMap());
        }
        sfsbCreationCallStackCount.set(no + 1);
    }

    public static void endSfsbCreation() {
        int no = sfsbCreationCallStackCount.get();
        sfsbCreationCallStackCount.set(--no);
        if (no == 0) {
            sfsbCreationMap.remove();
        }
    }

    public static void extendedPersistenceContextCreated(String scopedPuName, EntityManager entityManager) {
        Map<String, EntityManager> map;
        if (sfsbCreationCallStackCount.get() > 0 && !(map = sfsbCreationMap.get()).containsKey(scopedPuName)) {
            map.put(scopedPuName, entityManager);
        }
    }

    public static EntityManager findPersistenceContext(String puScopedName, SFSBXPCMap sfsbxpcMap) {
        for (SFSBContextHandle handle : SFSBCallStack.currentSFSBCallStack()) {
            List<EntityManager> xpcs = sfsbxpcMap.getXPC(handle);
            if (xpcs == null) continue;
            for (EntityManager xpc : xpcs) {
                if (xpc == null || !((EntityManagerMetadata)xpc.unwrap(EntityManagerMetadata.class)).getScopedPuName().equals(puScopedName)) continue;
                return xpc;
            }
        }
        Map<String, EntityManager> map = sfsbCreationMap.get();
        if (map != null) {
            return map.get(puScopedName);
        }
        return null;
    }

    public static ArrayList<SFSBContextHandle> currentSFSBCallStack() {
        return SFSBInvocationStack.get();
    }

    public static void pushCall(SFSBContextHandle beanContextHandle) {
        SFSBCallStack.currentSFSBCallStack().add(beanContextHandle);
    }

    public static SFSBContextHandle popCall() {
        ArrayList<SFSBContextHandle> stack = SFSBCallStack.currentSFSBCallStack();
        SFSBContextHandle result = stack.remove(stack.size() - 1);
        stack.trimToSize();
        return result;
    }
}

