/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.processor;

import java.util.Set;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentConfigurator;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ee.component.ViewConfigurator;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.jpa.container.SFSBXPCMap;
import org.jboss.as.jpa.interceptor.SBInvocationInterceptor;
import org.jboss.as.jpa.interceptor.SFSBCreateInterceptor;
import org.jboss.as.jpa.interceptor.SFSBDestroyInterceptor;
import org.jboss.as.jpa.interceptor.SFSBInvocationInterceptor;
import org.jboss.as.jpa.interceptor.SFSBPreCreateInterceptor;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.invocation.InterceptorFactory;

public class JPAInterceptorProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        for (ComponentDescription component : moduleDescription.getComponentDescriptions()) {
            if (!(component instanceof SessionBeanComponentDescription)) continue;
            this.registerSessionBeanInterceptors((SessionBeanComponentDescription)component, deploymentUnit);
        }
    }

    private void registerSessionBeanInterceptors(SessionBeanComponentDescription componentDescription, final DeploymentUnit deploymentUnit) {
        if (componentDescription.isStateful()) {
            componentDescription.getConfigurators().addFirst(new ComponentConfigurator(){

                public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
                    SFSBXPCMap map = SFSBXPCMap.getXpcMap(deploymentUnit);
                    configuration.addPostConstructInterceptor(SFSBPreCreateInterceptor.FACTORY, 1024);
                    configuration.addPostConstructInterceptor((InterceptorFactory)new SFSBCreateInterceptor.Factory(map), 2560);
                    configuration.addPreDestroyInterceptor((InterceptorFactory)new SFSBDestroyInterceptor.Factory(map), 1280);
                }
            });
            Set views = componentDescription.getViews();
            for (ViewDescription view : views) {
                view.getConfigurators().addFirst(new ViewConfigurator(){

                    public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration configuration) throws DeploymentUnitProcessingException {
                        configuration.addViewInterceptor(SFSBInvocationInterceptor.FACTORY, 2048);
                    }
                });
            }
        }
        if (componentDescription.isStateful() || componentDescription.isStateless()) {
            componentDescription.getConfigurators().add(new ComponentConfigurator(){

                public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
                    configuration.addComponentInterceptor(SBInvocationInterceptor.FACTORY, 1536, false);
                }
            });
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

