/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.processor;

import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarFile;
import org.jboss.as.jpa.JpaLogger;
import org.jboss.as.jpa.JpaMessages;
import org.jboss.as.jpa.config.Configuration;
import org.jboss.as.jpa.config.PersistenceUnitMetadataHolder;
import org.jboss.as.jpa.config.PersistenceUnitsInApplication;
import org.jboss.as.jpa.processor.JPADeploymentMarker;
import org.jboss.as.jpa.processor.JpaAttachments;
import org.jboss.as.jpa.spi.PersistenceUnitMetadata;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.DeploymentUtils;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ResourceLoader;
import org.jboss.modules.ResourceLoaderSpec;
import org.jboss.modules.ResourceLoaders;

public class JPADependencyProcessor
implements DeploymentUnitProcessor {
    private static final ModuleIdentifier JAVAX_PERSISTENCE_API_ID = ModuleIdentifier.create((String)"javax.persistence.api");
    private static final ModuleIdentifier JAVAEE_API_ID = ModuleIdentifier.create((String)"javaee.api");
    private static final ModuleIdentifier JBOSS_AS_JPA_ID = ModuleIdentifier.create((String)"org.jboss.as.jpa");
    private static final ModuleIdentifier JBOSS_AS_JPA_SPI_ID = ModuleIdentifier.create((String)"org.jboss.as.jpa.spi");
    private static final ModuleIdentifier JAVASSIST_ID = ModuleIdentifier.create((String)"org.javassist");
    private static final ModuleIdentifier HIBERNATE_3_PROVIDER = ModuleIdentifier.create((String)"org.jboss.as.jpa.hibernate", (String)"3");
    private static final String HIBERNATE3_PROVIDER_ADAPTOR = "org.jboss.as.jpa.hibernate3.HibernatePersistenceProviderAdaptor";
    private static final ModuleIdentifier HIBERNATE_ENVERS_ID = ModuleIdentifier.create((String)"org.hibernate.envers");
    private static final ModuleIdentifier JBOSS_AS_NAMING_ID = ModuleIdentifier.create((String)"org.jboss.as.naming");
    private static final ModuleIdentifier JBOSS_JANDEX_ID = ModuleIdentifier.create((String)"org.jboss.jandex");

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        this.addDependency(moduleSpecification, moduleLoader, JAVAX_PERSISTENCE_API_ID);
        if (!JPADeploymentMarker.isJPADeployment(deploymentUnit)) {
            JpaLogger.ROOT_LOGGER.debugf("added javax.persistence.api dependency to %s", (Object)deploymentUnit.getName());
            return;
        }
        this.addDependency(moduleSpecification, moduleLoader, JAVAEE_API_ID);
        this.addDependency(moduleSpecification, moduleLoader, JBOSS_AS_JPA_ID);
        this.addDependency(moduleSpecification, moduleLoader, JBOSS_AS_JPA_SPI_ID);
        this.addDependency(moduleSpecification, moduleLoader, JAVASSIST_ID);
        JpaLogger.ROOT_LOGGER.debugf("added javax.persistence.api, javaee.api, org.jboss.as.jpa, org.javassist dependencies to %s", (Object)deploymentUnit.getName());
        this.addPersistenceProviderModuleDependencies(phaseContext, moduleSpecification, moduleLoader);
    }

    private void addDependency(ModuleSpecification moduleSpecification, ModuleLoader moduleLoader, ModuleIdentifier moduleIdentifier) {
        moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, moduleIdentifier, false, false, false, false));
    }

    public void undeploy(DeploymentUnit context) {
    }

    private void addPersistenceProviderModuleDependencies(DeploymentPhaseContext phaseContext, ModuleSpecification moduleSpecification, ModuleLoader moduleLoader) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        int defaultProviderCount = 0;
        HashSet<String> moduleDependencies = new HashSet<String>();
        PersistenceUnitsInApplication persistenceUnitsInApplication = (PersistenceUnitsInApplication)DeploymentUtils.getTopDeploymentUnit((DeploymentUnit)deploymentUnit).getAttachment(PersistenceUnitsInApplication.PERSISTENCE_UNITS_IN_APPLICATION);
        for (PersistenceUnitMetadataHolder holder : persistenceUnitsInApplication.getPersistenceUnitHolders()) {
            defaultProviderCount += this.loadPersistenceUnits(moduleLoader, deploymentUnit, moduleDependencies, holder);
        }
        if (defaultProviderCount > 0) {
            moduleDependencies.add("org.hibernate");
            JpaLogger.ROOT_LOGGER.debugf("added (default provider) %s dependency to %s (since %d PU(s) didn't specify %s", new Object[]{"org.hibernate", deploymentUnit.getName(), defaultProviderCount, "jboss.as.jpa.providerModule)"});
            this.addDependency(moduleSpecification, moduleLoader, HIBERNATE_ENVERS_ID);
        }
        for (String dependency : moduleDependencies) {
            this.addDependency(moduleSpecification, moduleLoader, ModuleIdentifier.fromString((String)dependency));
            JpaLogger.ROOT_LOGGER.debugf("added %s dependency to application deployment", (Object)dependency);
        }
    }

    private int loadPersistenceUnits(ModuleLoader moduleLoader, DeploymentUnit deploymentUnit, Set<String> moduleDependencies, PersistenceUnitMetadataHolder holder) throws DeploymentUnitProcessingException {
        int defaultProviderCount = 0;
        if (holder != null) {
            for (PersistenceUnitMetadata pu : holder.getPersistenceUnits()) {
                String providerModule = pu.getProperties().getProperty("jboss.as.jpa.providerModule");
                String adapterModule = pu.getProperties().getProperty("jboss.as.jpa.adapterModule");
                String adapterClass = pu.getProperties().getProperty("jboss.as.jpa.adapterClass");
                if (providerModule != null) {
                    if (providerModule.equals("hibernate3-bundled")) {
                        adapterClass = HIBERNATE3_PROVIDER_ADAPTOR;
                        pu.getProperties().put("jboss.as.jpa.adapterClass", adapterClass);
                        pu.getProperties().put("jboss.as.jpa.providerModule", "application");
                        pu.getProperties().remove("jboss.as.jpa.adapterModule");
                        this.addHibernate3AdaptorToDeployment(moduleLoader, deploymentUnit);
                    } else if (providerModule.equals("org.hibernate:3") && adapterModule == null) {
                        adapterModule = "org.jboss.as.jpa.hibernate:3";
                        pu.getProperties().put("jboss.as.jpa.adapterModule", adapterModule);
                    }
                }
                if (adapterModule != null) {
                    JpaLogger.ROOT_LOGGER.debugf("%s is configured to use adapter module '%s'", (Object)pu.getPersistenceUnitName(), (Object)adapterModule);
                    moduleDependencies.add(adapterModule);
                }
                deploymentUnit.putAttachment(JpaAttachments.ADAPTOR_CLASS_NAME, (Object)adapterClass);
                String provider = pu.getProperties().getProperty("jboss.as.jpa.providerModule");
                if (provider != null) {
                    if (provider.equals("application")) {
                        JpaLogger.ROOT_LOGGER.debugf("%s is configured to use application supplied persistence provider", (Object)pu.getPersistenceUnitName());
                        continue;
                    }
                    moduleDependencies.add(provider);
                    JpaLogger.ROOT_LOGGER.debugf("%s is configured to use provider module '%s'", (Object)pu.getPersistenceUnitName(), (Object)provider);
                    continue;
                }
                if ("org.hibernate.ejb.HibernatePersistence".equals(pu.getPersistenceProviderClassName())) {
                    ++defaultProviderCount;
                    continue;
                }
                String providerModuleName = Configuration.getProviderModuleNameFromProviderClassName(pu.getPersistenceProviderClassName());
                if (providerModuleName == null) continue;
                moduleDependencies.add(providerModuleName);
                JpaLogger.ROOT_LOGGER.debugf("%s is configured to use provider module '%s'", (Object)pu.getPersistenceUnitName(), (Object)providerModuleName);
            }
        }
        return defaultProviderCount;
    }

    private void addHibernate3AdaptorToDeployment(ModuleLoader moduleLoader, DeploymentUnit deploymentUnit) {
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        try {
            Module module = moduleLoader.loadModule(HIBERNATE_3_PROVIDER);
            URL url = module.getClassLoader().getResource(HIBERNATE3_PROVIDER_ADAPTOR.replace('.', '/') + ".class");
            URLConnection connection = url.openConnection();
            if (!(connection instanceof JarURLConnection)) {
                throw JpaMessages.MESSAGES.invalidUrlConnection("hibernate 3", connection);
            }
            JarFile jarFile = ((JarURLConnection)connection).getJarFile();
            moduleSpecification.addResourceLoader(ResourceLoaderSpec.createResourceLoaderSpec((ResourceLoader)ResourceLoaders.createJarResourceLoader((String)"hibernate3integration", (JarFile)jarFile)));
            this.addDependency(moduleSpecification, moduleLoader, JBOSS_AS_NAMING_ID);
            this.addDependency(moduleSpecification, moduleLoader, JBOSS_JANDEX_ID);
        }
        catch (ModuleLoadException e) {
            throw JpaMessages.MESSAGES.cannotLoadModule((Throwable)e, HIBERNATE_3_PROVIDER, "hibernate 3");
        }
        catch (MalformedURLException e) {
            throw JpaMessages.MESSAGES.cannotAddIntegration((Throwable)e, "hibernate 3");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

