/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.processor;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.spi.PersistenceProvider;
import org.jboss.as.jpa.JpaLogger;
import org.jboss.as.jpa.JpaMessages;
import org.jboss.as.jpa.config.PersistenceProviderDeploymentHolder;
import org.jboss.as.jpa.processor.JpaAttachments;
import org.jboss.as.jpa.spi.PersistenceProviderAdaptor;
import org.jboss.as.jpa.transaction.JtaManagerImpl;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.ServicesAttachment;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;

public class PersistenceProviderProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        ServicesAttachment servicesAttachment = (ServicesAttachment)deploymentUnit.getAttachment(Attachments.SERVICES);
        if (module != null && servicesAttachment != null) {
            ModuleClassLoader deploymentModuleClassLoader = module.getClassLoader();
            ArrayList<PersistenceProvider> providerList = new ArrayList<PersistenceProvider>();
            List providerNames = servicesAttachment.getServiceImplementations(PersistenceProvider.class.getName());
            for (String providerName : providerNames) {
                try {
                    Class<PersistenceProvider> providerClass = deploymentModuleClassLoader.loadClass(providerName).asSubclass(PersistenceProvider.class);
                    Constructor<PersistenceProvider> constructor = providerClass.getConstructor(new Class[0]);
                    PersistenceProvider provider = constructor.newInstance(new Object[0]);
                    JpaLogger.ROOT_LOGGER.debugf("Deployment has its own Persistence Provider %s ", providerClass);
                    providerList.add(provider);
                }
                catch (Exception e) {
                    throw JpaMessages.MESSAGES.cannotDeployApp((Throwable)e, providerName);
                }
            }
            if (providerList.size() > 0) {
                String adapterClass = (String)deploymentUnit.getAttachment(JpaAttachments.ADAPTOR_CLASS_NAME);
                PersistenceProviderAdaptor adaptor = null;
                if (adapterClass != null) {
                    try {
                        adaptor = (PersistenceProviderAdaptor)deploymentModuleClassLoader.loadClass(adapterClass).newInstance();
                        adaptor.injectJtaManager(JtaManagerImpl.getInstance());
                        deploymentUnit.putAttachment(JpaAttachments.DEPLOYED_PERSISTENCE_PROVIDER, (Object)new PersistenceProviderDeploymentHolder(providerList, adaptor));
                    }
                    catch (InstantiationException e) {
                        throw JpaMessages.MESSAGES.cannotCreateAdapter((Throwable)e, adapterClass);
                    }
                    catch (IllegalAccessException e) {
                        throw JpaMessages.MESSAGES.cannotCreateAdapter((Throwable)e, adapterClass);
                    }
                    catch (ClassNotFoundException e) {
                        throw JpaMessages.MESSAGES.cannotCreateAdapter((Throwable)e, adapterClass);
                    }
                }
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

