/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.as.deployment.managedbean.config;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.List;

/**
 * Configuration for an interceptor bound to a managed bean class.
 *
 * @author John E. Bailey
 */
public class InterceptorConfiguration implements Serializable {
    private static final long serialVersionUID = -8426598906784188619L;

    private Class<?> interceptorClass;
    private Method aroundInvokeMethod;
    private List<ResourceConfiguration> resourceConfigurations;

    /**
     * Create default instance.
     */
    public InterceptorConfiguration() {
    }

    /**
     * Create an instance with the interceptor class and the resource configurations.
     *
     * @param interceptorClass The interceptor class type
     * @param aroundInvokeMethod The around invoke method
     * @param resourceConfigurations The resource injection configurations
     */
    public InterceptorConfiguration(final Class<?> interceptorClass, final Method aroundInvokeMethod,  final List<ResourceConfiguration> resourceConfigurations) {
        this.interceptorClass = interceptorClass;
        this.aroundInvokeMethod = aroundInvokeMethod;
        this.resourceConfigurations = resourceConfigurations;
    }

    /**
     * Get the interceptor class.
     *
     * @return The interceptor class
     */
    public Class<?> getInterceptorClass() {
        return interceptorClass;
    }

    /**
     * Set the interceptor class.
     *
     * @param interceptorClass The interceptor class
     */
    public void setInterceptorClass(final Class<?> interceptorClass) {
        this.interceptorClass = interceptorClass;
    }

    /**
     * Get the resource configurations.
     *
     * @return The resource configurations
     */
    public List<ResourceConfiguration> getResourceConfigurations() {
        return resourceConfigurations;
    }

    /**
     * Set the resource configurations.
     *
     * @param resourceConfigurations The resource configurations
     */
    public void setResourceConfigurations(final List<ResourceConfiguration> resourceConfigurations) {
        this.resourceConfigurations = resourceConfigurations;
    }

    /**
     * Get the around invoke method.
     *
     * @return The around invoke method
     */
    public Method getAroundInvokeMethod() {
        return aroundInvokeMethod;
    }

    /**
     * Set the around invoke method.
     *
     * @param aroundInvokeMethod  The around invoke method
     */
    public void setAroundInvokeMethod(Method aroundInvokeMethod) {
        this.aroundInvokeMethod = aroundInvokeMethod;
    }
}
