/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.deployment.managedbean.container;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.jboss.as.deployment.managedbean.container.ManagedBeanInterceptor;
import org.jboss.as.deployment.managedbean.container.ManagedBeanProxyHandler;
import org.jboss.as.deployment.managedbean.container.ResourceInjection;
import org.jboss.as.deployment.managedbean.container.SecurityActions;

public class ManagedBeanContainer<T> {
    private final Class<T> beanClass;
    private final ClassLoader deploymentClassLoader;
    private final List<Method> postConstructMethods;
    private final List<Method> preDestroyMethods;
    private final List<ResourceInjection<?>> resourceInjections;
    private final List<ManagedBeanInterceptor<?>> interceptors;

    public ManagedBeanContainer(Class<T> beanClass, ClassLoader deploymentClassLoader, List<Method> postConstructMethods, List<Method> preDestroyMethods, List<ResourceInjection<?>> resourceInjections, List<ManagedBeanInterceptor<?>> interceptors) {
        this.beanClass = beanClass;
        this.deploymentClassLoader = deploymentClassLoader;
        this.postConstructMethods = postConstructMethods;
        this.preDestroyMethods = preDestroyMethods;
        this.resourceInjections = resourceInjections;
        this.interceptors = interceptors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T createInstance() {
        T managedBean;
        try {
            managedBean = this.beanClass.newInstance();
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to instantiate instance of MangedBean: " + this.beanClass);
        }
        for (ResourceInjection<?> resourceInjection : this.resourceInjections) {
            resourceInjection.inject(managedBean);
        }
        ClassLoader contextCl = SecurityActions.getContextClassLoader();
        SecurityActions.setContextClassLoader(this.deploymentClassLoader);
        try {
            if (this.postConstructMethods != null) {
                for (Method postConstructMethod : this.postConstructMethods) {
                    try {
                        postConstructMethod.invoke(managedBean, new Object[0]);
                    }
                    catch (Throwable t) {
                        throw new RuntimeException("Failed to invoke post construct method '" + postConstructMethod.getName() + "' for class " + this.beanClass, t);
                    }
                }
            }
        }
        finally {
            SecurityActions.setContextClassLoader(contextCl);
        }
        if (this.interceptors.isEmpty()) return managedBean;
        ArrayList aroundInvokeInterceptors = new ArrayList(this.interceptors.size());
        for (ManagedBeanInterceptor<?> managedBeanInterceptor : this.interceptors) {
            try {
                aroundInvokeInterceptors.add(managedBeanInterceptor.createInstance());
            }
            catch (Throwable t) {
                throw new RuntimeException("Failed to create instance of interceptor " + managedBeanInterceptor.toString(), t);
            }
        }
        try {
            managedBean = ManagedBeanProxyHandler.createProxy(this.beanClass, this.deploymentClassLoader, managedBean, aroundInvokeInterceptors);
            return managedBean;
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to create managed bean proxy for " + this.beanClass, t);
        }
    }
}

