/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.deployment.managedbean.container;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.jboss.as.deployment.managedbean.container.ManagedBeanContainer;
import org.jboss.as.deployment.managedbean.container.ManagedBeanRegistry;
import org.jboss.as.naming.context.ModularReference;
import org.jboss.modules.Module;

public class ManagedBeanObjectFactory
implements ObjectFactory {
    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        Reference reference = (Reference)Reference.class.cast(obj);
        RefAddr refAddr = reference.get(0);
        String managedBeanName = (String)refAddr.getContent();
        ManagedBeanContainer<?> managedBeanService = ManagedBeanRegistry.get(managedBeanName);
        if (managedBeanService == null) {
            throw new NamingException("Managed bean does not exist with name: " + managedBeanName);
        }
        return managedBeanService.createInstance();
    }

    public static ModularReference createReference(Class<?> managedBeanClass, String beanName) {
        ServiceNameRefAdr refAddr = new ServiceNameRefAdr(beanName);
        return new ModularReference(managedBeanClass.getName(), (RefAddr)refAddr, ManagedBeanObjectFactory.class.getName(), Module.forClass(ManagedBeanObjectFactory.class).getIdentifier());
    }

    public static final class ServiceNameRefAdr
    extends RefAddr {
        private static final long serialVersionUID = -8030736501810800377L;
        private final String beanName;

        public ServiceNameRefAdr(String beanName) {
            super("ManagedBeanName");
            this.beanName = beanName;
        }

        @Override
        public Object getContent() {
            return this.beanName;
        }
    }
}

