/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.deployment.managedbean.container;

import java.lang.reflect.Method;
import java.util.List;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import javassist.util.proxy.ProxyObject;
import javax.interceptor.ExcludeClassInterceptors;
import org.jboss.as.deployment.managedbean.container.InvocationContext;
import org.jboss.as.deployment.managedbean.container.ManagedBeanInterceptor;
import org.jboss.as.deployment.managedbean.container.SecurityActions;

public class ManagedBeanProxyHandler<T>
implements MethodHandler {
    private final List<ManagedBeanInterceptor.AroundInvokeInterceptor<?>> interceptors;
    private final T instance;
    private final ClassLoader deploymentClassLoader;

    public static <T> T createProxy(Class<T> managedBeanClass, ClassLoader deploymentClassLoader, T managedBean, List<ManagedBeanInterceptor.AroundInvokeInterceptor<?>> interceptors) throws IllegalAccessException, InstantiationException {
        ManagedBeanProxyHandler<T> handler = new ManagedBeanProxyHandler<T>(managedBean, interceptors, deploymentClassLoader);
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.setSuperclass(managedBeanClass);
        Class<T> type = ManagedBeanProxyHandler.castClass(proxyFactory.createClass(), managedBeanClass);
        T proxy = type.newInstance();
        ((ProxyObject)proxy).setHandler(handler);
        return proxy;
    }

    private static <T> Class<? extends T> castClass(Class<?> rawClass, Class<T> expectedParent) {
        assert (expectedParent.isAssignableFrom(rawClass));
        return rawClass;
    }

    private ManagedBeanProxyHandler(T managedBeanInstance, List<ManagedBeanInterceptor.AroundInvokeInterceptor<?>> interceptors, ClassLoader deploymentClassLoader) {
        this.instance = managedBeanInstance;
        this.interceptors = interceptors;
        this.deploymentClassLoader = deploymentClassLoader;
    }

    protected Object invokeMethod(T instance, Method method, Object[] arguments) {
        ClassLoader contextCl = SecurityActions.getContextClassLoader();
        SecurityActions.setContextClassLoader(this.deploymentClassLoader);
        try {
            if (!method.isAnnotationPresent(ExcludeClassInterceptors.class)) {
                Object object = new InvocationContext<T>(instance, method, arguments, this.interceptors).proceed();
                return object;
            }
            Object object = method.invoke(instance, arguments);
            return object;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        finally {
            SecurityActions.setContextClassLoader(contextCl);
        }
    }

    public Object invoke(Object o, Method method, Method proceed, Object[] arguments) throws Throwable {
        return this.invokeMethod(this.instance, method, arguments);
    }
}

