/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.deployment.managedbean.container;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jboss.as.deployment.managedbean.container.ManagedBeanContainer;

public class ManagedBeanRegistry {
    private static final ConcurrentMap<String, ManagedBeanContainer<?>> registry = new ConcurrentHashMap();

    public static void register(String name, ManagedBeanContainer<?> managedBeanContainer) throws DuplicateMangedBeanException {
        if (registry.putIfAbsent(name, managedBeanContainer) != null) {
            throw new DuplicateMangedBeanException("ManagedBean bound to '%s' already exists in registry.", name);
        }
    }

    public static ManagedBeanContainer<?> get(String name) {
        return (ManagedBeanContainer)registry.get(name);
    }

    public static void unregister(String name, ManagedBeanContainer<?> managedBeanContainer) {
        registry.remove(name, managedBeanContainer);
    }

    public static class DuplicateMangedBeanException
    extends Exception {
        private static final long serialVersionUID = -2999486400675276839L;

        public DuplicateMangedBeanException(String messageFormat, Object ... params) {
            super(String.format(messageFormat, params));
        }
    }
}

