/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.deployment.managedbean.processors;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.naming.Context;
import javax.naming.LinkRef;
import org.jboss.as.deployment.DeploymentPhases;
import org.jboss.as.deployment.managedbean.config.InterceptorConfiguration;
import org.jboss.as.deployment.managedbean.config.ManagedBeanConfiguration;
import org.jboss.as.deployment.managedbean.config.ManagedBeanConfigurations;
import org.jboss.as.deployment.managedbean.config.ResourceConfiguration;
import org.jboss.as.deployment.managedbean.container.FieldResourceInjection;
import org.jboss.as.deployment.managedbean.container.ManagedBeanContainer;
import org.jboss.as.deployment.managedbean.container.ManagedBeanInterceptor;
import org.jboss.as.deployment.managedbean.container.ManagedBeanObjectFactory;
import org.jboss.as.deployment.managedbean.container.ManagedBeanService;
import org.jboss.as.deployment.managedbean.container.MethodResourceInjection;
import org.jboss.as.deployment.managedbean.container.ResourceInjection;
import org.jboss.as.deployment.module.ModuleDeploymentProcessor;
import org.jboss.as.deployment.naming.ContextService;
import org.jboss.as.deployment.naming.DuplicateBindingException;
import org.jboss.as.deployment.naming.JndiName;
import org.jboss.as.deployment.naming.ModuleContextConfig;
import org.jboss.as.deployment.naming.NamespaceBindings;
import org.jboss.as.deployment.naming.NamingLookupValue;
import org.jboss.as.deployment.naming.ResourceBinder;
import org.jboss.as.deployment.unit.DeploymentUnitContext;
import org.jboss.as.deployment.unit.DeploymentUnitProcessingException;
import org.jboss.as.deployment.unit.DeploymentUnitProcessor;
import org.jboss.as.naming.context.ModularReference;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.msc.service.BatchBuilder;
import org.jboss.msc.service.BatchServiceBuilder;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.value.Value;
import org.jboss.msc.value.Values;

public class ManagedBeanDeploymentProcessor
implements DeploymentUnitProcessor {
    public static final long PRIORITY = DeploymentPhases.INSTALL_SERVICES.plus(200L);

    public void processDeployment(DeploymentUnitContext context) throws DeploymentUnitProcessingException {
        ManagedBeanConfigurations managedBeanConfigurations = (ManagedBeanConfigurations)context.getAttachment(ManagedBeanConfigurations.ATTACHMENT_KEY);
        if (managedBeanConfigurations == null) {
            return;
        }
        ModuleContextConfig moduleContext = (ModuleContextConfig)context.getAttachment(ModuleContextConfig.ATTACHMENT_KEY);
        if (moduleContext == null) {
            throw new DeploymentUnitProcessingException("Unable to deploy managed beans without a module naming context");
        }
        BatchBuilder batchBuilder = context.getBatchBuilder();
        Module module = (Module)context.getAttachment(ModuleDeploymentProcessor.MODULE_ATTACHMENT_KEY);
        ModuleClassLoader classLoader = module.getClassLoader();
        for (ManagedBeanConfiguration managedBeanConfiguration : managedBeanConfigurations.getConfigurations().values()) {
            this.processManagedBean(context, (ClassLoader)classLoader, moduleContext, managedBeanConfiguration, batchBuilder);
        }
    }

    private void processManagedBean(DeploymentUnitContext deploymentContext, ClassLoader classLoader, ModuleContextConfig moduleContext, ManagedBeanConfiguration managedBeanConfiguration, BatchBuilder batchBuilder) throws DeploymentUnitProcessingException {
        Class<?> beanClass = managedBeanConfiguration.getType();
        String managedBeanName = managedBeanConfiguration.getName();
        ArrayList resourceInjections = new ArrayList();
        ArrayList interceptors = new ArrayList();
        ManagedBeanService<?> managedBeanService = this.createManagedBeanService(beanClass, classLoader, managedBeanConfiguration, resourceInjections, interceptors);
        ServiceName moduleContextServiceName = moduleContext.getContextServiceName();
        ServiceName managedBeanServiceName = ManagedBeanService.SERVICE_NAME.append(new String[]{deploymentContext.getName(), managedBeanName});
        BatchServiceBuilder serviceBuilder = batchBuilder.addService(managedBeanServiceName, managedBeanService);
        ServiceName managedBeanContextServiceName = moduleContextServiceName.append(new String[]{managedBeanName, "context"});
        JndiName managedBeanContextJndiName = moduleContext.getContextName().append(managedBeanName + "-context");
        for (ResourceConfiguration resourceConfiguration : managedBeanConfiguration.getResourceConfigurations()) {
            ResourceInjection<?> resourceInjection = this.processResource(deploymentContext, moduleContext, resourceConfiguration.getInjectedType(), resourceConfiguration, batchBuilder, serviceBuilder, managedBeanContextServiceName, managedBeanContextJndiName);
            if (resourceInjection == null) continue;
            resourceInjections.add(resourceInjection);
        }
        for (InterceptorConfiguration interceptorConfiguration : managedBeanConfiguration.getInterceptorConfigurations()) {
            interceptors.add(this.processInterceptor(interceptorConfiguration.getInterceptorClass(), deploymentContext, moduleContext, interceptorConfiguration, batchBuilder, serviceBuilder, managedBeanContextServiceName, managedBeanContextJndiName));
        }
        ContextService actualBeanContext = new ContextService(managedBeanContextJndiName);
        batchBuilder.addService(managedBeanContextServiceName, (Service)actualBeanContext).addDependency(moduleContextServiceName, Context.class, actualBeanContext.getParentContextInjector());
        ModularReference managedBeanFactoryReference = ManagedBeanObjectFactory.createReference(beanClass, managedBeanServiceName.toString());
        ResourceBinder managedBeanFactoryBinder = new ResourceBinder(moduleContext.getContextName().append(managedBeanName), Values.immediateValue((Object)managedBeanFactoryReference));
        ServiceName referenceBinderName = moduleContextServiceName.append(new String[]{managedBeanName});
        batchBuilder.addService(referenceBinderName, (Service)managedBeanFactoryBinder).addDependency(moduleContextServiceName, Context.class, managedBeanFactoryBinder.getContextInjector()).addDependency(managedBeanServiceName);
    }

    private <T> ManagedBeanService<T> createManagedBeanService(Class<T> beanClass, ClassLoader classLoader, ManagedBeanConfiguration managedBeanConfiguration, List<ResourceInjection<?>> resourceInjections, List<ManagedBeanInterceptor<?>> interceptors) {
        return new ManagedBeanService<T>(new ManagedBeanContainer<T>(beanClass, classLoader, managedBeanConfiguration.getPostConstructMethods(), managedBeanConfiguration.getPreDestroyMethods(), resourceInjections, interceptors));
    }

    private <T> ResourceInjection<T> processResource(DeploymentUnitContext deploymentContext, ModuleContextConfig moduleContext, Class<T> valueType, ResourceConfiguration resourceConfiguration, BatchBuilder batchBuilder, BatchServiceBuilder<?> serviceBuilder, ServiceName beanContextServiceName, JndiName managedBeanContextJndiName) throws DeploymentUnitProcessingException {
        boolean shouldBind;
        JndiName localContextName = managedBeanContextJndiName.append(resourceConfiguration.getLocalContextName());
        String targetContextName = resourceConfiguration.getTargetContextName();
        NamingLookupValue lookupValue = new NamingLookupValue(localContextName);
        ResourceInjection<T> resourceInjection = this.getResourceInjection(resourceConfiguration, (Value<T>)lookupValue);
        ServiceName binderName = beanContextServiceName.append(new String[]{localContextName.getLocalName()});
        if (resourceInjection != null) {
            serviceBuilder.addDependency(binderName);
            serviceBuilder.addDependency(beanContextServiceName, Context.class, lookupValue.getContextInjector());
        }
        LinkRef linkRef = new LinkRef(targetContextName.startsWith("java") ? targetContextName : moduleContext.getContextName().append(targetContextName).getAbsoluteName());
        try {
            shouldBind = NamespaceBindings.getNamespaceBindings((DeploymentUnitContext)deploymentContext).addBinding(localContextName, (Object)linkRef);
        }
        catch (DuplicateBindingException e) {
            throw new DeploymentUnitProcessingException("Unable to process managed bean resource.", (Throwable)e);
        }
        if (shouldBind) {
            ResourceBinder resourceBinder = new ResourceBinder(localContextName, Values.immediateValue((Object)linkRef));
            BatchServiceBuilder binderServiceBuilder = batchBuilder.addService(binderName, (Service)resourceBinder);
            binderServiceBuilder.addDependency(beanContextServiceName, Context.class, resourceBinder.getContextInjector());
            if (targetContextName.startsWith("java:")) {
                binderServiceBuilder.addOptionalDependency(ResourceBinder.JAVA_BINDER.append(new String[]{targetContextName}));
            } else {
                binderServiceBuilder.addOptionalDependency(moduleContext.getContextServiceName().append(new String[]{targetContextName}));
            }
        }
        return resourceInjection;
    }

    private <T> ResourceInjection<T> getResourceInjection(ResourceConfiguration resourceConfiguration, Value<T> value) {
        switch (resourceConfiguration.getTargetType()) {
            case FIELD: {
                return new FieldResourceInjection<T>((Value<Field>)Values.immediateValue(Field.class.cast(resourceConfiguration.getTarget())), value, resourceConfiguration.getInjectedType().isPrimitive());
            }
            case METHOD: {
                return new MethodResourceInjection<T>((Value<Method>)Values.immediateValue(Method.class.cast(resourceConfiguration.getTarget())), value, resourceConfiguration.getInjectedType().isPrimitive());
            }
        }
        return null;
    }

    private <T> ManagedBeanInterceptor<T> processInterceptor(Class<T> interceptorType, DeploymentUnitContext deploymentContext, ModuleContextConfig moduleContext, InterceptorConfiguration interceptorConfiguration, BatchBuilder batchBuilder, BatchServiceBuilder<?> serviceBuilder, ServiceName managedBeanContextName, JndiName managedBeanContextJndiName) throws DeploymentUnitProcessingException {
        ArrayList resourceInjections = new ArrayList();
        for (ResourceConfiguration resourceConfiguration : interceptorConfiguration.getResourceConfigurations()) {
            ResourceInjection<?> resourceInjection = this.processResource(deploymentContext, moduleContext, resourceConfiguration.getInjectedType(), resourceConfiguration, batchBuilder, serviceBuilder, managedBeanContextName, managedBeanContextJndiName);
            if (resourceInjection == null) continue;
            resourceInjections.add(resourceInjection);
        }
        return new ManagedBeanInterceptor<T>(interceptorType, interceptorConfiguration.getAroundInvokeMethod(), resourceInjections);
    }
}

