/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.mc;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public final class McLifecycleService<T>
implements Service<T> {
    private final InjectedValue<T> value = new InjectedValue();
    private final Method startMethod;
    private final Method stopMethod;

    public McLifecycleService(Method startMethod, Method stopMethod) {
        this.startMethod = startMethod;
        this.stopMethod = stopMethod;
    }

    public void start(StartContext context) throws StartException {
        Method method = this.startMethod;
        if (method != null) {
            try {
                method.invoke(this.value.getValue(), new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new StartException("Failed to access method " + method.getName(), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new StartException("Failed to invoke method " + method.getName(), e.getCause());
            }
        }
    }

    public void stop(StopContext context) {
        Method method = this.stopMethod;
        if (method != null) {
            try {
                method.invoke(this.value.getValue(), new Object[0]);
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    public T getValue() throws IllegalStateException, IllegalArgumentException {
        return (T)this.value.getValue();
    }

    public Injector<T> getValueInjector() {
        return this.value;
    }
}

