/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.mc;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jboss.as.mc.BeanState;
import org.jboss.as.mc.McLifecycleService;
import org.jboss.as.mc.descriptor.BeanMetaDataConfig;
import org.jboss.as.mc.descriptor.KernelDeploymentXmlDescriptor;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndex;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.modules.Module;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.ConstructedValue;
import org.jboss.msc.value.Value;

public class ParsedKernelDeploymentProcessor
implements DeploymentUnitProcessor {
    public static final ServiceName JBOSS_MC_POJO = ServiceName.JBOSS.append(new String[]{"mc", "pojo"});

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        KernelDeploymentXmlDescriptor kdXmlDescriptor = (KernelDeploymentXmlDescriptor)phaseContext.getDeploymentUnit().getAttachment(KernelDeploymentXmlDescriptor.ATTACHMENT_KEY);
        if (kdXmlDescriptor == null) {
            return;
        }
        Module module = (Module)phaseContext.getDeploymentUnit().getAttachment(Attachments.MODULE);
        if (module == null) {
            throw new DeploymentUnitProcessingException("Failed to get module attachment for " + phaseContext.getDeploymentUnit());
        }
        DeploymentReflectionIndex index = (DeploymentReflectionIndex)phaseContext.getAttachment(Attachments.REFLECTION_INDEX);
        List<BeanMetaDataConfig> beanConfigs = kdXmlDescriptor.getBeans();
        ServiceTarget serviceTarget = phaseContext.getServiceTarget();
        for (BeanMetaDataConfig beanConfig : beanConfigs) {
            String className = beanConfig.getBeanClass();
            try {
                this.addBean(serviceTarget, beanConfig, Class.forName(className, false, (ClassLoader)module.getClassLoader()), index);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentUnitProcessingException("Bean class " + className + " not found", (Throwable)e);
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    private <T> void addBean(ServiceTarget serviceTarget, BeanMetaDataConfig beanConfig, Class<T> clazz, DeploymentReflectionIndex deploymentIndex) throws ClassNotFoundException {
        ClassReflectionIndex index = deploymentIndex.getClassIndex(clazz);
        Constructor constructor = index.getConstructor(new Class[0]);
        List args = Collections.emptyList();
        ServiceName beanServiceName = JBOSS_MC_POJO.append(new String[]{beanConfig.getName()});
        ServiceName instantiatedServiceName = beanServiceName.append(new String[]{BeanState.INSTANTIATED.name()});
        ValueService instantiatedService = new ValueService((Value)new ConstructedValue(constructor, args));
        ServiceBuilder instantiatedServiceBuilder = serviceTarget.addService(instantiatedServiceName, (Service)instantiatedService);
        instantiatedServiceBuilder.install();
        ServiceName configuredServiceName = beanServiceName.append(new String[]{BeanState.CONFIGURED.name()});
        ServiceBuilder configuredServiceBuilder = serviceTarget.addService(configuredServiceName, (Service)new ValueService((Value)instantiatedService));
        configuredServiceBuilder.addDependency(instantiatedServiceName).install();
        String createName = "create";
        String destroyName = "destroy";
        Method create = ParsedKernelDeploymentProcessor.getInstanceMethod(index, "create", new Class[0]);
        Method destroy = ParsedKernelDeploymentProcessor.getInstanceMethod(index, "destroy", new Class[0]);
        McLifecycleService createService = new McLifecycleService(create, destroy);
        ServiceName createServiceName = beanServiceName.append(new String[]{BeanState.CREATE.name()});
        ServiceBuilder createServiceBuilder = serviceTarget.addService(createServiceName, createService);
        createServiceBuilder.addDependency(configuredServiceName, clazz, createService.getValueInjector()).install();
        String startName = "start";
        String stopName = "stop";
        Method start = ParsedKernelDeploymentProcessor.getInstanceMethod(index, "start", new Class[0]);
        Method stop = ParsedKernelDeploymentProcessor.getInstanceMethod(index, "stop", new Class[0]);
        McLifecycleService startService = new McLifecycleService(start, stop);
        ServiceName startServiceName = beanServiceName.append(new String[]{BeanState.START.name()});
        ServiceBuilder startServiceBuilder = serviceTarget.addService(startServiceName, startService);
        startServiceBuilder.addDependency(createServiceName, clazz, startService.getValueInjector()).install();
        ServiceName installedServiceName = beanServiceName.append(new String[]{BeanState.INSTALLED.name()});
        ServiceBuilder installedServiceBuilder = serviceTarget.addService(installedServiceName, (Service)new ValueService(startService));
        installedServiceBuilder.addDependency(startServiceName).install();
    }

    private static Method getInstanceMethod(ClassReflectionIndex<?> index, String name, Class<?> ... params) {
        Collection methods = index.getMethods(name, (Class[])params);
        for (Method method : methods) {
            if (Modifier.isStatic(method.getModifiers())) continue;
            return method;
        }
        return null;
    }
}

