/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.mc.descriptor;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.mc.ParseResult;
import org.jboss.as.mc.descriptor.BeanMetaDataConfig;
import org.jboss.as.mc.descriptor.KernelDeploymentXmlDescriptor;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class KernelDeploymentXmlDescriptorParser
implements XMLElementReader<ParseResult<KernelDeploymentXmlDescriptor>>,
XMLStreamConstants {
    public static final String NAMESPACE = "urn:jboss:mc:7.0";

    public void readElement(XMLExtendedStreamReader reader, ParseResult<KernelDeploymentXmlDescriptor> value) throws XMLStreamException {
        KernelDeploymentXmlDescriptor kernelDeploymentXmlDescriptor = new KernelDeploymentXmlDescriptor();
        ArrayList<BeanMetaDataConfig> beansConfigs = new ArrayList<BeanMetaDataConfig>();
        kernelDeploymentXmlDescriptor.setBeans(beansConfigs);
        value.setResult(kernelDeploymentXmlDescriptor);
        int count = reader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            QName attributeName = reader.getAttributeName(i);
            Attribute attribute = Attribute.of(attributeName);
            String attributeValue = reader.getAttributeValue(i);
            switch (attribute) {
                case MODE: {
                    kernelDeploymentXmlDescriptor.setControllerMode(KernelDeploymentXmlDescriptor.ControllerMode.of(attributeValue));
                }
            }
        }
        while (reader.hasNext()) {
            block3 : switch (reader.nextTag()) {
                case 5: {
                    break;
                }
                case 2: {
                    return;
                }
                case 1: {
                    switch (Element.of(reader.getName())) {
                        case BEAN: {
                            beansConfigs.add(this.parseBean(reader));
                            break block3;
                        }
                        case UNKNOWN: {
                            throw KernelDeploymentXmlDescriptorParser.unexpectedContent((XMLStreamReader)reader);
                        }
                    }
                }
            }
        }
    }

    private BeanMetaDataConfig parseBean(XMLExtendedStreamReader reader) throws XMLStreamException {
        BeanMetaDataConfig beanConfig = new BeanMetaDataConfig();
        int count = reader.getAttributeCount();
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.CLASS);
        block4: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            String attributeValue = reader.getAttributeValue(i);
            switch (attribute) {
                case NAME: {
                    beanConfig.setName(attributeValue);
                    continue block4;
                }
                case CLASS: {
                    beanConfig.setBeanClass(attributeValue);
                    continue block4;
                }
                default: {
                    throw KernelDeploymentXmlDescriptorParser.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw KernelDeploymentXmlDescriptorParser.missingAttributes(reader.getLocation(), required);
        }
        return beanConfig;
    }

    private static XMLStreamException unexpectedContent(XMLStreamReader reader) {
        String kind;
        switch (reader.getEventType()) {
            case 10: {
                kind = "attribute";
                break;
            }
            case 12: {
                kind = "cdata";
                break;
            }
            case 4: {
                kind = "characters";
                break;
            }
            case 5: {
                kind = "comment";
                break;
            }
            case 11: {
                kind = "dtd";
                break;
            }
            case 8: {
                kind = "document end";
                break;
            }
            case 2: {
                kind = "element end";
                break;
            }
            case 15: {
                kind = "entity decl";
                break;
            }
            case 9: {
                kind = "entity ref";
                break;
            }
            case 13: {
                kind = "namespace";
                break;
            }
            case 14: {
                kind = "notation decl";
                break;
            }
            case 3: {
                kind = "processing instruction";
                break;
            }
            case 6: {
                kind = "whitespace";
                break;
            }
            case 7: {
                kind = "document start";
                break;
            }
            case 1: {
                kind = "element start";
                break;
            }
            default: {
                kind = "unknown";
            }
        }
        StringBuilder b = new StringBuilder("Unexpected content of type '").append(kind).append('\'');
        if (reader.hasName()) {
            b.append(" named '").append(reader.getName()).append('\'');
        }
        if (reader.hasText()) {
            b.append(", text is: '").append(reader.getText()).append('\'');
        }
        return new XMLStreamException(b.toString(), reader.getLocation());
    }

    private static XMLStreamException missingAttributes(Location location, Set<Attribute> required) {
        StringBuilder b = new StringBuilder("Missing one or more required attributes:");
        for (Attribute attribute : required) {
            b.append(' ').append((Object)attribute);
        }
        return new XMLStreamException(b.toString(), location);
    }

    private static enum Attribute {
        MODE(new QName("mode")),
        NAME(new QName("name")),
        TYPE(new QName("type")),
        VALUE(new QName("value")),
        TRIM(new QName("trim")),
        REPLACE(new QName("replace")),
        BEAN(new QName("bean")),
        PROPERTY(new QName("property")),
        CLASS(new QName("class")),
        METHOD(new QName("method")),
        UNKNOWN(null);

        private final QName qName;
        private static final Map<QName, Attribute> QNAME_MAP;

        private Attribute(QName qName) {
            this.qName = qName;
        }

        static Attribute of(QName qName) {
            Attribute attribute = QNAME_MAP.get(qName);
            return attribute == null ? UNKNOWN : attribute;
        }

        static {
            QNAME_MAP = new HashMap<QName, Attribute>();
            for (Attribute attribute : Attribute.values()) {
                QNAME_MAP.put(attribute.qName, attribute);
            }
        }
    }

    private static enum Element {
        BEAN(new QName("urn:jboss:mc:7.0", "bean")),
        CONSTRUCTOR(new QName("urn:jboss:mc:7.0", "constructor")),
        PROPERTY(new QName("urn:jboss:mc:7.0", "property")),
        INJECT(new QName("urn:jboss:mc:7.0", "inject")),
        VALUE_FACTORY(new QName("urn:jboss:mc:7.0", "value-factory")),
        PARAMETER(new QName("urn:jboss:mc:7.0", "parameter")),
        DEPENDS(new QName("urn:jboss:mc:7.0", "depends")),
        ALIAS(new QName("urn:jboss:mc:7.0", "alias")),
        ANNOTATION(new QName("urn:jboss:mc:7.0", "annotation")),
        UNKNOWN(null);

        private final QName qName;
        private static final Map<QName, Element> QNAME_MAP;

        private Element(QName qName) {
            this.qName = qName;
        }

        static Element of(QName qName) {
            Element element = QNAME_MAP.get(qName);
            return element == null ? UNKNOWN : element;
        }

        static {
            QNAME_MAP = new HashMap<QName, Element>();
            for (Element element : Element.values()) {
                QNAME_MAP.put(element.qName, element);
            }
        }
    }
}

