/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.hornetq.api.core.TransportConfiguration;
import org.jboss.as.messaging.AbstractTransportElement;
import org.jboss.as.messaging.Attribute;
import org.jboss.as.messaging.Element;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class InVMConnectorSpec
extends AbstractTransportElement<InVMConnectorSpec> {
    private static final long serialVersionUID = 945704013276115231L;
    private static final String FACTORY_CLASS = "org.hornetq.core.remoting.impl.invm.InVMConnectorFactory";
    private int serverId;

    protected InVMConnectorSpec(String name) {
        super(Element.IN_VM_CONNECTOR, name);
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
    }

    @Override
    public String getFactoryClassName() {
        return FACTORY_CLASS;
    }

    public int getServerId() {
        return this.serverId;
    }

    public void setServerId(int serverId) {
        this.serverId = serverId;
    }

    @Override
    protected void processHQConfig(TransportConfiguration transport) {
        super.processHQConfig(transport);
        Map map = transport.getParams();
        if (map != null) {
            map.put("server-id", "" + this.serverId);
        }
    }

    protected Class<InVMConnectorSpec> getElementClass() {
        return InVMConnectorSpec.class;
    }

    @Override
    public void writeContent(XMLExtendedStreamWriter streamWriter) throws XMLStreamException {
        if (this.getName() != null) {
            streamWriter.writeAttribute(Attribute.NAME.getLocalName(), this.getName());
        }
        streamWriter.writeAttribute(Attribute.SERVER_ID.getLocalName(), "" + this.serverId);
        Map<String, Object> params = this.getParams();
        if (params != null && !params.isEmpty()) {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                streamWriter.writeEmptyElement(Element.PARAM.getLocalName());
                streamWriter.writeAttribute(Attribute.KEY.getLocalName(), entry.getKey());
                streamWriter.writeAttribute(Attribute.VALUE.getLocalName(), entry.getValue().toString());
            }
        }
        streamWriter.writeEndElement();
    }
}

