/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.config.impl.Validators;
import org.hornetq.core.security.Role;
import org.hornetq.core.server.JournalType;
import org.hornetq.core.settings.impl.AddressFullMessagePolicy;
import org.jboss.as.ExtensionContext;
import org.jboss.as.messaging.AbstractTransportElement;
import org.jboss.as.messaging.AddressSettingsElement;
import org.jboss.as.messaging.Attribute;
import org.jboss.as.messaging.DirectoryElement;
import org.jboss.as.messaging.Element;
import org.jboss.as.messaging.ElementUtils;
import org.jboss.as.messaging.GenericAcceptorSpec;
import org.jboss.as.messaging.GenericConnectorSpec;
import org.jboss.as.messaging.InVMAcceptorSpec;
import org.jboss.as.messaging.InVMConnectorSpec;
import org.jboss.as.messaging.MessagingSubsystemAdd;
import org.jboss.as.messaging.MessagingSubsystemElement;
import org.jboss.as.messaging.NettyAcceptorSpec;
import org.jboss.as.messaging.NettyConnectorSpec;
import org.jboss.as.messaging.QueueElement;
import org.jboss.as.messaging.SecuritySettingsElement;
import org.jboss.as.model.AbstractSubsystemAdd;
import org.jboss.as.model.ParseResult;
import org.jboss.as.model.ParseUtils;
import org.jboss.logging.Logger;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class MessagingSubsystemParser
implements XMLStreamConstants,
XMLElementReader<ParseResult<ExtensionContext.SubsystemConfiguration<MessagingSubsystemElement>>> {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.messaging");
    private static final MessagingSubsystemParser INSTANCE = new MessagingSubsystemParser();

    public static MessagingSubsystemParser getInstance() {
        return INSTANCE;
    }

    private MessagingSubsystemParser() {
    }

    public void readElement(XMLExtendedStreamReader reader, ParseResult<ExtensionContext.SubsystemConfiguration<MessagingSubsystemElement>> result) throws XMLStreamException {
        ArrayList updates = new ArrayList();
        MessagingSubsystemAdd messagingSubsystemAdd = new MessagingSubsystemAdd();
        int tag = reader.getEventType();
        String localName = null;
        block77: do {
            tag = reader.nextTag();
            localName = reader.getLocalName();
            Element element = Element.forName(reader.getLocalName());
            log.tracef("%s -> %s, event=%s", (Object)localName, (Object)element, (Object)ElementUtils.StaxEvent.tagToEvent(tag));
            switch (element) {
                case ACCEPTORS: {
                    this.processAcceptors(reader, messagingSubsystemAdd);
                    break;
                }
                case ADDRESS_SETTINGS: {
                    this.processAddressSettings(reader, messagingSubsystemAdd);
                    break;
                }
                case ASYNC_CONNECTION_EXECUTION_ENABLED: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case BACKUP: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case BACKUP_CONNECTOR_REF: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case BINDINGS_DIRECTORY: {
                    DirectoryElement dir = MessagingSubsystemParser.parseDirectory(reader);
                    messagingSubsystemAdd.setBindingsDirectory(dir);
                    break;
                }
                case BROADCAST_PERIOD: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case CLUSTERED: {
                    String text = reader.getElementText();
                    if (text == null || text.length() <= 0) continue block77;
                    messagingSubsystemAdd.setClustered(Boolean.getBoolean(text.trim()));
                    break;
                }
                case CLUSTER_PASSWORD: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case CLUSTER_USER: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case CONNECTION_TTL_OVERRIDE: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case CONNECTORS: {
                    this.processConnectors(reader, messagingSubsystemAdd);
                    break;
                }
                case CONNECTOR_REF: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case CREATE_BINDINGS_DIR: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case CREATE_JOURNAL_DIR: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case FILE_DEPLOYMENT_ENABLED: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case GROUP_ADDRESS: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case GROUP_PORT: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case GROUPING_HANDLER: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case ID_CACHE_SIZE: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case JMX_DOMAIN: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case JMX_MANAGEMENT_ENABLED: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case JOURNAL_BUFFER_SIZE: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case JOURNAL_BUFFER_TIMEOUT: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case JOURNAL_COMPACT_MIN_FILES: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case JOURNAL_COMPACT_PERCENTAGE: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case JOURNAL_DIRECTORY: {
                    DirectoryElement dir = MessagingSubsystemParser.parseDirectory(reader);
                    messagingSubsystemAdd.setJournalDirectory(dir);
                    break;
                }
                case JOURNAL_MIN_FILES: {
                    String text = reader.getElementText();
                    if (text == null || text.length() <= 0) continue block77;
                    messagingSubsystemAdd.setJournalMinFiles(Integer.valueOf(text.trim()));
                    break;
                }
                case JOURNAL_SYNC_NON_TRANSACTIONAL: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case JOURNAL_SYNC_TRANSACTIONAL: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case JOURNAL_TYPE: {
                    String text = reader.getElementText();
                    if (text == null || text.length() <= 0) continue block77;
                    JournalType jtype = JournalType.valueOf((String)text.trim());
                    messagingSubsystemAdd.setJournalType(jtype);
                    break;
                }
                case JOURNAL_FILE_SIZE: {
                    String text = reader.getElementText();
                    if (text == null || text.length() <= 0) continue block77;
                    int size = Integer.valueOf(text.trim());
                    messagingSubsystemAdd.setJournalFileSize(size);
                    break;
                }
                case JOURNAL_MAX_IO: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case LARGE_MESSAGES_DIRECTORY: {
                    DirectoryElement dir = MessagingSubsystemParser.parseDirectory(reader);
                    messagingSubsystemAdd.setLargeMessagesDirectory(dir);
                    break;
                }
                case LOCAL_BIND_ADDRESS: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case LOCAL_BIND_PORT: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case LOG_JOURNAL_WRITE_RATE: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case MANAGEMENT_ADDRESS: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case MANAGEMENT_NOTIFICATION_ADDRESS: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case MEMORY_MEASURE_INTERVAL: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case MEMORY_WARNING_THRESHOLD: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case MESSAGE_COUNTER_ENABLED: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case MESSAGE_COUNTER_MAX_DAY_HISTORY: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case MESSAGE_COUNTER_SAMPLE_PERIOD: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case MESSAGE_EXPIRY_SCAN_PERIOD: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case MESSAGE_EXPIRY_THREAD_PRIORITY: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case PAGING_DIRECTORY: {
                    DirectoryElement dir = MessagingSubsystemParser.parseDirectory(reader);
                    messagingSubsystemAdd.setPagingDirectory(dir);
                    break;
                }
                case PERF_BLAST_PAGES: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case PERSIST_DELIVERY_COUNT_BEFORE_DELIVERY: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case PERSIST_ID_CACHE: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case PERSISTENCE_ENABLED: {
                    String value = reader.getElementText();
                    if (value == null || value.length() <= 0) continue block77;
                    boolean enabled = Boolean.valueOf(value.trim());
                    messagingSubsystemAdd.setPersistenceEnabled(enabled);
                    break;
                }
                case REFRESH_TIMEOUT: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case REMOTING_INTERCEPTORS: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case RUN_SYNC_SPEED_TEST: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case SECURITY_ENABLED: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case SECURITY_INVALIDATION_INTERVAL: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case SECURITY_SETTINGS: {
                    this.processSecuritySettings(reader, messagingSubsystemAdd);
                    break;
                }
                case SERVER_DUMP_INTERVAL: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case SHARED_STORE: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case TRANSACTION_TIMEOUT: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case TRANSACTION_TIMEOUT_SCAN_PERIOD: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case WILD_CARD_ROUTING_ENABLED: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case DEAD_LETTER_ADDRESS_NODE_NAME: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case EXPIRY_ADDRESS_NODE_NAME: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case REDELIVERY_DELAY_NODE_NAME: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case MAX_DELIVERY_ATTEMPTS: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case MAX_SIZE_BYTES_NODE_NAME: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case ADDRESS_FULL_MESSAGE_POLICY_NODE_NAME: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case PAGE_SIZE_BYTES_NODE_NAME: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case MESSAGE_COUNTER_HISTORY_DAY_LIMIT_NODE_NAME: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case LVQ_NODE_NAME: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case REDISTRIBUTION_DELAY_NODE_NAME: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case SEND_TO_DLA_ON_NO_ROUTE: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case QUEUES: {
                    MessagingSubsystemParser.parseQueues(reader, messagingSubsystemAdd);
                    break;
                }
                case SUBSYSTEM: {
                    break;
                }
                default: {
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
        } while (reader.hasNext() && !localName.equals("subsystem"));
        result.setResult((Object)new ExtensionContext.SubsystemConfiguration((AbstractSubsystemAdd)messagingSubsystemAdd, updates));
        log.tracef("End %s:%s", (Object)reader.getLocation(), (Object)reader.getLocalName());
    }

    void processAcceptors(XMLExtendedStreamReader reader, MessagingSubsystemAdd messagingSubsystemAdd) throws XMLStreamException {
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            String name = null;
            String socketBinding = null;
            int serverId = 0;
            int count = reader.getAttributeCount();
            block11: for (int i = 0; i < count; ++i) {
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case NAME: {
                        name = attrValue;
                        continue block11;
                    }
                    case SOCKET_BINDING: {
                        socketBinding = attrValue;
                        continue block11;
                    }
                    case SERVER_ID: {
                        serverId = Integer.valueOf(attrValue);
                        continue block11;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ACCEPTOR: {
                    AbstractTransportElement acceptor = new GenericAcceptorSpec(name);
                    acceptor.setSocketBindingRef(socketBinding);
                    MessagingSubsystemParser.parseTransportConfigurationParams(reader, acceptor, true);
                    messagingSubsystemAdd.addAcceptor(acceptor);
                    continue block10;
                }
                case NETTY_ACCEPTOR: {
                    AbstractTransportElement acceptor = new NettyAcceptorSpec(name);
                    acceptor.setSocketBindingRef(socketBinding);
                    MessagingSubsystemParser.parseTransportConfigurationParams(reader, acceptor, false);
                    messagingSubsystemAdd.addAcceptor(acceptor);
                    continue block10;
                }
                case IN_VM_ACCEPTOR: {
                    AbstractTransportElement acceptor = new InVMAcceptorSpec(name);
                    ((InVMAcceptorSpec)acceptor).setServerId(serverId);
                    MessagingSubsystemParser.parseTransportConfigurationParams(reader, acceptor, false);
                    messagingSubsystemAdd.addAcceptor(acceptor);
                    continue block10;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    static void parseQueues(XMLExtendedStreamReader reader, MessagingSubsystemAdd add) throws XMLStreamException {
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            String name = null;
            int count = reader.getAttributeCount();
            block7: for (int i = 0; i < count; ++i) {
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case NAME: {
                        name = attrValue;
                        continue block7;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case QUEUE: {
                    if (name == null) {
                        throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME.getLocalName()));
                    }
                    QueueElement queue = new QueueElement(name);
                    MessagingSubsystemParser.parseQueue(reader, queue);
                    if (queue.getAddress() == null) {
                        throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Element.ADDRESS.getLocalName()));
                    }
                    add.addQueue(queue);
                    continue block6;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    static void parseQueue(XMLExtendedStreamReader reader, QueueElement queue) throws XMLStreamException {
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ADDRESS: {
                    queue.setAddress(reader.getElementText().trim());
                    continue block5;
                }
                case FILTER: {
                    queue.setFilter(reader.getAttributeValue(0).trim());
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    continue block5;
                }
                case DURABLE: {
                    queue.setDurable(Boolean.valueOf(reader.getElementText()));
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    void processAddressSettings(XMLExtendedStreamReader reader, MessagingSubsystemAdd messagingSubsystemAdd) throws XMLStreamException {
        int tag = reader.getEventType();
        String localName = null;
        do {
            tag = reader.nextTag();
            localName = reader.getLocalName();
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ADDRESS_SETTING: {
                    String match = reader.getAttributeValue(0);
                    AddressSettingsElement addressSettingsSpec = MessagingSubsystemParser.parseAddressSettings(reader, match);
                    messagingSubsystemAdd.addAddressSettings(addressSettingsSpec);
                }
            }
        } while (reader.hasNext() && localName.equals(Element.ADDRESS_SETTING.getLocalName()));
    }

    static AddressSettingsElement parseAddressSettings(XMLExtendedStreamReader reader, String name) throws XMLStreamException {
        AddressSettingsElement addressSettingsSpec = new AddressSettingsElement(name);
        int tag = reader.getEventType();
        String localName = null;
        do {
            tag = reader.nextTag();
            localName = reader.getLocalName();
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case DEAD_LETTER_ADDRESS_NODE_NAME: {
                    SimpleString queueName = new SimpleString(reader.getElementText().trim());
                    addressSettingsSpec.setDeadLetterAddress(queueName);
                    break;
                }
                case EXPIRY_ADDRESS_NODE_NAME: {
                    SimpleString queueName = new SimpleString(reader.getElementText().trim());
                    addressSettingsSpec.setExpiryAddress(queueName);
                    break;
                }
                case REDELIVERY_DELAY_NODE_NAME: {
                    addressSettingsSpec.setRedeliveryDelay(Long.valueOf(reader.getElementText().trim()));
                    break;
                }
                case MAX_SIZE_BYTES_NODE_NAME: {
                    addressSettingsSpec.setMaxSizeBytes(Long.valueOf(reader.getElementText().trim()));
                    break;
                }
                case PAGE_SIZE_BYTES_NODE_NAME: {
                    addressSettingsSpec.setPageSizeBytes(Long.valueOf(reader.getElementText().trim()));
                    break;
                }
                case MESSAGE_COUNTER_HISTORY_DAY_LIMIT_NODE_NAME: {
                    addressSettingsSpec.setMessageCounterHistoryDayLimit(Integer.valueOf(reader.getElementText().trim()));
                    break;
                }
                case ADDRESS_FULL_MESSAGE_POLICY_NODE_NAME: {
                    String value = reader.getElementText().trim();
                    Validators.ADDRESS_FULL_MESSAGE_POLICY_TYPE.validate(Element.ADDRESS_FULL_MESSAGE_POLICY_NODE_NAME.getLocalName(), (Object)value);
                    AddressFullMessagePolicy policy = null;
                    if (value.equals(AddressFullMessagePolicy.BLOCK.toString())) {
                        policy = AddressFullMessagePolicy.BLOCK;
                    } else if (value.equals(AddressFullMessagePolicy.DROP.toString())) {
                        policy = AddressFullMessagePolicy.DROP;
                    } else if (value.equals(AddressFullMessagePolicy.PAGE.toString())) {
                        policy = AddressFullMessagePolicy.PAGE;
                    }
                    addressSettingsSpec.setAddressFullMessagePolicy(policy);
                    break;
                }
                case LVQ_NODE_NAME: {
                    addressSettingsSpec.setLastValueQueue(Boolean.valueOf(reader.getElementText().trim()));
                    break;
                }
                case MAX_DELIVERY_ATTEMPTS: {
                    addressSettingsSpec.setMaxDeliveryAttempts(Integer.valueOf(reader.getElementText().trim()));
                    break;
                }
                case REDISTRIBUTION_DELAY_NODE_NAME: {
                    addressSettingsSpec.setRedistributionDelay(Long.valueOf(reader.getElementText().trim()));
                    break;
                }
                case SEND_TO_DLA_ON_NO_ROUTE: {
                    addressSettingsSpec.setSendToDLAOnNoRoute(Boolean.valueOf(reader.getElementText().trim()));
                    break;
                }
            }
            reader.discardRemainder();
        } while (!reader.getLocalName().equals(Element.ADDRESS_SETTING.getLocalName()) && reader.getEventType() != 2);
        return addressSettingsSpec;
    }

    void processConnectors(XMLExtendedStreamReader reader, MessagingSubsystemAdd messagingSubsystemAdd) throws XMLStreamException {
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            String name = null;
            String socketBinding = null;
            int serverId = 0;
            int count = reader.getAttributeCount();
            block11: for (int i = 0; i < count; ++i) {
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case NAME: {
                        name = attrValue;
                        continue block11;
                    }
                    case SOCKET_BINDING: {
                        socketBinding = attrValue;
                        continue block11;
                    }
                    case SERVER_ID: {
                        serverId = Integer.valueOf(attrValue);
                        continue block11;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CONNECTOR: {
                    AbstractTransportElement connector = new GenericConnectorSpec(name);
                    connector.setSocketBindingRef(socketBinding);
                    MessagingSubsystemParser.parseTransportConfigurationParams(reader, connector, true);
                    messagingSubsystemAdd.addConnector(connector);
                    continue block10;
                }
                case NETTY_CONNECTOR: {
                    AbstractTransportElement connector = new NettyConnectorSpec(name);
                    connector.setSocketBindingRef(socketBinding);
                    MessagingSubsystemParser.parseTransportConfigurationParams(reader, connector, false);
                    messagingSubsystemAdd.addConnector(connector);
                    continue block10;
                }
                case IN_VM_CONNECTOR: {
                    AbstractTransportElement connector = new InVMConnectorSpec(name);
                    ((InVMConnectorSpec)connector).setServerId(serverId);
                    MessagingSubsystemParser.parseTransportConfigurationParams(reader, connector, false);
                    messagingSubsystemAdd.addConnector(connector);
                    continue block10;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    static void parseTransportConfigurationParams(XMLExtendedStreamReader reader, AbstractTransportElement<?> spec, boolean generic) throws XMLStreamException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            int count = reader.getAttributeCount();
            String key = null;
            String value = null;
            block9: for (int n = 0; n < count; ++n) {
                String attrName = reader.getAttributeLocalName(n);
                Attribute attribute = Attribute.forName(attrName);
                switch (attribute) {
                    case KEY: {
                        key = reader.getAttributeValue(n);
                        continue block9;
                    }
                    case VALUE: {
                        value = reader.getAttributeValue(n);
                        continue block9;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)n);
                    }
                }
            }
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case FACTORY_CLASS: {
                    if (!generic) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    spec.setFactoryClassName(reader.getElementText().trim());
                    continue block8;
                }
                case PARAM: {
                    params.put(key, value);
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        spec.setParams(params);
    }

    void processSecuritySettings(XMLExtendedStreamReader reader, MessagingSubsystemAdd messagingSubsystemAdd) throws XMLStreamException {
        int tag = reader.getEventType();
        String localName = null;
        do {
            tag = reader.nextTag();
            localName = reader.getLocalName();
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case SECURITY_SETTING: {
                    String match = reader.getAttributeValue(0);
                    SecuritySettingsElement securitySettingsSpec = MessagingSubsystemParser.parseSecurityRoles(reader, match);
                    messagingSubsystemAdd.addSecuritySettings(securitySettingsSpec);
                }
            }
        } while (reader.hasNext() && localName.equals(Element.SECURITY_SETTING.getLocalName()));
    }

    static void unhandledElement(XMLExtendedStreamReader reader, Element element) throws XMLStreamException {
        log.warnf("Ignorning unhandled element: %s, at: %s", (Object)element, (Object)reader.getLocation().toString());
        reader.discardRemainder();
    }

    static SecuritySettingsElement parseSecurityRoles(XMLExtendedStreamReader reader, String match) throws XMLStreamException {
        HashSet<Role> securityRoles = new HashSet<Role>();
        ArrayList<String> send = new ArrayList<String>();
        ArrayList<String> consume = new ArrayList<String>();
        ArrayList<String> createDurableQueue = new ArrayList<String>();
        ArrayList<String> deleteDurableQueue = new ArrayList<String>();
        ArrayList<String> createNonDurableQueue = new ArrayList<String>();
        ArrayList<String> deleteNonDurableQueue = new ArrayList<String>();
        ArrayList<String> manageRoles = new ArrayList<String>();
        ArrayList<String> allRoles = new ArrayList<String>();
        int tag = reader.getEventType();
        String localName = null;
        do {
            tag = reader.nextTag();
            localName = reader.getLocalName();
            if (!localName.equals(Element.PERMISSION_ELEMENT_NAME.getLocalName())) break;
            Element element = Element.forName(reader.getLocalName());
            List roles = null;
            String type = null;
            int count = reader.getAttributeCount();
            block5: for (int i = 0; i < count; ++i) {
                if (reader.getAttributeNamespace(i) != null) {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case ROLES_ATTR_NAME: {
                        roles = reader.getListAttributeValue(i);
                        continue block5;
                    }
                    case TYPE_ATTR_NAME: {
                        type = reader.getAttributeValue(i);
                        continue block5;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            for (String role : roles) {
                if (Attribute.SEND_NAME.getLocalName().equals(type)) {
                    send.add(role.trim());
                } else if (Attribute.CONSUME_NAME.getLocalName().equals(type)) {
                    consume.add(role.trim());
                } else if (Attribute.CREATEDURABLEQUEUE_NAME.getLocalName().equals(type)) {
                    createDurableQueue.add(role);
                } else if (Attribute.DELETEDURABLEQUEUE_NAME.getLocalName().equals(type)) {
                    deleteDurableQueue.add(role);
                } else if (Attribute.CREATE_NON_DURABLE_QUEUE_NAME.getLocalName().equals(type)) {
                    createNonDurableQueue.add(role);
                } else if (Attribute.DELETE_NON_DURABLE_QUEUE_NAME.getLocalName().equals(type)) {
                    deleteNonDurableQueue.add(role);
                } else if (Attribute.CREATETEMPQUEUE_NAME.getLocalName().equals(type)) {
                    createNonDurableQueue.add(role);
                } else if (Attribute.DELETETEMPQUEUE_NAME.getLocalName().equals(type)) {
                    deleteNonDurableQueue.add(role);
                } else if (Attribute.MANAGE_NAME.getLocalName().equals(type)) {
                    manageRoles.add(role);
                }
                if (allRoles.contains(role.trim())) continue;
                allRoles.add(role.trim());
            }
            reader.discardRemainder();
        } while (reader.hasNext());
        for (String role : allRoles) {
            securityRoles.add(new Role(role, send.contains(role), consume.contains(role), createDurableQueue.contains(role), deleteDurableQueue.contains(role), createNonDurableQueue.contains(role), deleteNonDurableQueue.contains(role), manageRoles.contains(role)));
        }
        return new SecuritySettingsElement(match, securityRoles);
    }

    static DirectoryElement parseDirectory(XMLExtendedStreamReader reader) throws XMLStreamException {
        DirectoryElement element = new DirectoryElement();
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            if (reader.getAttributeNamespace(i) != null) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            String value = reader.getAttributeValue(i);
            switch (attribute) {
                case RELATIVE_TO: {
                    element.setRelativeTo(value.trim());
                    continue block4;
                }
                case PATH: {
                    element.setPath(value.trim());
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        return element;
    }
}

