/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import javax.xml.stream.XMLStreamException;
import org.jboss.as.messaging.Attribute;
import org.jboss.as.messaging.Element;
import org.jboss.as.messaging.ElementUtils;
import org.jboss.as.model.AbstractModelElement;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class QueueElement
extends AbstractModelElement<QueueElement> {
    private static final long serialVersionUID = 8380087798287223743L;
    private final String name;
    private String address;
    private String filter;
    private Boolean durable;

    public QueueElement(String name) {
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public Boolean isDurable() {
        return this.durable;
    }

    public void setDurable(Boolean durable) {
        this.durable = durable;
    }

    protected Class<QueueElement> getElementClass() {
        return QueueElement.class;
    }

    public void writeContent(XMLExtendedStreamWriter streamWriter) throws XMLStreamException {
        streamWriter.writeAttribute(Attribute.NAME.getLocalName(), this.name);
        ElementUtils.writeSimpleElement(Element.ADDRESS, this.address, streamWriter);
        if (this.filter != null) {
            streamWriter.writeEmptyElement(Element.FILTER.getLocalName());
            streamWriter.writeAttribute(Attribute.STRING.getLocalName(), this.filter);
        }
        if (this.durable != null) {
            ElementUtils.writeSimpleElement(Element.DURABLE, this.address, streamWriter);
        }
        streamWriter.writeEndElement();
    }
}

