/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import org.jboss.as.messaging.AbstractMessagingSubsystemUpdate;
import org.jboss.as.messaging.MessagingSubsystemElement;
import org.jboss.as.messaging.QueueAdd;
import org.jboss.as.messaging.QueueElement;
import org.jboss.as.model.AbstractSubsystemUpdate;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;

public class QueueRemove
extends AbstractMessagingSubsystemUpdate<Void> {
    private static final long serialVersionUID = 5921273777496713096L;
    private final String name;

    public QueueRemove(String name) {
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        this.name = name;
    }

    protected void applyUpdate(MessagingSubsystemElement element) throws UpdateFailedException {
        if (!element.removeQueue(this.name)) {
            throw new UpdateFailedException(String.format("queue (%s) does not exist", this.name));
        }
    }

    protected <P> void applyUpdate(UpdateContext context, UpdateResultHandler<? super Void, P> resultHandler, P param) {
        ServiceController service = context.getServiceContainer().getService(MessagingSubsystemElement.CORE_QUEUE_BASE.append(new String[]{this.name}));
        if (service == null) {
            resultHandler.handleSuccess(null, param);
        } else {
            service.addListener((ServiceListener)new UpdateResultHandler.ServiceRemoveListener(resultHandler, param));
        }
    }

    public AbstractSubsystemUpdate<MessagingSubsystemElement, ?> getCompensatingUpdate(MessagingSubsystemElement original) {
        QueueElement queue = original.getQueue(this.name);
        if (queue == null) {
            return null;
        }
        QueueAdd update = new QueueAdd(this.name);
        update.setAddress(queue.getAddress());
        update.setFilter(queue.getFilter());
        update.setDurable(queue.isDurable());
        return update;
    }
}

