/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.hornetq.core.security.Role;
import org.jboss.as.messaging.Attribute;
import org.jboss.as.messaging.Element;
import org.jboss.as.model.AbstractModelElement;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class SecuritySettingsElement
extends AbstractModelElement<SecuritySettingsElement> {
    private static final long serialVersionUID = -35697785671908094L;
    private final String match;
    private final Set<Role> roles;

    public SecuritySettingsElement(String match, Set<Role> roles) {
        this.match = match;
        this.roles = roles;
    }

    public void writeContent(XMLExtendedStreamWriter streamWriter) throws XMLStreamException {
        streamWriter.writeAttribute(Attribute.MATCH.getLocalName(), this.match);
        HashMap<Attribute, String> rolesByType = new HashMap<Attribute, String>();
        for (Role role : this.roles) {
            String name = role.getName();
            if (role.isConsume()) {
                this.storeRoleToType(Attribute.CONSUME_NAME, name, rolesByType);
            }
            if (role.isCreateDurableQueue()) {
                this.storeRoleToType(Attribute.CREATEDURABLEQUEUE_NAME, name, rolesByType);
            }
            if (role.isCreateNonDurableQueue()) {
                this.storeRoleToType(Attribute.CREATE_NON_DURABLE_QUEUE_NAME, name, rolesByType);
            }
            if (role.isDeleteDurableQueue()) {
                this.storeRoleToType(Attribute.DELETEDURABLEQUEUE_NAME, name, rolesByType);
            }
            if (role.isDeleteNonDurableQueue()) {
                this.storeRoleToType(Attribute.DELETE_NON_DURABLE_QUEUE_NAME, name, rolesByType);
            }
            if (role.isManage()) {
                this.storeRoleToType(Attribute.MANAGE_NAME, name, rolesByType);
            }
            if (!role.isSend()) continue;
            this.storeRoleToType(Attribute.SEND_NAME, name, rolesByType);
        }
        for (Map.Entry entry : rolesByType.entrySet()) {
            streamWriter.writeStartElement(Element.PERMISSION_ELEMENT_NAME.getLocalName());
            streamWriter.writeAttribute(Attribute.TYPE_ATTR_NAME.getLocalName(), ((Attribute)((Object)entry.getKey())).getLocalName());
            streamWriter.writeAttribute(Attribute.ROLES_ATTR_NAME.getLocalName(), (String)entry.getValue());
            streamWriter.writeEndElement();
        }
        streamWriter.writeEndElement();
    }

    private void storeRoleToType(Attribute type, String role, Map<Attribute, String> rolesByType) {
        String roleList = rolesByType.get((Object)type);
        roleList = roleList == null ? role : roleList + ", " + role;
        rolesByType.put(type, roleList);
    }

    protected Class<SecuritySettingsElement> getElementClass() {
        return SecuritySettingsElement.class;
    }

    public String getMatch() {
        return this.match;
    }

    public Set<Role> getRoles() {
        return this.roles;
    }
}

