/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import org.hornetq.jms.server.JMSServerManager;
import org.hornetq.jms.server.config.ConnectionFactoryConfiguration;
import org.jboss.as.messaging.jms.AbstractJMSSubsystemUpdate;
import org.jboss.as.messaging.jms.ConnectionFactoryElement;
import org.jboss.as.messaging.jms.ConnectionFactoryRemove;
import org.jboss.as.messaging.jms.ConnectionFactoryService;
import org.jboss.as.messaging.jms.JMSSubsystemElement;
import org.jboss.as.model.AbstractSubsystemUpdate;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;

public class ConnectionFactoryAdd
extends AbstractJMSSubsystemUpdate<Void> {
    private static final long serialVersionUID = -629127809193102926L;
    private final ConnectionFactoryElement cf;

    public ConnectionFactoryAdd(ConnectionFactoryElement cf) {
        this.cf = cf;
    }

    protected void applyUpdate(JMSSubsystemElement element) throws UpdateFailedException {
        if (!element.addConnectionFactory(this.cf)) {
            throw new UpdateFailedException("duplicate connection-factory " + this.cf.getName());
        }
    }

    protected <P> void applyUpdate(UpdateContext context, UpdateResultHandler<? super Void, P> handler, P param) {
        ConnectionFactoryService service = new ConnectionFactoryService(this.transform());
        ServiceName serviceName = JMSSubsystemElement.JMS_CF_BASE.append(new String[]{this.cf.getName()});
        context.getBatchBuilder().addService(serviceName, (Service)service).addDependency(JMSSubsystemElement.JMS_MANAGER, JMSServerManager.class, service.getJmsServer()).addListener((ServiceListener)new UpdateResultHandler.ServiceStartListener(handler, param)).setInitialMode(ServiceController.Mode.ACTIVE);
    }

    public AbstractSubsystemUpdate<JMSSubsystemElement, ?> getCompensatingUpdate(JMSSubsystemElement original) {
        return new ConnectionFactoryRemove(this.cf.getName());
    }

    private ConnectionFactoryConfiguration transform() {
        return this.cf.transform();
    }
}

