/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.hornetq.api.core.Pair;
import org.hornetq.jms.server.config.ConnectionFactoryConfiguration;
import org.hornetq.jms.server.config.impl.ConnectionFactoryConfigurationImpl;
import org.jboss.as.messaging.jms.Attribute;
import org.jboss.as.messaging.jms.ConnectionFactoryConnectorRef;
import org.jboss.as.messaging.jms.Element;
import org.jboss.as.model.AbstractModelElement;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class ConnectionFactoryElement
extends AbstractModelElement<ConnectionFactoryElement> {
    private static final long serialVersionUID = 7928155650456224886L;
    private final String name;
    private Set<String> bindings;
    private String discoveryGroupName;
    private String localBindAddress;
    private String discoveryAddress;
    private Integer discoveryPort;
    private String clientID = null;
    private Long discoveryRefreshTimeout;
    private Long clientFailureCheckPeriod;
    private Long connectionTTL;
    private Long callTimeout;
    private Boolean cacheLargeMessagesClient;
    private Integer minLargeMessageSize;
    private Integer consumerWindowSize;
    private Integer consumerMaxRate;
    private Integer confirmationWindowSize;
    private Integer producerWindowSize;
    private Integer producerMaxRate;
    private Boolean blockOnAcknowledge;
    private Boolean blockOnDurableSend;
    private Boolean blockOnNonDurableSend;
    private Boolean autoGroup;
    private Boolean preAcknowledge;
    private String loadBalancingPolicyClassName;
    private Integer transactionBatchSize;
    private Integer dupsOKBatchSize;
    private Long initialWaitTimeout;
    private Boolean useGlobalPools;
    private Integer scheduledThreadPoolMaxSize;
    private Integer threadPoolMaxSize;
    private Long retryInterval;
    private Double retryIntervalMultiplier;
    private Long maxRetryInterval;
    private Integer reconnectAttempts;
    private Boolean failoverOnInitialConnection;
    private Boolean failoverOnServerShutdown;
    private String groupID = null;
    private List<ConnectionFactoryConnectorRef> connectorRef;

    public ConnectionFactoryElement(String name) {
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getBindings() {
        return this.bindings;
    }

    public void setBindings(Set<String> bindings) {
        this.bindings = bindings;
    }

    public String getDiscoveryGroupName() {
        return this.discoveryGroupName;
    }

    public void setDiscoveryGroupName(String discoveryGroupName) {
        this.discoveryGroupName = discoveryGroupName;
    }

    public String getLocalBindAddress() {
        return this.localBindAddress;
    }

    public void setLocalBindAddress(String localBindAddress) {
        this.localBindAddress = localBindAddress;
    }

    public String getDiscoveryAddress() {
        return this.discoveryAddress;
    }

    public void setDiscoveryAddress(String discoveryAddress) {
        this.discoveryAddress = discoveryAddress;
    }

    public Integer getDiscoveryPort() {
        return this.discoveryPort;
    }

    public void setDiscoveryPort(Integer discoveryPort) {
        this.discoveryPort = discoveryPort;
    }

    public String getClientID() {
        return this.clientID;
    }

    public void setClientID(String clientID) {
        this.clientID = clientID;
    }

    public Long getDiscoveryRefreshTimeout() {
        return this.discoveryRefreshTimeout;
    }

    public void setDiscoveryRefreshTimeout(Long discoveryRefreshTimeout) {
        this.discoveryRefreshTimeout = discoveryRefreshTimeout;
    }

    public Long getClientFailureCheckPeriod() {
        return this.clientFailureCheckPeriod;
    }

    public void setClientFailureCheckPeriod(Long clientFailureCheckPeriod) {
        this.clientFailureCheckPeriod = clientFailureCheckPeriod;
    }

    public Long getConnectionTTL() {
        return this.connectionTTL;
    }

    public void setConnectionTTL(Long connectionTTL) {
        this.connectionTTL = connectionTTL;
    }

    public Long getCallTimeout() {
        return this.callTimeout;
    }

    public void setCallTimeout(Long callTimeout) {
        this.callTimeout = callTimeout;
    }

    public Boolean getCacheLargeMessagesClient() {
        return this.cacheLargeMessagesClient;
    }

    public void setCacheLargeMessagesClient(Boolean cacheLargeMessagesClient) {
        this.cacheLargeMessagesClient = cacheLargeMessagesClient;
    }

    public Integer getMinLargeMessageSize() {
        return this.minLargeMessageSize;
    }

    public void setMinLargeMessageSize(Integer minLargeMessageSize) {
        this.minLargeMessageSize = minLargeMessageSize;
    }

    public Integer getConsumerWindowSize() {
        return this.consumerWindowSize;
    }

    public void setConsumerWindowSize(Integer consumerWindowSize) {
        this.consumerWindowSize = consumerWindowSize;
    }

    public Integer getConsumerMaxRate() {
        return this.consumerMaxRate;
    }

    public void setConsumerMaxRate(Integer consumerMaxRate) {
        this.consumerMaxRate = consumerMaxRate;
    }

    public Integer getConfirmationWindowSize() {
        return this.confirmationWindowSize;
    }

    public void setConfirmationWindowSize(Integer confirmationWindowSize) {
        this.confirmationWindowSize = confirmationWindowSize;
    }

    public Integer getProducerWindowSize() {
        return this.producerWindowSize;
    }

    public void setProducerWindowSize(Integer producerWindowSize) {
        this.producerWindowSize = producerWindowSize;
    }

    public Integer getProducerMaxRate() {
        return this.producerMaxRate;
    }

    public void setProducerMaxRate(Integer producerMaxRate) {
        this.producerMaxRate = producerMaxRate;
    }

    public Boolean getBlockOnAcknowledge() {
        return this.blockOnAcknowledge;
    }

    public void setBlockOnAcknowledge(Boolean blockOnAcknowledge) {
        this.blockOnAcknowledge = blockOnAcknowledge;
    }

    public Boolean getBlockOnDurableSend() {
        return this.blockOnDurableSend;
    }

    public void setBlockOnDurableSend(Boolean blockOnDurableSend) {
        this.blockOnDurableSend = blockOnDurableSend;
    }

    public Boolean getBlockOnNonDurableSend() {
        return this.blockOnNonDurableSend;
    }

    public void setBlockOnNonDurableSend(Boolean blockOnNonDurableSend) {
        this.blockOnNonDurableSend = blockOnNonDurableSend;
    }

    public Boolean getAutoGroup() {
        return this.autoGroup;
    }

    public void setAutoGroup(Boolean autoGroup) {
        this.autoGroup = autoGroup;
    }

    public Boolean getPreAcknowledge() {
        return this.preAcknowledge;
    }

    public void setPreAcknowledge(Boolean preAcknowledge) {
        this.preAcknowledge = preAcknowledge;
    }

    public String getLoadBalancingPolicyClassName() {
        return this.loadBalancingPolicyClassName;
    }

    public void setLoadBalancingPolicyClassName(String loadBalancingPolicyClassName) {
        this.loadBalancingPolicyClassName = loadBalancingPolicyClassName;
    }

    public Integer getTransactionBatchSize() {
        return this.transactionBatchSize;
    }

    public void setTransactionBatchSize(Integer transactionBatchSize) {
        this.transactionBatchSize = transactionBatchSize;
    }

    public Integer getDupsOKBatchSize() {
        return this.dupsOKBatchSize;
    }

    public void setDupsOKBatchSize(Integer dupsOKBatchSize) {
        this.dupsOKBatchSize = dupsOKBatchSize;
    }

    public Long getInitialWaitTimeout() {
        return this.initialWaitTimeout;
    }

    public void setInitialWaitTimeout(Long initialWaitTimeout) {
        this.initialWaitTimeout = initialWaitTimeout;
    }

    public Boolean getUseGlobalPools() {
        return this.useGlobalPools;
    }

    public void setUseGlobalPools(Boolean useGlobalPools) {
        this.useGlobalPools = useGlobalPools;
    }

    public Integer getScheduledThreadPoolMaxSize() {
        return this.scheduledThreadPoolMaxSize;
    }

    public void setScheduledThreadPoolMaxSize(Integer scheduledThreadPoolMaxSize) {
        this.scheduledThreadPoolMaxSize = scheduledThreadPoolMaxSize;
    }

    public Integer getThreadPoolMaxSize() {
        return this.threadPoolMaxSize;
    }

    public void setThreadPoolMaxSize(Integer threadPoolMaxSize) {
        this.threadPoolMaxSize = threadPoolMaxSize;
    }

    public Long getRetryInterval() {
        return this.retryInterval;
    }

    public void setRetryInterval(Long retryInterval) {
        this.retryInterval = retryInterval;
    }

    public Double getRetryIntervalMultiplier() {
        return this.retryIntervalMultiplier;
    }

    public void setRetryIntervalMultiplier(Double retryIntervalMultiplier) {
        this.retryIntervalMultiplier = retryIntervalMultiplier;
    }

    public Long getMaxRetryInterval() {
        return this.maxRetryInterval;
    }

    public void setMaxRetryInterval(Long maxRetryInterval) {
        this.maxRetryInterval = maxRetryInterval;
    }

    public Integer getReconnectAttempts() {
        return this.reconnectAttempts;
    }

    public void setReconnectAttempts(Integer reconnectAttempts) {
        this.reconnectAttempts = reconnectAttempts;
    }

    public Boolean getFailoverOnInitialConnection() {
        return this.failoverOnInitialConnection;
    }

    public void setFailoverOnInitialConnection(Boolean failoverOnInitialConnection) {
        this.failoverOnInitialConnection = failoverOnInitialConnection;
    }

    public Boolean getFailoverOnServerShutdown() {
        return this.failoverOnServerShutdown;
    }

    public void setFailoverOnServerShutdown(Boolean failoverOnServerShutdown) {
        this.failoverOnServerShutdown = failoverOnServerShutdown;
    }

    public String getGroupID() {
        return this.groupID;
    }

    public void setGroupID(String groupID) {
        this.groupID = groupID;
    }

    public List<ConnectionFactoryConnectorRef> getConnectorRef() {
        return this.connectorRef;
    }

    public void setConnectorRef(List<ConnectionFactoryConnectorRef> connectorRef) {
        this.connectorRef = connectorRef;
    }

    protected Class<ConnectionFactoryElement> getElementClass() {
        return ConnectionFactoryElement.class;
    }

    public void writeContent(XMLExtendedStreamWriter streamWriter) throws XMLStreamException {
        streamWriter.writeAttribute(Attribute.NAME.getLocalName(), this.name);
        if (this.discoveryGroupName != null) {
            streamWriter.writeEmptyElement(Element.DISCOVERY_GROUP_REF.getLocalName());
            streamWriter.writeAttribute(Attribute.DISCOVERY_GROUP_NAME.getLocalName(), this.discoveryGroupName);
        }
        if (this.initialWaitTimeout != null) {
            ConnectionFactoryElement.writeSimpleElement(Element.DISCOVERY_INITIAL_WAIT_TIMEOUT, this.initialWaitTimeout.toString(), streamWriter);
        }
        if (this.connectorRef != null && !this.connectorRef.isEmpty()) {
            streamWriter.writeStartElement(Element.CONNECTORS.getLocalName());
            for (ConnectionFactoryConnectorRef ref : this.connectorRef) {
                streamWriter.writeEmptyElement(Element.CONNECTOR_REF.getLocalName());
                streamWriter.writeAttribute(Attribute.CONNECTOR_NAME.getLocalName(), ref.getConnectorName());
                if (ref.getBackupName() == null) continue;
                streamWriter.writeAttribute(Attribute.CONNECTOR_BACKUP_NAME.getLocalName(), ref.getBackupName());
            }
            streamWriter.writeEndElement();
        }
        if (this.bindings != null && this.bindings.size() > 0) {
            streamWriter.writeStartElement(Element.ENTRIES.getLocalName());
            for (String binding : this.bindings) {
                streamWriter.writeEmptyElement(Element.ENTRY.getLocalName());
                streamWriter.writeAttribute(Attribute.NAME.getLocalName(), binding);
            }
            streamWriter.writeEndElement();
        }
        if (this.clientFailureCheckPeriod != null) {
            ConnectionFactoryElement.writeSimpleElement(Element.CLIENT_FAILURE_CHECK_PERIOD, this.clientFailureCheckPeriod.toString(), streamWriter);
        }
        if (this.connectionTTL != null) {
            ConnectionFactoryElement.writeSimpleElement(Element.CONNECTION_TTL, this.connectionTTL.toString(), streamWriter);
        }
        if (this.callTimeout != null) {
            ConnectionFactoryElement.writeSimpleElement(Element.CALL_TIMEOUT, this.callTimeout.toString(), streamWriter);
        }
        if (this.consumerWindowSize != null) {
            ConnectionFactoryElement.writeSimpleElement(Element.CONSUMER_WINDOW_SIZE, this.consumerWindowSize.toString(), streamWriter);
        }
        if (this.consumerMaxRate != null) {
            ConnectionFactoryElement.writeSimpleElement(Element.CONSUMER_MAX_RATE, this.consumerMaxRate.toString(), streamWriter);
        }
        if (this.confirmationWindowSize != null) {
            ConnectionFactoryElement.writeSimpleElement(Element.CONFIRMATION_WINDOW_SIZE, this.confirmationWindowSize.toString(), streamWriter);
        }
        if (this.producerWindowSize != null) {
            ConnectionFactoryElement.writeSimpleElement(Element.PRODUCER_WINDOW_SIZE, this.producerWindowSize.toString(), streamWriter);
        }
        if (this.producerMaxRate != null) {
            ConnectionFactoryElement.writeSimpleElement(Element.PRODUCER_MAX_RATE, this.producerMaxRate.toString(), streamWriter);
        }
        if (this.cacheLargeMessagesClient != null) {
            ConnectionFactoryElement.writeSimpleElement(Element.CACHE_LARGE_MESSAGE_CLIENT, this.cacheLargeMessagesClient.toString(), streamWriter);
        }
        if (this.minLargeMessageSize != null) {
            ConnectionFactoryElement.writeSimpleElement(Element.MIN_LARGE_MESSAGE_SIZE, this.minLargeMessageSize.toString(), streamWriter);
        }
        if (this.clientID != null) {
            ConnectionFactoryElement.writeSimpleElement(Element.CLIENT_ID, this.clientID, streamWriter);
        }
        if (this.dupsOKBatchSize != null) {
            ConnectionFactoryElement.writeSimpleElement(Element.DUPS_OK_BATCH_SIZE, this.dupsOKBatchSize.toString(), streamWriter);
        }
        if (this.transactionBatchSize != null) {
            ConnectionFactoryElement.writeSimpleElement(Element.TRANSACTION_BATH_SIZE, this.transactionBatchSize.toString(), streamWriter);
        }
        if (this.blockOnAcknowledge != null) {
            ConnectionFactoryElement.writeSimpleElement(Element.BLOCK_ON_ACK, this.blockOnAcknowledge.toString(), streamWriter);
        }
        if (this.blockOnNonDurableSend != null) {
            ConnectionFactoryElement.writeSimpleElement(Element.BLOCK_ON_NON_DURABLE_SEND, this.blockOnNonDurableSend.toString(), streamWriter);
        }
        if (this.blockOnDurableSend != null) {
            ConnectionFactoryElement.writeSimpleElement(Element.BLOCK_ON_DURABLE_SEND, this.blockOnDurableSend.toString(), streamWriter);
        }
        if (this.autoGroup != null) {
            ConnectionFactoryElement.writeSimpleElement(Element.AUTO_GROUP, this.autoGroup.toString(), streamWriter);
        }
        if (this.preAcknowledge != null) {
            ConnectionFactoryElement.writeSimpleElement(Element.PRE_ACK, this.preAcknowledge.toString(), streamWriter);
        }
        if (this.retryInterval != null) {
            ConnectionFactoryElement.writeSimpleElement(Element.RETRY_INTERVAL, this.retryInterval.toString(), streamWriter);
        }
        if (this.retryIntervalMultiplier != null) {
            ConnectionFactoryElement.writeSimpleElement(Element.RETRY_INTERVAL_MULTIPLIER, this.retryIntervalMultiplier.toString(), streamWriter);
        }
        if (this.maxRetryInterval != null) {
            ConnectionFactoryElement.writeSimpleElement(Element.MAX_RETRY_INTERVAL, this.maxRetryInterval.toString(), streamWriter);
        }
        if (this.reconnectAttempts != null) {
            ConnectionFactoryElement.writeSimpleElement(Element.RECONNECT_ATTEMPTS, this.reconnectAttempts.toString(), streamWriter);
        }
        if (this.failoverOnInitialConnection != null) {
            ConnectionFactoryElement.writeSimpleElement(Element.FAILOVER_ON_INITIAL_CONNECTION, this.failoverOnInitialConnection.toString(), streamWriter);
        }
        if (this.failoverOnServerShutdown != null) {
            ConnectionFactoryElement.writeSimpleElement(Element.FAILOVER_ON_SERVER_SHUTDOWN, this.failoverOnServerShutdown.toString(), streamWriter);
        }
        if (this.loadBalancingPolicyClassName != null) {
            ConnectionFactoryElement.writeSimpleElement(Element.LOAD_BALANCING_CLASS_NAME, this.loadBalancingPolicyClassName, streamWriter);
        }
        if (this.useGlobalPools != null) {
            ConnectionFactoryElement.writeSimpleElement(Element.USE_GLOBAL_POOLS, this.useGlobalPools.toString(), streamWriter);
        }
        if (this.scheduledThreadPoolMaxSize != null) {
            ConnectionFactoryElement.writeSimpleElement(Element.SCHEDULED_THREAD_POOL_MAX_SIZE, this.scheduledThreadPoolMaxSize.toString(), streamWriter);
        }
        if (this.threadPoolMaxSize != null) {
            ConnectionFactoryElement.writeSimpleElement(Element.THREAD_POOL_MAX_SIZE, this.threadPoolMaxSize.toString(), streamWriter);
        }
        if (this.groupID != null) {
            ConnectionFactoryElement.writeSimpleElement(Element.GROUP_ID, this.groupID, streamWriter);
        }
        streamWriter.writeEndElement();
    }

    ConnectionFactoryConfiguration transform() {
        ConnectionFactoryConfigurationImpl configuration = new ConnectionFactoryConfigurationImpl(this.name, this.jndiBindings());
        if (this.discoveryGroupName != null) {
            if (this.initialWaitTimeout != null) {
                configuration.setInitialWaitTimeout(this.initialWaitTimeout.longValue());
            }
            if (this.discoveryGroupName != null) {
                configuration.setDiscoveryGroupName(this.discoveryGroupName);
            }
        } else if (this.connectorRef != null && !this.connectorRef.isEmpty()) {
            ArrayList<Pair> connectorNames = new ArrayList<Pair>();
            for (ConnectionFactoryConnectorRef ref : this.connectorRef) {
                connectorNames.add(new Pair((Object)ref.getConnectorName(), (Object)ref.getBackupName()));
            }
            configuration.setConnectorNames(connectorNames);
        }
        if (this.clientID != null) {
            configuration.setClientID(this.clientID);
        }
        if (this.clientFailureCheckPeriod != null) {
            configuration.setClientFailureCheckPeriod(this.clientFailureCheckPeriod.longValue());
        }
        if (this.connectionTTL != null) {
            configuration.setConnectionTTL(this.connectionTTL.longValue());
        }
        if (this.callTimeout != null) {
            configuration.setCallTimeout(this.callTimeout.longValue());
        }
        if (this.cacheLargeMessagesClient != null) {
            configuration.setCacheLargeMessagesClient(this.cacheLargeMessagesClient.booleanValue());
        }
        if (this.minLargeMessageSize != null) {
            configuration.setMinLargeMessageSize(this.minLargeMessageSize.intValue());
        }
        if (this.consumerWindowSize != null) {
            configuration.setConsumerWindowSize(this.consumerWindowSize.intValue());
        }
        if (this.consumerMaxRate != null) {
            configuration.setConsumerMaxRate(this.consumerMaxRate.intValue());
        }
        if (this.confirmationWindowSize != null) {
            configuration.setConfirmationWindowSize(this.confirmationWindowSize.intValue());
        }
        if (this.producerWindowSize != null) {
            configuration.setProducerWindowSize(this.producerWindowSize.intValue());
        }
        if (this.producerMaxRate != null) {
            configuration.setProducerMaxRate(this.producerMaxRate.intValue());
        }
        if (this.blockOnAcknowledge != null) {
            configuration.setBlockOnAcknowledge(this.blockOnAcknowledge.booleanValue());
        }
        if (this.blockOnDurableSend != null) {
            configuration.setBlockOnDurableSend(this.blockOnDurableSend.booleanValue());
        }
        if (this.blockOnNonDurableSend != null) {
            configuration.setBlockOnNonDurableSend(this.blockOnNonDurableSend.booleanValue());
        }
        if (this.autoGroup != null) {
            configuration.setAutoGroup(this.autoGroup.booleanValue());
        }
        if (this.preAcknowledge != null) {
            configuration.setPreAcknowledge(this.preAcknowledge.booleanValue());
        }
        if (this.loadBalancingPolicyClassName != null) {
            configuration.setLoadBalancingPolicyClassName(this.loadBalancingPolicyClassName);
        }
        if (this.transactionBatchSize != null) {
            configuration.setTransactionBatchSize(this.transactionBatchSize.intValue());
        }
        if (this.dupsOKBatchSize != null) {
            configuration.setDupsOKBatchSize(this.dupsOKBatchSize.intValue());
        }
        if (this.useGlobalPools != null) {
            configuration.setUseGlobalPools(this.useGlobalPools.booleanValue());
        }
        if (this.scheduledThreadPoolMaxSize != null) {
            configuration.setScheduledThreadPoolMaxSize(this.scheduledThreadPoolMaxSize.intValue());
        }
        if (this.threadPoolMaxSize != null) {
            configuration.setThreadPoolMaxSize(this.threadPoolMaxSize.intValue());
        }
        if (this.retryInterval != null) {
            configuration.setRetryInterval(this.retryInterval.longValue());
        }
        if (this.retryIntervalMultiplier != null) {
            configuration.setRetryIntervalMultiplier(this.retryIntervalMultiplier.doubleValue());
        }
        if (this.maxRetryInterval != null) {
            configuration.setMaxRetryInterval(this.maxRetryInterval.longValue());
        }
        if (this.reconnectAttempts != null) {
            configuration.setReconnectAttempts(this.reconnectAttempts.intValue());
        }
        if (this.failoverOnServerShutdown != null) {
            configuration.setFailoverOnServerShutdown(this.failoverOnServerShutdown.booleanValue());
        }
        if (this.failoverOnInitialConnection != null) {
            configuration.setFailoverOnInitialConnection(this.failoverOnInitialConnection.booleanValue());
        }
        if (this.groupID != null) {
            configuration.setGroupID(this.groupID);
        }
        return configuration;
    }

    private String[] jndiBindings() {
        if (this.bindings != null && !this.bindings.isEmpty()) {
            return this.bindings.toArray(new String[this.bindings.size()]);
        }
        return new String[0];
    }

    static void writeSimpleElement(Element element, String content, XMLExtendedStreamWriter streamWriter) throws XMLStreamException {
        if (content != null) {
            streamWriter.writeStartElement(element.getLocalName());
            streamWriter.writeCharacters(content);
            streamWriter.writeEndElement();
        }
    }
}

