/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import java.util.Set;
import org.hornetq.jms.server.JMSServerManager;
import org.jboss.as.messaging.jms.AbstractJMSSubsystemUpdate;
import org.jboss.as.messaging.jms.JMSQueueElement;
import org.jboss.as.messaging.jms.JMSQueueRemove;
import org.jboss.as.messaging.jms.JMSQueueService;
import org.jboss.as.messaging.jms.JMSSubsystemElement;
import org.jboss.as.model.AbstractSubsystemUpdate;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;

public class JMSQueueAdd
extends AbstractJMSSubsystemUpdate<Void> {
    private static final long serialVersionUID = 5900849533546313463L;
    private final String name;
    private Set<String> bindings;
    private String selector;
    private Boolean durable;

    static JMSQueueAdd create(JMSQueueElement queue) {
        JMSQueueAdd action = new JMSQueueAdd(queue.getName());
        action.bindings = queue.getBindings();
        action.selector = queue.getSelector();
        action.durable = queue.getDurable();
        return action;
    }

    public JMSQueueAdd(String name) {
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        this.name = name;
    }

    protected void applyUpdate(JMSSubsystemElement element) throws UpdateFailedException {
        JMSQueueElement queue = element.addQueue(this.name);
        if (queue == null) {
            throw new UpdateFailedException("duplicate queue " + this.name);
        }
        queue.setBindings(this.bindings);
        queue.setSelector(this.selector);
        queue.setDurable(this.durable);
    }

    protected <P> void applyUpdate(UpdateContext context, UpdateResultHandler<? super Void, P> handler, P param) {
        JMSQueueService service = new JMSQueueService(this.name, this.selector, this.durableDefault(), this.jndiBindings());
        ServiceName serviceName = JMSSubsystemElement.JMS_QUEUE_BASE.append(new String[]{this.name});
        context.getBatchBuilder().addService(serviceName, (Service)service).addDependency(JMSSubsystemElement.JMS_MANAGER, JMSServerManager.class, service.getJmsServer()).addListener((ServiceListener)new UpdateResultHandler.ServiceStartListener(handler, param)).setInitialMode(ServiceController.Mode.ACTIVE);
    }

    public AbstractSubsystemUpdate<JMSSubsystemElement, ?> getCompensatingUpdate(JMSSubsystemElement original) {
        return new JMSQueueRemove(this.name);
    }

    public Set<String> getBindings() {
        return this.bindings;
    }

    public void setBindings(Set<String> bindings) {
        this.bindings = bindings;
    }

    public String getSelector() {
        return this.selector;
    }

    public void setSelector(String selector) {
        this.selector = selector;
    }

    public Boolean getDurable() {
        return this.durable;
    }

    public void setDurable(Boolean durable) {
        this.durable = durable;
    }

    public String getName() {
        return this.name;
    }

    private boolean durableDefault() {
        if (this.durable != null) {
            return this.durable;
        }
        return true;
    }

    private String[] jndiBindings() {
        if (this.bindings != null && !this.bindings.isEmpty()) {
            return this.bindings.toArray(new String[this.bindings.size()]);
        }
        return new String[0];
    }
}

