/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.messaging.jms.Attribute;
import org.jboss.as.messaging.jms.Element;
import org.jboss.as.model.AbstractModelElement;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class JMSQueueElement
extends AbstractModelElement<JMSQueueElement> {
    private static final long serialVersionUID = 905901224008931245L;
    private final String name;
    private Set<String> bindings;
    private String selector;
    private Boolean durable;

    public JMSQueueElement(String name) {
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        this.name = name;
    }

    public Set<String> getBindings() {
        return this.bindings;
    }

    public void setBindings(Set<String> bindings) {
        this.bindings = bindings;
    }

    public String getSelector() {
        return this.selector;
    }

    public void setSelector(String selector) {
        this.selector = selector;
    }

    public Boolean getDurable() {
        return this.durable;
    }

    public void setDurable(Boolean durable) {
        this.durable = durable;
    }

    public String getName() {
        return this.name;
    }

    protected Class<JMSQueueElement> getElementClass() {
        return JMSQueueElement.class;
    }

    public void writeContent(XMLExtendedStreamWriter streamWriter) throws XMLStreamException {
        streamWriter.writeAttribute(Attribute.NAME.getLocalName(), this.name);
        if (this.bindings != null && this.bindings.size() > 0) {
            for (String binding : this.bindings) {
                streamWriter.writeEmptyElement(Element.ENTRY.getLocalName());
                streamWriter.writeAttribute(Attribute.NAME.getLocalName(), binding);
            }
        }
        if (this.selector != null) {
            streamWriter.writeEmptyElement(Element.SELECTOR.getLocalName());
            streamWriter.writeAttribute(Attribute.NAME.getLocalName(), this.selector);
        }
        if (this.durable != null) {
            streamWriter.writeStartElement(Element.DURABLE.getLocalName());
            streamWriter.writeCharacters(this.durable.toString());
            streamWriter.writeEndElement();
        }
        streamWriter.writeEndElement();
    }
}

