/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import javax.naming.Context;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.jms.server.JMSServerManager;
import org.hornetq.jms.server.impl.JMSServerManagerImpl;
import org.jboss.as.messaging.MessagingSubsystemElement;
import org.jboss.as.messaging.jms.JMSSubsystemElement;
import org.jboss.as.messaging.jms.SecurityActions;
import org.jboss.as.naming.service.JavaContextService;
import org.jboss.logging.Logger;
import org.jboss.msc.service.BatchBuilder;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class JMSService
implements Service<JMSServerManager> {
    private final InjectedValue<HornetQServer> hornetQServer = new InjectedValue();
    private final InjectedValue<Context> contextInjector = new InjectedValue();
    private JMSServerManager jmsServer;

    public static void addService(BatchBuilder builder) {
        JMSService service = new JMSService();
        builder.addService(JMSSubsystemElement.JMS_MANAGER, (Service)service).addDependency(MessagingSubsystemElement.JBOSS_MESSAGING, HornetQServer.class, service.getHornetQServer()).addDependency(JavaContextService.SERVICE_NAME, Context.class, service.getContextInjector()).setInitialMode(ServiceController.Mode.ACTIVE);
    }

    protected JMSService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start(StartContext context) throws StartException {
        try {
            JMSServerManagerImpl jmsServer = new JMSServerManagerImpl((HornetQServer)this.hornetQServer.getValue());
            Context jndiContext = (Context)this.contextInjector.getOptionalValue();
            if (jndiContext != null) {
                jmsServer.setContext(jndiContext);
            }
            try {
                ClassLoader loader = this.getClass().getClassLoader();
                SecurityActions.setContextClassLoader(loader);
                jmsServer.start();
            }
            finally {
                SecurityActions.setContextClassLoader(null);
            }
            this.jmsServer = jmsServer;
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
    }

    public synchronized void stop(StopContext context) {
        JMSServerManager jmsServer = this.jmsServer;
        this.jmsServer = null;
        try {
            jmsServer.stop();
        }
        catch (Exception e) {
            Logger.getLogger((String)"org.jboss.messaging").error((Object)"exception while stopping jms server", (Throwable)e);
        }
    }

    public synchronized JMSServerManager getValue() throws IllegalStateException {
        JMSServerManager jmsServer = this.jmsServer;
        if (jmsServer == null) {
            throw new IllegalStateException();
        }
        return jmsServer;
    }

    InjectedValue<HornetQServer> getHornetQServer() {
        return this.hornetQServer;
    }

    InjectedValue<Context> getContextInjector() {
        return this.contextInjector;
    }
}

