/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.messaging.MessagingSubsystemElement;
import org.jboss.as.messaging.jms.ConnectionFactoryAdd;
import org.jboss.as.messaging.jms.ConnectionFactoryElement;
import org.jboss.as.messaging.jms.Element;
import org.jboss.as.messaging.jms.JMSQueueAdd;
import org.jboss.as.messaging.jms.JMSQueueElement;
import org.jboss.as.messaging.jms.JMSSubsystemAdd;
import org.jboss.as.messaging.jms.JMSTopicAdd;
import org.jboss.as.messaging.jms.JMSTopicElement;
import org.jboss.as.messaging.jms.Namespace;
import org.jboss.as.model.AbstractSubsystemElement;
import org.jboss.as.model.AbstractSubsystemUpdate;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class JMSSubsystemElement
extends AbstractSubsystemElement<JMSSubsystemElement> {
    private static final long serialVersionUID = 3225118788089921849L;
    public static final ServiceName JMS = MessagingSubsystemElement.JBOSS_MESSAGING.append(new String[]{"jms"});
    public static final ServiceName JMS_MANAGER = JMS.append(new String[]{"manager"});
    public static final ServiceName JMS_QUEUE_BASE = JMS.append(new String[]{"queue"});
    public static final ServiceName JMS_TOPIC_BASE = JMS.append(new String[]{"topic"});
    public static final ServiceName JMS_CF_BASE = JMS.append(new String[]{"connection-factory"});
    private final NavigableMap<String, JMSQueueElement> queues = new TreeMap<String, JMSQueueElement>();
    private final NavigableMap<String, JMSTopicElement> topics = new TreeMap<String, JMSTopicElement>();
    private final NavigableMap<String, ConnectionFactoryElement> connectionFactories = new TreeMap<String, ConnectionFactoryElement>();

    protected JMSSubsystemElement() {
        super(Namespace.CURRENT.getUriString());
    }

    protected void getUpdates(List<? super AbstractSubsystemUpdate<JMSSubsystemElement, ?>> list) {
        for (ConnectionFactoryElement cf : this.connectionFactories.values()) {
            list.add(new ConnectionFactoryAdd(cf));
        }
        for (JMSQueueElement queue : this.queues.values()) {
            list.add(JMSQueueAdd.create(queue));
        }
        for (JMSTopicElement topic : this.topics.values()) {
            list.add(JMSTopicAdd.create(topic));
        }
    }

    protected boolean isEmpty() {
        return this.queues.isEmpty() && this.topics.isEmpty() && this.connectionFactories.isEmpty();
    }

    protected JMSSubsystemAdd getAdd() {
        return new JMSSubsystemAdd();
    }

    protected <P> void applyRemove(UpdateContext context, UpdateResultHandler<? super Void, P> resultHandler, P param) {
        ServiceController service = context.getServiceContainer().getService(JMS_MANAGER);
        if (service == null) {
            resultHandler.handleSuccess(null, param);
        } else {
            service.addListener((ServiceListener)new UpdateResultHandler.ServiceRemoveListener(resultHandler, param));
        }
    }

    boolean addConnectionFactory(ConnectionFactoryElement cf) {
        if (this.connectionFactories.containsKey(cf.getName())) {
            return false;
        }
        this.connectionFactories.put(cf.getName(), cf);
        return true;
    }

    public ConnectionFactoryElement getConnectionFactory(String name) {
        return (ConnectionFactoryElement)((Object)this.connectionFactories.get(name));
    }

    boolean removeConnectionFactory(String name) {
        return this.connectionFactories.remove(name) != null;
    }

    JMSQueueElement addQueue(String name) {
        if (this.queues.containsKey(name)) {
            return null;
        }
        JMSQueueElement queue = new JMSQueueElement(name);
        this.queues.put(name, queue);
        return queue;
    }

    public JMSQueueElement getQueue(String name) {
        return (JMSQueueElement)((Object)this.queues.get(name));
    }

    boolean removeQueue(String name) {
        return this.queues.remove(name) != null;
    }

    JMSTopicElement addTopic(String name) {
        if (this.topics.containsKey(name)) {
            return null;
        }
        JMSTopicElement topic = new JMSTopicElement(name);
        this.topics.put(name, topic);
        return topic;
    }

    public JMSTopicElement getTopic(String name) {
        return (JMSTopicElement)((Object)this.topics.get(name));
    }

    boolean removeTopic(String name) {
        return this.topics.remove(name) != null;
    }

    protected Class<JMSSubsystemElement> getElementClass() {
        return JMSSubsystemElement.class;
    }

    public void writeContent(XMLExtendedStreamWriter streamWriter) throws XMLStreamException {
        if (!this.connectionFactories.isEmpty()) {
            for (ConnectionFactoryElement cf : this.connectionFactories.values()) {
                streamWriter.writeStartElement(Element.CONNECTION_FACTORY.getLocalName());
                cf.writeContent(streamWriter);
            }
        }
        if (!this.queues.isEmpty()) {
            for (JMSQueueElement queue : this.queues.values()) {
                streamWriter.writeStartElement(Element.QUEUE.getLocalName());
                queue.writeContent(streamWriter);
            }
        }
        if (!this.topics.isEmpty()) {
            for (JMSTopicElement topic : this.topics.values()) {
                streamWriter.writeStartElement(Element.TOPIC.getLocalName());
                topic.writeContent(streamWriter);
            }
        }
        streamWriter.writeEndElement();
    }
}

