/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import java.util.Set;
import org.hornetq.jms.server.JMSServerManager;
import org.jboss.as.messaging.jms.AbstractJMSSubsystemUpdate;
import org.jboss.as.messaging.jms.JMSSubsystemElement;
import org.jboss.as.messaging.jms.JMSTopicElement;
import org.jboss.as.messaging.jms.JMSTopicRemove;
import org.jboss.as.messaging.jms.JMSTopicService;
import org.jboss.as.model.AbstractSubsystemUpdate;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;

public class JMSTopicAdd
extends AbstractJMSSubsystemUpdate<Void> {
    private static final long serialVersionUID = 3528505591156292231L;
    private final String name;
    private Set<String> bindings;

    static JMSTopicAdd create(JMSTopicElement topic) {
        JMSTopicAdd action = new JMSTopicAdd(topic.getName());
        action.bindings = topic.getBindings();
        return action;
    }

    public JMSTopicAdd(String name) {
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        this.name = name;
    }

    protected void applyUpdate(JMSSubsystemElement element) throws UpdateFailedException {
        JMSTopicElement topic = element.addTopic(this.name);
        if (topic == null) {
            throw new UpdateFailedException("duplicate topic " + this.name);
        }
        topic.setBindings(this.bindings);
    }

    protected <P> void applyUpdate(UpdateContext context, UpdateResultHandler<? super Void, P> handler, P param) {
        JMSTopicService service = new JMSTopicService(this.name, this.jndiBindings());
        ServiceName serviceName = JMSSubsystemElement.JMS_TOPIC_BASE.append(new String[]{this.name});
        context.getBatchBuilder().addService(serviceName, (Service)service).addDependency(JMSSubsystemElement.JMS_MANAGER, JMSServerManager.class, service.getJmsServer()).addListener((ServiceListener)new UpdateResultHandler.ServiceStartListener(handler, param)).setInitialMode(ServiceController.Mode.ACTIVE);
    }

    public AbstractSubsystemUpdate<JMSSubsystemElement, ?> getCompensatingUpdate(JMSSubsystemElement original) {
        return new JMSTopicRemove(this.name);
    }

    public Set<String> getBindings() {
        return this.bindings;
    }

    public void setBindings(Set<String> bindings) {
        this.bindings = bindings;
    }

    public String getName() {
        return this.name;
    }

    private String[] jndiBindings() {
        if (this.bindings != null && !this.bindings.isEmpty()) {
            return this.bindings.toArray(new String[this.bindings.size()]);
        }
        return new String[0];
    }
}

