/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import org.jboss.as.messaging.jms.AbstractJMSSubsystemUpdate;
import org.jboss.as.messaging.jms.JMSSubsystemElement;
import org.jboss.as.messaging.jms.JMSTopicAdd;
import org.jboss.as.messaging.jms.JMSTopicElement;
import org.jboss.as.model.AbstractSubsystemUpdate;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;

public class JMSTopicRemove
extends AbstractJMSSubsystemUpdate<Void> {
    private static final long serialVersionUID = 141328949523686903L;
    private final String topicName;

    public JMSTopicRemove(String topicName) {
        if (topicName == null) {
            throw new IllegalArgumentException("null name");
        }
        this.topicName = topicName;
    }

    protected void applyUpdate(JMSSubsystemElement element) throws UpdateFailedException {
        if (!element.removeTopic(this.topicName)) {
            throw new UpdateFailedException(String.format("topic (%s) does not exist", this.topicName));
        }
    }

    protected <P> void applyUpdate(UpdateContext context, UpdateResultHandler<? super Void, P> handler, P param) {
        ServiceController service = context.getServiceContainer().getService(JMSSubsystemElement.JMS_TOPIC_BASE.append(new String[]{this.topicName}));
        if (service == null) {
            handler.handleSuccess(null, param);
        } else {
            service.addListener((ServiceListener)new UpdateResultHandler.ServiceRemoveListener(handler, param));
        }
    }

    public AbstractSubsystemUpdate<JMSSubsystemElement, ?> getCompensatingUpdate(JMSSubsystemElement original) {
        JMSTopicElement element = original.getTopic(this.topicName);
        if (element == null) {
            return null;
        }
        JMSTopicAdd action = new JMSTopicAdd(this.topicName);
        action.setBindings(element.getBindings());
        return action;
    }
}

